/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_goals;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.setup.network.packets.BossPullEntityPacket;

public class PullBossGoal
extends Goal {
    private final Mob inquisitor;
    private final Class<? extends Player> playerClazz;
    private final int MAX_DISTANCE;
    private final int PHASE;
    private long lastCanUseCheck;

    public PullBossGoal(Mob inquisitor, Class<? extends Player> playerClazz, int phase) {
        this.inquisitor = inquisitor;
        this.playerClazz = playerClazz;
        this.PHASE = phase;
        this.MAX_DISTANCE = phase == 0 ? 24 : 32;
    }

    public boolean m_8036_() {
        long gameTime = this.inquisitor.f_19853_.m_46467_();
        if (gameTime - this.lastCanUseCheck < 100L) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        if (this.PHASE == 0) {
            Player player2 = this.findTarget();
            if (player2 == null) {
                return false;
            }
            if (Math.sqrt(this.inquisitor.m_20280_((Entity)player2)) > (double)this.MAX_DISTANCE) {
                return false;
            }
            ModNetwork.sendToServer(new BossPullEntityPacket(this.inquisitor.m_20148_(), player2.m_20148_(), -1, 0));
        } else if (this.PHASE == 1) {
            List<? extends Player> players = this.findTargets();
            players.forEach(player -> {
                if (Math.sqrt(this.inquisitor.m_20280_((Entity)player)) < (double)this.MAX_DISTANCE) {
                    ModNetwork.sendToServer(new BossPullEntityPacket(this.inquisitor.m_20148_(), player.m_20148_(), -1, 1));
                }
            });
        }
        return true;
    }

    private List<? extends Player> findTargets() {
        List players = null;
        TargetingConditions targetConditions = TargetingConditions.m_148352_().m_26888_(entity -> entity instanceof Player).m_26883_((double)this.MAX_DISTANCE);
        AABB aabb = this.inquisitor.m_20191_().m_82377_((double)this.MAX_DISTANCE, (double)this.MAX_DISTANCE, (double)this.MAX_DISTANCE);
        players = this.inquisitor.f_19853_.m_45971_(this.playerClazz, targetConditions, (LivingEntity)this.inquisitor, aabb);
        return players;
    }

    protected Player findTarget() {
        Player player = null;
        TargetingConditions targetConditions = TargetingConditions.m_148352_().m_26888_(entity -> entity instanceof Player).m_26883_((double)this.MAX_DISTANCE);
        player = this.inquisitor.f_19853_.m_45949_(targetConditions, (LivingEntity)this.inquisitor, this.inquisitor.m_20185_(), this.inquisitor.m_20188_(), this.inquisitor.m_20189_());
        return player;
    }
}

