/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.metal_minds;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.custom_tiers.CustomMaterials;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalmindType;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.abstracts.MetalmindAbstract;
import net.rudahee.metallics_arts.modules.effects.ModEffects;

public class AtiumMalatiumMetalmind
extends MetalmindAbstract {
    public AtiumMalatiumMetalmind(Item.Properties properties, MetalmindType type) {
        super(properties, MetalTagEnum.ATIUM, MetalTagEnum.MALATIUM, type);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> toolTips, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            if (!stack.m_41783_().m_128441_("tier_malatium_storage") || stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") == 0) {
                stack.m_41783_().m_128405_("tier_malatium_storage", -1);
            }
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(0).getNameLower() + "_feruchemic_reserve") / 20 + "s"));
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(1).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") + " ").m_7220_((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.uses")));
            } else {
                int maxReserve = this.isBand(MetalmindType.BAND) ? this.getMetals(0).getMaxReserveBand() : this.getMetals(0).getMaxReserveRing();
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(0).getNameLower() + "_feruchemic_reserve") * 100 / maxReserve + "%"));
                maxReserve = this.isBand(MetalmindType.BAND) ? this.getMetals(1).getMaxReserveBand() : this.getMetals(1).getMaxReserveRing();
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(1).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") * 100 / maxReserve + "%"));
            }
            if (level != null) {
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind.owner").m_130946_(": " + String.valueOf(stack.m_41783_().m_128461_("key").equals("Nobody") ? Component.m_237115_((String)"metallics_arts.metal_mind.nobody").getString() : (level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))) == null ? Component.m_237115_((String)"metallics_arts.metal_mind.owner_someone") : level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))).m_7755_().getString()))));
            }
            if (stack.m_41783_().m_128451_("tier_malatium_storage") != -1) {
                toolTips.add((Component)Component.m_237115_((String)"-------------------"));
                toolTips.add((Component)Component.m_237115_((String)("Tier: " + AtiumMalatiumMetalmind.convertTierToMaterial(stack.m_41783_().m_128451_("tier_malatium_storage")))));
            }
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237113_((String)" "));
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.shift_info").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    @Override
    public CompoundTag calculateSecondMetalDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalTapEffect(player, metal);
        if (this.isDecanting(player, compoundTag)) {
            compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", metalReserve - 1);
        }
        if (compoundTag.m_128451_(metal.getNameLower() + "_feruchemic_reserve") == 0) {
            compoundTag.m_128405_("tier_malatium_storage", -1);
        }
        return compoundTag;
    }

    @Override
    public CompoundTag calculateSecondMetalCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalStorageEffect(player, metal);
        if (this.isStoring(player, compoundTag)) {
            compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", metalReserve + 1);
        }
        return compoundTag;
    }

    private boolean isDecanting(Player player, CompoundTag compoundTag) {
        Item item = player.m_21205_().m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            if (tiered.m_43314_().m_6604_() == compoundTag.m_128451_("tier_malatium_storage")) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() == 0) {
                    return false;
                }
                player.m_21120_(InteractionHand.MAIN_HAND).m_41721_(player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() - 1);
                return true;
            }
            return false;
        }
        item = player.m_21205_().m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            int tier = AtiumMalatiumMetalmind.convertMaterialToTier(armorItem.m_40401_());
            if (tier == compoundTag.m_128451_("tier_malatium_storage")) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() == 0) {
                    return false;
                }
                player.m_21120_(InteractionHand.MAIN_HAND).m_41721_(player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() - 1);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isStoring(Player player, CompoundTag compoundTag) {
        ArmorItem armorItem;
        int tier;
        Item item;
        if (!compoundTag.m_128441_("tier_malatium_storage")) {
            compoundTag.m_128405_("tier_malatium_storage", -1);
        }
        if (compoundTag.m_128451_("tier_malatium_storage") == -1) {
            this.generateIternalReserve(player, compoundTag);
        }
        if ((item = player.m_21205_().m_41720_()) instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            if (tiered.m_43314_().m_6604_() == compoundTag.m_128451_("tier_malatium_storage")) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() == player.m_21120_(InteractionHand.MAIN_HAND).m_41776_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.NEUTRAL, 1.0f, 2.0f, true);
                    return false;
                }
                player.m_21120_(InteractionHand.MAIN_HAND).m_41721_(player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() + 1);
                return true;
            }
            return false;
        }
        item = player.m_21205_().m_41720_();
        if (item instanceof ArmorItem && (tier = AtiumMalatiumMetalmind.convertMaterialToTier((armorItem = (ArmorItem)item).m_40401_())) == compoundTag.m_128451_("tier_malatium_storage")) {
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() == player.m_21120_(InteractionHand.MAIN_HAND).m_41776_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                return false;
            }
            player.m_21120_(InteractionHand.MAIN_HAND).m_41721_(player.m_21120_(InteractionHand.MAIN_HAND).m_41773_() + 1);
            return true;
        }
        return false;
    }

    private void generateIternalReserve(Player player, CompoundTag compoundTag) {
        Item item = player.m_21205_().m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            compoundTag.m_128405_("tier_malatium_storage", tiered.m_43314_().m_6604_());
        }
        if ((item = player.m_21205_().m_41720_()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            compoundTag.m_128405_("tier_malatium_storage", AtiumMalatiumMetalmind.convertMaterialToTier(armorItem.m_40401_()));
        }
    }

    private static int convertMaterialToTier(ArmorMaterial material) {
        if (material.equals(ArmorMaterials.GOLD) || material.equals(ArmorMaterials.LEATHER)) {
            return 0;
        }
        if (material.equals(ArmorMaterials.TURTLE)) {
            return 1;
        }
        if (material.equals(ArmorMaterials.IRON) || material.equals(ArmorMaterials.CHAIN)) {
            return 2;
        }
        if (material.equals(ArmorMaterials.DIAMOND)) {
            return 3;
        }
        if (material.equals(ArmorMaterials.NETHERITE)) {
            return 4;
        }
        if (material.m_6082_().equals(CustomMaterials.STEEL.m_6082_()) || material.m_6082_().equals(CustomMaterials.ALUMINUM.m_6082_())) {
            return 6;
        }
        return -1;
    }

    private static String convertTierToMaterial(int tier) {
        if (tier == 0) {
            return Tiers.GOLD.name() + " " + ArmorMaterials.LEATHER.m_6082_().toUpperCase();
        }
        if (tier == 1) {
            return ArmorMaterials.TURTLE.m_6082_();
        }
        if (tier == 2) {
            return Tiers.IRON.name() + " " + ArmorMaterials.CHAIN.m_6082_().toUpperCase();
        }
        if (tier == 3) {
            return Tiers.DIAMOND.name();
        }
        if (tier == 4) {
            return Tiers.NETHERITE.name();
        }
        if (tier == 6) {
            return "post_netherite";
        }
        return "";
    }
}

