/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.vials;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import org.jetbrains.annotations.NotNull;

public abstract class Vial
extends Item {
    private final int maxNuggets;

    public Vial(Item.Properties properties, int maxNuggets) {
        super(properties);
        this.maxNuggets = maxNuggets;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> toolTips, @NotNull TooltipFlag flag) {
        if (!stack.m_41782_()) {
            stack.m_41751_(Vial.addVialTags());
        }
        if (!Screen.m_96638_()) {
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                if (stack.m_41783_().m_128451_(metal.getGemNameLower()) <= 0) continue;
                toolTips.add((Component)Component.m_237115_((String)" * ").m_7220_((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + metal.getNameLower()))).m_130946_(": " + stack.m_41783_().m_128451_(metal.getGemNameLower()) + "/" + this.maxNuggets));
            }
            if (this.hasAnyReserve(stack)) {
                toolTips.add((Component)Component.m_237115_((String)" "));
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.shift_info").m_130940_(ChatFormatting.BLUE));
            }
        } else {
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                if (stack.m_41783_().m_128451_(metal.getGemNameLower()) <= 0) continue;
                toolTips.add((Component)Component.m_237115_((String)" * ").m_7220_((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + metal.getNameLower()))).m_130946_(": " + this.time(stack.m_41783_().m_128451_(metal.getGemNameLower()) * metal.getChargeForNugget())));
            }
        }
        super.m_7373_(stack, level, toolTips, flag);
    }

    private String time(int timeTick) {
        int minutes = (timeTick /= 20) / 60;
        int remainingSeconds = timeTick % 60;
        return minutes + ":" + String.format("%02d", remainingSeconds);
    }

    private static boolean hasAllTags(CompoundTag tag) {
        boolean value = true;
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (tag.m_128441_(metal.getNameLower())) continue;
            value = false;
            break;
        }
        return value;
    }

    public static CompoundTag addVialTags() {
        CompoundTag nbt = new CompoundTag();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            nbt.m_128405_(metal.getNameLower(), 0);
        }
        return nbt;
    }

    public static CompoundTag addFullReserveVialTags() {
        CompoundTag nbt = new CompoundTag();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            nbt.m_128405_(metal.getNameLower(), 10);
        }
        return nbt;
    }

    public static CompoundTag addReserveVialTagsFromMetal(MetalTagEnum metal, int reserve) {
        CompoundTag nbt = new CompoundTag();
        if (nbt.m_128451_(metal.getGemNameLower()) == 0) {
            nbt.m_128405_(metal.getNameLower(), reserve);
        } else {
            nbt.m_128405_(metal.getNameLower(), nbt.m_128451_(metal.getGemNameLower()) + reserve);
        }
        nbt.m_128350_("CustomModelData", 1.0f);
        return nbt;
    }

    public static boolean hasFullReserveWithoutDivine(@NotNull ItemStack stack) {
        if (stack.m_41782_()) {
            List<MetalTagEnum> metals = Arrays.stream(MetalTagEnum.values()).filter(metalTagEnum -> !metalTagEnum.isDivine()).toList();
            for (MetalTagEnum metal : metals) {
                if (!stack.m_41783_().m_128441_(metal.getNameLower())) {
                    return false;
                }
                if (stack.m_41783_().m_128451_(metal.getNameLower()) == 10) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int status) {
        super.m_5551_(stack, level, livingEntity, status);
    }

    public boolean hasAnyReserve(ItemStack stack) {
        boolean have = false;
        if (stack.m_41782_()) {
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                if (!stack.m_41783_().m_128441_(metal.getNameLower()) || stack.m_41783_().m_128451_(metal.getNameLower()) <= 0) continue;
                have = true;
                break;
            }
        }
        return have;
    }

    public static boolean hasCompletedMetalReserve(ItemStack stack, MetalTagEnum metal) {
        boolean have = false;
        if (stack.m_41782_() && stack.m_41783_().m_128441_(metal.getNameLower()) && stack.m_41783_().m_128451_(metal.getNameLower()) == 10) {
            have = true;
        }
        return have;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStackIn = player.m_21120_(hand);
        if (!this.hasAnyReserve(itemStackIn)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStackIn);
        }
        player.m_6672_(hand);
        InteractionResultHolder res = player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).map(data -> {
            if (itemStackIn.m_41782_()) {
                for (MetalTagEnum metal : MetalTagEnum.values()) {
                    if (!itemStackIn.m_41783_().m_128441_(metal.getNameLower()) || itemStackIn.m_41783_().m_128451_(metal.getNameLower()) <= 0) continue;
                    player.m_6672_(hand);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
                }
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStackIn);
        }).orElse(new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStackIn));
        return res;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (!itemStack.m_41782_()) {
            return itemStack;
        }
        livingEntity.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(data -> {
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                if (!itemStack.m_41783_().m_128441_(metal.getNameLower()) || itemStack.m_41783_().m_128451_(metal.getNameLower()) <= 0) continue;
                data.setAllomanticMetalsAmount(metal, itemStack.m_41783_().m_128451_(metal.getNameLower()) * metal.getChargeForNugget() + data.getAllomanticAmount(metal));
            }
        });
        if (!((Player)livingEntity).m_150110_().f_35937_) {
            itemStack.m_41774_(1);
            ItemStack item = this.maxNuggets == 5 ? new ItemStack((ItemLike)ModItemsRegister.SMALL_VIAL.get()) : new ItemStack((ItemLike)ModItemsRegister.LARGE_VIAL.get());
            CompoundTag data2 = new CompoundTag();
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                data2.m_128405_(metal.getNameLower(), 0);
            }
            item.m_41751_(data2);
            if (!((Player)livingEntity).m_150109_().m_36054_(item)) {
                if (this.maxNuggets == 5) {
                    level.m_7967_((Entity)new ItemEntity(level, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), new ItemStack((ItemLike)ModItemsRegister.SMALL_VIAL.get(), 1)));
                } else {
                    level.m_7967_((Entity)new ItemEntity(level, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), new ItemStack((ItemLike)ModItemsRegister.LARGE_VIAL.get(), 1)));
                }
            }
        }
        return itemStack;
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return 32;
    }

    public boolean m_8120_(@NotNull ItemStack itemStack) {
        return false;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public boolean m_41472_() {
        return true;
    }
}

