/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.weapons.guns;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.enums.implementations.GunType;
import net.rudahee.metallics_arts.data.enums.implementations.GunsAccess;
import net.rudahee.metallics_arts.modules.custom_items.weapons.guns.GunUtils;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import org.jetbrains.annotations.Nullable;

public class BasicGun
extends ProjectileWeaponItem {
    private GunType gunType;
    private int tick = 0;

    public BasicGun(Item.Properties properties, GunType gunType) {
        super(properties);
        this.gunType = gunType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        CompoundTag tag = itemStack.m_41783_();
        tag.m_128350_("CustomModelData", 1.0f);
        if (tag.m_128461_(GunsAccess.STATE.getKey()).equals(GunsAccess.RELOAD.getKey())) {
            tag.m_128359_(GunsAccess.STATE.getKey(), GunsAccess.READY.getKey());
        }
        itemStack.m_41751_(tag);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int i) {
        ItemStack itemStack = livingEntity.m_21120_(InteractionHand.MAIN_HAND);
        CompoundTag tag = itemStack.m_41783_();
        tag.m_128350_("CustomModelData", 0.0f);
        itemStack.m_41751_(tag);
        super.m_5551_(stack, level, livingEntity, i);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int selectedSlot, boolean hasItemSelected) {
        if (!GunUtils.hasTags(stack.m_41783_())) {
            stack.m_41751_(GunUtils.generateGunTags(this.gunType));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21205_() == stack) {
                if (stack.m_41783_().m_128461_(GunsAccess.STATE.getKey()).equals(GunsAccess.RELOAD.getKey())) {
                    if (this.tick % this.gunType.getReload_cooldown() == 0) {
                        stack.m_41751_(GunUtils.reload(stack.m_41783_(), player, this.gunType));
                        this.tick = 0;
                    }
                    ++this.tick;
                }
            } else {
                stack.m_41783_().m_128359_(GunsAccess.STATE.getKey(), GunsAccess.READY.getKey());
                stack.m_41783_().m_128350_("CustomModelData", 0.0f);
            }
        }
        super.m_6883_(stack, level, entity, selectedSlot, hasItemSelected);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> toolTips, TooltipFlag flagIn) {
        if (!GunUtils.hasTags(stack.m_41783_())) {
            stack.m_41751_(GunUtils.generateGunTags(this.gunType));
        } else {
            toolTips.add((Component)Component.m_237115_((String)("util.metallics_arts.bullet_type." + stack.m_41783_().m_128461_(GunsAccess.BULLET_TYPE.getKey()))));
        }
        super.m_7373_(stack, level, toolTips, flagIn);
    }

    public boolean m_142522_(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(GunsAccess.BULLETS.getKey())) {
            return itemStack.m_41783_().m_128451_(GunsAccess.BULLETS.getKey()) > 0;
        }
        return false;
    }

    public int m_142158_(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(GunsAccess.BULLETS.getKey())) {
            return Math.round((float)itemStack.m_41783_().m_128451_(GunsAccess.BULLETS.getKey()) * 13.0f / (float)this.gunType.getMaxAmount());
        }
        return 0;
    }

    public GunType getGunType() {
        return this.gunType;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }

    public Predicate<ItemStack> m_6437_() {
        return itemStack -> itemStack.m_150930_((Item)ModItemsRegister.REVOLVER_LEAD_BULLET.get()) || itemStack.m_150930_((Item)ModItemsRegister.REVOLVER_ALUMINUM_BULLET.get());
    }

    public int m_6615_() {
        return 8;
    }
}

