/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.error_handling.exceptions;

import net.minecraftforge.common.util.NonNullSupplier;
import net.rudahee.metallics_arts.modules.error_handling.messages.ErrorTypes;
import net.rudahee.metallics_arts.modules.error_handling.messages.SeverityType;
import net.rudahee.metallics_arts.modules.error_handling.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;

public class PlayerDataException
extends Exception
implements NonNullSupplier<PlayerDataException> {
    private final ErrorTypes errorType;

    public PlayerDataException(ErrorTypes errorType) {
        this.errorType = errorType;
    }

    public ErrorTypes getErrorType() {
        return this.errorType;
    }

    @Override
    public String getMessage() {
        return this.errorType.getMessage();
    }

    public String getCode() {
        return this.errorType.getCode();
    }

    public SeverityType getSeverityType() {
        return this.errorType.getSeverityType();
    }

    public void printResumeLog() {
        LoggerUtils.printLog(this.getCode(), this.getMessage(), null, this.getSeverityType());
    }

    public void printCompleteLog() {
        LoggerUtils.printLog(this.getCode(), this.getMessage(), this.getStackTrace(), this.getSeverityType());
    }

    @NotNull
    public PlayerDataException get() {
        return this;
    }
}

