/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.error_handling.utils;

import javax.annotation.Nullable;
import lombok.Generated;
import net.rudahee.metallics_arts.modules.error_handling.messages.SeverityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggerUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(LoggerUtils.class);

    public static void printLog(String code, String message, @Nullable StackTraceElement[] stackTrace, SeverityType severity) {
        if (severity == SeverityType.INFO) {
            LoggerUtils.printLogInfo(code, message, stackTrace);
        } else if (severity == SeverityType.DEBUG) {
            LoggerUtils.printLogDebug(code, message, stackTrace);
        } else if (severity == SeverityType.WARN) {
            LoggerUtils.printLogWarn(code, message, stackTrace);
        } else if (severity == SeverityType.ERROR) {
            LoggerUtils.printLogError(code, message, stackTrace);
        } else if (severity == SeverityType.FATAL) {
            LoggerUtils.printLogFatal(code, message, stackTrace);
        } else {
            LoggerUtils.printLogWarn(code, message, stackTrace);
        }
    }

    public static void printLogInfo(String code, String message, @Nullable StackTraceElement[] stackTrace) {
        String messageBuilt = LoggerUtils.buildMessage(code, message, stackTrace);
        log.info(messageBuilt);
    }

    public static void printLogInfo(String message) {
        log.info(message);
    }

    public static void printLogDebug(String code, String message, @Nullable StackTraceElement[] stackTrace) {
        String messageBuilt = LoggerUtils.buildMessage(code, message, stackTrace);
        log.debug(messageBuilt);
    }

    public static void printLogDebug(String message) {
        log.debug(message);
    }

    public static void printLogWarn(String code, String message, @Nullable StackTraceElement[] stackTrace) {
        String messageBuilt = LoggerUtils.buildMessage(code, message, stackTrace);
        log.warn(messageBuilt);
    }

    public static void printLogWarn(String message) {
        log.warn(message);
    }

    public static void printLogError(String code, String message, @Nullable StackTraceElement[] stackTrace) {
        String messageBuilt = LoggerUtils.buildMessage(code, message, stackTrace);
        log.error(messageBuilt);
    }

    public static void printLogError(String message) {
        log.error(message);
    }

    public static void printLogFatal(String code, String message, @Nullable StackTraceElement[] stackTrace) {
        String messageBuilt = LoggerUtils.buildMessage(code, message, stackTrace);
        log.fatal(messageBuilt);
    }

    public static void printLogFatal(String message) {
        log.fatal(message);
    }

    private static String buildMessage(String code, String message, @Nullable StackTraceElement[] stackTrace) {
        StringBuilder messageBuilder = new StringBuilder(code + ": " + message);
        if (stackTrace != null && stackTrace.length != 0) {
            messageBuilder.append(" Stacktrace: \n");
            for (StackTraceElement trace : stackTrace) {
                messageBuilder.append(trace.toString()).append("\n");
            }
        }
        return messageBuilder.toString();
    }
}

