/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.server;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.custom_entities.allomancer.ettmetal_allomancer_entity.EttmetalAllomancerEntity;
import net.rudahee.metallics_arts.modules.custom_items.weapons.mele.KolossBlade;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnAttackBlockEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnDamageEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnJoinWorldEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnLivingEntityDropEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnPlayerCloneEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnSetSpawnEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnVillagerTradesEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.OnWorldTickEvent;
import net.rudahee.metallics_arts.modules.logic.server.server_events.entity_events.AllomancerEvents;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.setup.registries.ModVillagersRegister;
import net.rudahee.metallics_arts.utils.CapabilityUtils;

@Mod.EventBusSubscriber
public class ServerEventHandler {
    private static Integer tick;

    @SubscribeEvent
    public static void onLivingEntityDrop(LivingDropsEvent event) {
        OnLivingEntityDropEvent.livingEntityDrop(event);
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntity() instanceof ServerPlayer) {
            OnJoinWorldEvent.joinWorld(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            OnSetSpawnEvent.setSpawn(event);
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().m_20193_().m_5776_()) {
            ModNetwork.syncInvestedDataPacket(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            OnPlayerCloneEvent.playerClone(event);
        }
    }

    @SubscribeEvent
    public static void onDamageEvent(LivingHurtEvent event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        OnDamageEvent.onDamageToArmor(event, event.getEntity());
        if (event.getSource().m_7639_() instanceof ServerPlayer && event.getEntity() instanceof ServerPlayer) {
            OnDamageEvent.onDamageFeruchemical(event, (ServerPlayer)event.getSource().m_7639_(), (ServerPlayer)event.getEntity());
            OnDamageEvent.onDamageAllomantic(event, (ServerPlayer)event.getSource().m_7639_(), (ServerPlayer)event.getEntity());
        } else if (event.getSource().m_7640_() instanceof EttmetalAllomancerEntity) {
            AllomancerEvents.OnEttmetalAllomancerHit(event, (LivingEntity)event.getSource().m_7640_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onAttackBlock(PlayerInteractEvent.LeftClickBlock event) {
        OnAttackBlockEvent.hitBlock(event.getEntity(), event.getPos());
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType().f_35600_().equals(((VillagerProfession)ModVillagersRegister.FORGE_MASTER.get()).f_35600_())) {
            OnVillagerTradesEvent.onForgeMasterVillager(event);
        }
        if (event.getType().f_35600_().equals(((VillagerProfession)ModVillagersRegister.HEMALURGY_MONK.get()).f_35600_())) {
            OnVillagerTradesEvent.onHemalurgyMonkVillager(event);
        }
        if (event.getType().f_35600_().equals(((VillagerProfession)ModVillagersRegister.HEMALURGY_WARRIOR.get()).f_35600_())) {
            OnVillagerTradesEvent.onHemalurgyWarriorVillager(event);
        }
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side.isClient()) {
            return;
        }
        if (tick == null || tick >= 4800) {
            tick = 0;
        }
        Integer n = tick;
        tick = tick + 1;
        Level level = event.level;
        List playerList = level.m_6907_();
        for (Player player : playerList) {
            if (player == null) continue;
            IInvestedPlayerData capabilities = CapabilityUtils.getCapability(player);
            if (capabilities == null) {
                return;
            }
            OnWorldTickEvent.onWorldTick(capabilities, player, event.level, tick);
            if (!(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof KolossBlade) || tick % 180 != 0 || player.m_21120_(InteractionHand.MAIN_HAND).m_41783_().m_128457_("CustomModelData") == 1.0f) continue;
            ItemStack gun = player.m_21120_(InteractionHand.MAIN_HAND);
            CompoundTag compoundTag = gun.m_41783_();
            if (compoundTag != null) {
                compoundTag.m_128350_("CustomModelData", 1.0f);
            }
            gun.m_41751_(compoundTag);
        }
    }
}

