/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.physical_metals;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.rudahee.metallics_arts.data.configs.MetalListConfig;
import net.rudahee.metallics_arts.data.enums.implementations.languages.old.MetalAuxiliaryInfo;
import net.rudahee.metallics_arts.modules.custom_items.redstone.AllomanticLever;
import net.rudahee.metallics_arts.modules.custom_items.redstone.AllomanticPullButton;
import net.rudahee.metallics_arts.modules.custom_items.redstone.AllomanticPushButton;
import net.rudahee.metallics_arts.setup.registries.items.ModTags;

public class IronAndSteelHelpers {
    public static final byte PUSH = 1;
    public static final byte PULL = -1;
    private static final Pattern ACTIVE_METAL_REGEX = Pattern.compile(".*(iron|steel|tin_|pewter|zinc|brass|copper|bronze|duralumin|chromium|nicrosil|gold|electrum|cadmium|bendalloy|lead_|silver|platinum|nickle|nickel).*");

    public static boolean doesResourceContainsMetal(ResourceLocation input) {
        return ACTIVE_METAL_REGEX.matcher(input.m_135815_()).matches();
    }

    public static int haveNuggets(Player player) {
        ArrayList<Ingredient> arrayList = new ArrayList<Ingredient>();
        for (MetalAuxiliaryInfo metal : MetalAuxiliaryInfo.values()) {
            if (metal.getId().equals(MetalAuxiliaryInfo.IRON.getId()) || metal.getId().equals(MetalAuxiliaryInfo.GOLD.getId()) || metal.getId().equals(MetalAuxiliaryInfo.ALUMINUM.getId()) || metal.getId().equals(MetalAuxiliaryInfo.SILVER.getId())) continue;
            arrayList.add(Ingredient.m_204132_(ModTags.NUGGETS.get(metal.getId())));
        }
        arrayList.add(Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_IRON));
        arrayList.add(Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_GOLD));
        for (ItemStack stack : player.m_150109_().f_35974_) {
            for (Ingredient ing : arrayList) {
                if (!ing.test(stack)) continue;
                return player.m_150109_().m_36030_(stack);
            }
        }
        return -1;
    }

    public static boolean isBlockStateMetal(BlockState state) {
        return IronAndSteelHelpers.isBlockMetal(state.m_60734_());
    }

    public static boolean isBlockMetal(Block block) {
        return IronAndSteelHelpers.isOnWhitelist(block.m_7705_());
    }

    public static boolean isItemMetal(ItemStack item) {
        return IronAndSteelHelpers.isOnWhitelist(item.m_41720_().m_41466_().toString());
    }

    private static boolean isOnWhitelist(String s) {
        return MetalListConfig.whitelist.stream().anyMatch(ws -> s.contains((CharSequence)ws));
    }

    public static boolean isEntityMetal(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof ItemEntity) {
            return IronAndSteelHelpers.isItemMetal(((ItemEntity)entity).m_32055_());
        }
        if (entity instanceof ItemFrame) {
            return IronAndSteelHelpers.isItemMetal(((ItemFrame)entity).m_31822_());
        }
        if (entity instanceof FallingBlockEntity) {
            return IronAndSteelHelpers.isBlockStateMetal(((FallingBlockEntity)entity).m_31980_());
        }
        if (entity instanceof AbstractMinecart) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            if (ent instanceof IronGolem) {
                return true;
            }
            if (IronAndSteelHelpers.isItemMetal(ent.m_21120_(InteractionHand.MAIN_HAND)) || IronAndSteelHelpers.isItemMetal(ent.m_21120_(InteractionHand.MAIN_HAND))) {
                return true;
            }
            for (ItemStack itemStack : ent.m_6168_()) {
                if (!IronAndSteelHelpers.isItemMetal(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    private static Vec3 clamp(Vec3 value, Vec3 min, Vec3 max) {
        return new Vec3(Mth.m_14008_((double)value.f_82479_, (double)min.f_82479_, (double)max.f_82479_), Mth.m_14008_((double)value.f_82480_, (double)min.f_82480_, (double)max.f_82480_), Mth.m_14008_((double)value.f_82481_, (double)min.f_82481_, (double)max.f_82481_));
    }

    private static Vec3 abs(Vec3 vec) {
        return new Vec3(Math.abs(vec.f_82479_), Math.abs(vec.f_82480_), Math.abs(vec.f_82481_));
    }

    private static Vec3 cutoff(Vec3 value, double e) {
        Vec3 mag = IronAndSteelHelpers.abs(value);
        return new Vec3(mag.f_82479_ < e ? 0.0 : value.f_82479_, mag.f_82480_ < e ? 0.0 : value.f_82480_, mag.f_82481_ < e ? 0.0 : value.f_82481_);
    }

    public static void move(double directionScalar, Entity toMove, BlockPos block) {
        IronAndSteelHelpers.move(directionScalar, toMove, block, false);
    }

    public static void move(double directionScalar, Entity toMove, BlockPos block, @Nullable Boolean weightModified) {
        if (toMove.m_20159_()) {
            toMove = toMove.m_20202_();
        }
        Vec3 motion = weightModified == null || weightModified == false ? toMove.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)block)).m_82541_().m_82490_(directionScalar * 1.1) : toMove.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)block)).m_82541_().m_82490_(directionScalar * 1.6);
        Vec3 mod = IronAndSteelHelpers.clamp(IronAndSteelHelpers.cutoff(motion.m_82549_(toMove.m_20184_()), 0.1), IronAndSteelHelpers.abs(motion).m_82548_(), IronAndSteelHelpers.abs(motion));
        toMove.m_20256_(mod);
        toMove.f_19864_ = true;
        if (toMove instanceof ServerPlayer) {
            toMove.f_19789_ = 0.0f;
        }
    }

    public static float getMultiplier(boolean duralumin, boolean lerasium, boolean feruchemicSteel) {
        if (duralumin && lerasium && feruchemicSteel) {
            return 9.0f;
        }
        if (duralumin && lerasium) {
            return 8.0f;
        }
        if (duralumin && feruchemicSteel) {
            return 7.0f;
        }
        if (duralumin) {
            return 5.0f;
        }
        if (lerasium && feruchemicSteel) {
            return 4.0f;
        }
        if (lerasium) {
            return 3.0f;
        }
        if (feruchemicSteel) {
            return 2.0f;
        }
        return 1.0f;
    }

    public static boolean isAllomanticLever(BlockState state) {
        return state.m_60734_() instanceof AllomanticLever;
    }

    public static boolean isAllomanticPushButton(BlockState state) {
        return state.m_60734_() instanceof AllomanticPushButton;
    }

    public static boolean isAllomanticPullButton(BlockState state) {
        return state.m_60734_() instanceof AllomanticPullButton;
    }
}

