/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.server.server_events.on_world_tick;

import net.minecraft.world.entity.player.Player;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.cognitive_metals.BrassFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.cognitive_metals.BronzeFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.cognitive_metals.CopperFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.god_metals.AtiumFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.hybrid_metals.BendalloyFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.hybrid_metals.CadmiumFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.hybrid_metals.ElectrumFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.hybrid_metals.GoldFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.physical_metals.IronFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.physical_metals.PewterFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.physical_metals.SteelFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.physical_metals.TinFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.spiritual_metals.ChromiumFeruchemicHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.spiritual_metals.DuraluminFeruchemicHelper;

public class FeruchemicTick {
    public static void each5Ticks(IInvestedPlayerData playerCapability, Player player) {
        if (FeruchemicTick.isTappingOrStorageAny(playerCapability, MetalTagEnum.ATIUM)) {
            FeruchemicTick.godMetalsEach5Ticks(playerCapability, player);
        }
        if (FeruchemicTick.isTappingOrStorageAny(playerCapability, MetalTagEnum.IRON, MetalTagEnum.STEEL, MetalTagEnum.TIN, MetalTagEnum.PEWTER)) {
            FeruchemicTick.physicalMetalsEach5Ticks(playerCapability, player);
        }
        if (FeruchemicTick.isTappingOrStorageAny(playerCapability, MetalTagEnum.DURALUMIN, MetalTagEnum.CHROMIUM)) {
            FeruchemicTick.spiritualMetalsEach5Ticks(playerCapability, player);
        }
    }

    public static void eachTick(IInvestedPlayerData playerCapability, Player player) {
        if (FeruchemicTick.isTappingOrStorageAny(playerCapability, MetalTagEnum.BRASS, MetalTagEnum.COPPER) || playerCapability.isTapping(MetalTagEnum.BRONZE)) {
            FeruchemicTick.cognitiveMetals(playerCapability, player);
        }
        if (FeruchemicTick.isTappingOrStorageAny(playerCapability, MetalTagEnum.ELECTRUM) || playerCapability.isStoring(MetalTagEnum.CADMIUM)) {
            FeruchemicTick.hybridMetals(playerCapability, player);
        } else {
            ElectrumFeruchemicHelper.restoreHearts(player);
        }
    }

    public static void each40Tick(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isStoring(MetalTagEnum.BRONZE)) {
            FeruchemicTick.cognitiveMetalsEach40Ticks(playerCapability, player);
        }
        if (FeruchemicTick.isTappingOrStorageAny(playerCapability, MetalTagEnum.BENDALLOY, MetalTagEnum.GOLD) || playerCapability.isTapping(MetalTagEnum.CADMIUM)) {
            FeruchemicTick.hybridMetalsEach40Ticks(playerCapability, player);
        }
    }

    public static boolean isTappingOrStorageAny(IInvestedPlayerData playerCapability, MetalTagEnum ... metals) {
        for (MetalTagEnum metal : metals) {
            if (!playerCapability.isStoring(metal) && !playerCapability.isTapping(metal)) continue;
            return true;
        }
        return false;
    }

    private static void cognitiveMetals(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isTapping(MetalTagEnum.BRASS)) {
            BrassFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.BRASS)) {
            BrassFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.BRONZE)) {
            BronzeFeruchemicHelper.tapPower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.COPPER)) {
            CopperFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.COPPER)) {
            CopperFeruchemicHelper.storagePower(player);
        }
    }

    private static void cognitiveMetalsEach40Ticks(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isStoring(MetalTagEnum.BRONZE)) {
            BronzeFeruchemicHelper.storagePower(player);
        }
    }

    private static void godMetalsEach5Ticks(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isTapping(MetalTagEnum.ATIUM)) {
            AtiumFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.ATIUM)) {
            AtiumFeruchemicHelper.storagePower(player);
        }
    }

    private static void hybridMetalsEach40Ticks(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isTapping(MetalTagEnum.GOLD)) {
            if (playerCapability.isBurning(MetalTagEnum.GOLD)) {
                GoldFeruchemicHelper.tapCompoundingPower(player);
            } else {
                GoldFeruchemicHelper.tapPower(player);
            }
        } else if (playerCapability.isStoring(MetalTagEnum.GOLD)) {
            GoldFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.CADMIUM)) {
            CadmiumFeruchemicHelper.tapPower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.BENDALLOY)) {
            if (playerCapability.isBurning(MetalTagEnum.BENDALLOY)) {
                BendalloyFeruchemicHelper.tapCompoundingPower(player);
            } else {
                BendalloyFeruchemicHelper.tapPower(player);
            }
        } else if (playerCapability.isStoring(MetalTagEnum.BENDALLOY)) {
            BendalloyFeruchemicHelper.storagePower(player);
        }
    }

    private static void hybridMetals(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isTapping(MetalTagEnum.ELECTRUM)) {
            if (playerCapability.isBurning(MetalTagEnum.ELECTRUM)) {
                ElectrumFeruchemicHelper.tapCompoundingPower(player);
            } else {
                ElectrumFeruchemicHelper.tapPower(player);
            }
        } else if (playerCapability.isStoring(MetalTagEnum.ELECTRUM)) {
            ElectrumFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isStoring(MetalTagEnum.CADMIUM)) {
            CadmiumFeruchemicHelper.storagePower(player);
        }
    }

    private static void physicalMetalsEach5Ticks(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isTapping(MetalTagEnum.IRON)) {
            if (playerCapability.isBurning(MetalTagEnum.IRON)) {
                IronFeruchemicHelper.tapCompoundingPower(player);
            } else {
                IronFeruchemicHelper.tapPower(player);
            }
        } else if (playerCapability.isStoring(MetalTagEnum.IRON)) {
            IronFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.STEEL)) {
            if (playerCapability.isBurning(MetalTagEnum.STEEL)) {
                SteelFeruchemicHelper.tapCompoundingPower(player);
            } else {
                SteelFeruchemicHelper.tapPower(player);
            }
        } else if (playerCapability.isStoring(MetalTagEnum.STEEL)) {
            SteelFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.TIN)) {
            TinFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.TIN)) {
            TinFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.PEWTER)) {
            PewterFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.PEWTER)) {
            PewterFeruchemicHelper.storagePower(player);
        }
    }

    private static void spiritualMetalsEach5Ticks(IInvestedPlayerData playerCapability, Player player) {
        if (playerCapability.isTapping(MetalTagEnum.DURALUMIN)) {
            DuraluminFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.DURALUMIN)) {
            DuraluminFeruchemicHelper.storagePower(player);
        }
        if (playerCapability.isTapping(MetalTagEnum.CHROMIUM)) {
            ChromiumFeruchemicHelper.tapPower(player);
        } else if (playerCapability.isStoring(MetalTagEnum.CHROMIUM)) {
            ChromiumFeruchemicHelper.storagePower(player);
        }
    }
}

