/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network;

import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.setup.network.packets.AnotherPlayerDeathPosPacket;
import net.rudahee.metallics_arts.setup.network.packets.BossPullEntityPacket;
import net.rudahee.metallics_arts.setup.network.packets.BossPushEntityPacket;
import net.rudahee.metallics_arts.setup.network.packets.ChangeAmmoGunPacket;
import net.rudahee.metallics_arts.setup.network.packets.ChangeEmotionPacket;
import net.rudahee.metallics_arts.setup.network.packets.FiringGunPacket;
import net.rudahee.metallics_arts.setup.network.packets.InvestedDataPacket;
import net.rudahee.metallics_arts.setup.network.packets.PullAndPushBlockPacket;
import net.rudahee.metallics_arts.setup.network.packets.PullAndPushEntityPacket;
import net.rudahee.metallics_arts.setup.network.packets.PullAndPushNuggetPacket;
import net.rudahee.metallics_arts.setup.network.packets.RedstoneSignalsPacket;
import net.rudahee.metallics_arts.setup.network.packets.ReloadGunPacket;
import net.rudahee.metallics_arts.setup.network.packets.RemoveNuggetPacket;
import net.rudahee.metallics_arts.setup.network.packets.RespawnPositionPacket;
import net.rudahee.metallics_arts.setup.network.packets.UpdateBurnPacket;
import net.rudahee.metallics_arts.setup.network.packets.UpdateStoragePacket;
import net.rudahee.metallics_arts.setup.network.packets.UpdateTapPacket;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class ModNetwork {
    private static final String VERSION = "1.8.0";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("metallics_arts", "network_tunnel"), () -> "1.8.0", "1.8.0"::equals, "1.8.0"::equals);
    private static int index = 0;

    private static int nextIndex() {
        return index++;
    }

    public static void registerPackets() {
        INSTANCE.registerMessage(ModNetwork.nextIndex(), InvestedDataPacket.class, InvestedDataPacket::encode, InvestedDataPacket::decode, InvestedDataPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), UpdateBurnPacket.class, UpdateBurnPacket::encode, UpdateBurnPacket::decode, UpdateBurnPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), ChangeEmotionPacket.class, ChangeEmotionPacket::encode, ChangeEmotionPacket::decode, ChangeEmotionPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), PullAndPushBlockPacket.class, PullAndPushBlockPacket::encode, PullAndPushBlockPacket::decode, PullAndPushBlockPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), PullAndPushNuggetPacket.class, PullAndPushNuggetPacket::encode, PullAndPushNuggetPacket::decode, PullAndPushNuggetPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), PullAndPushEntityPacket.class, PullAndPushEntityPacket::encode, PullAndPushEntityPacket::decode, PullAndPushEntityPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), BossPullEntityPacket.class, BossPullEntityPacket::encode, BossPullEntityPacket::decode, BossPullEntityPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), BossPushEntityPacket.class, BossPushEntityPacket::encode, BossPushEntityPacket::decode, BossPushEntityPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), UpdateTapPacket.class, UpdateTapPacket::encode, UpdateTapPacket::decode, UpdateTapPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), UpdateStoragePacket.class, UpdateStoragePacket::encode, UpdateStoragePacket::decode, UpdateStoragePacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), RemoveNuggetPacket.class, RemoveNuggetPacket::encode, RemoveNuggetPacket::decode, RemoveNuggetPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), RespawnPositionPacket.class, RespawnPositionPacket::encode, RespawnPositionPacket::decode, RespawnPositionPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), AnotherPlayerDeathPosPacket.class, AnotherPlayerDeathPosPacket::encode, AnotherPlayerDeathPosPacket::decode, AnotherPlayerDeathPosPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), RedstoneSignalsPacket.class, RedstoneSignalsPacket::encode, RedstoneSignalsPacket::decode, RedstoneSignalsPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), FiringGunPacket.class, FiringGunPacket::encode, FiringGunPacket::decode, FiringGunPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), ReloadGunPacket.class, ReloadGunPacket::encode, ReloadGunPacket::decode, ReloadGunPacket::handle);
        INSTANCE.registerMessage(ModNetwork.nextIndex(), ChangeAmmoGunPacket.class, ChangeAmmoGunPacket::encode, ChangeAmmoGunPacket::decode, ChangeAmmoGunPacket::handle);
    }

    public static void sendToServer(Object msg) {
        INSTANCE.sendToServer(msg);
    }

    public static void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            INSTANCE.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendTo(Object msg, PacketDistributor.PacketTarget target) {
        INSTANCE.send(target, msg);
    }

    public static void syncInvestedDataPacket(Player player) {
        player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(data -> ModNetwork.syncInvestedDataPacket(data, player));
    }

    public static void syncInvestedDataPacket(IInvestedPlayerData capability, Player player) {
        ModNetwork.sync(new InvestedDataPacket(capability, player), player);
    }

    public static void syncRespawnPosPacket(GlobalPos pos, Player player) {
        ModNetwork.sync(new RespawnPositionPacket(player, pos), player);
    }

    public static void syncAnotherPlayerDeathPos(GlobalPos pos, Player player) {
        ModNetwork.sync(new AnotherPlayerDeathPosPacket(player, pos), player);
    }

    public static void sync(Object msg, Player player) {
        ModNetwork.sendTo(msg, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }
}

