/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.modules.logic.client.client_events.OnRenderLevelStage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AnotherPlayerDeathPosPacket {
    private final UUID uuid;
    private GlobalPos pos;

    public AnotherPlayerDeathPosPacket(Player player, @NonNull GlobalPos pos) {
        this.uuid = player.m_20148_();
        this.pos = pos;
    }

    private AnotherPlayerDeathPosPacket(UUID uuid, @NonNull GlobalPos pos) {
        this.uuid = uuid;
        this.pos = pos;
    }

    public static AnotherPlayerDeathPosPacket decode(FriendlyByteBuf buf) {
        UUID uuidLocal = buf.m_130259_();
        GlobalPos posLocal = buf.m_236872_();
        if (posLocal == null) {
            posLocal = GlobalPos.m_122643_((ResourceKey)Level.f_46428_, (BlockPos)new BlockPos(Minecraft.m_91087_().f_91073_.m_6106_().m_6789_(), Minecraft.m_91087_().f_91073_.m_6106_().m_6527_(), Minecraft.m_91087_().f_91073_.m_6106_().m_6526_()));
        }
        return new AnotherPlayerDeathPosPacket(uuidLocal, posLocal);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_236814_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OnRenderLevelStage.setAnotherPlayerDeathPos(this.pos));
        ctx.get().setPacketHandled(true);
    }
}

