/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.mental_metals.BrassAllomanticHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.mental_metals.ZincAllomanticHelper;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class ChangeEmotionPacket {
    private final int entityID;
    private final boolean makeAggressive;
    private static boolean enhanced;

    public ChangeEmotionPacket(int entityID, boolean makeAggressive) {
        this.entityID = entityID;
        this.makeAggressive = makeAggressive;
    }

    public static ChangeEmotionPacket decode(FriendlyByteBuf buf) {
        return new ChangeEmotionPacket(buf.readInt(), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.makeAggressive);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer allomancer = ((NetworkEvent.Context)ctx.get()).getSender();
            Mob target = (Mob)allomancer.f_19853_.m_6815_(this.entityID);
            if (target == null) {
                return;
            }
            allomancer.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(data -> {
                enhanced = data.getEnhanced();
            });
            if (this.makeAggressive) {
                if (enhanced) {
                    ZincAllomanticHelper.angryEntitiesEnhanced(target, (Player)allomancer);
                } else {
                    ZincAllomanticHelper.angryEntities(target, (Player)allomancer);
                }
            } else if (enhanced) {
                BrassAllomanticHelper.happyEntitiesEnhanced(target, (Player)allomancer);
            } else {
                BrassAllomanticHelper.happyEntities(target, (Player)allomancer);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

