/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class InvestedDataPacket {
    private final CompoundTag tag;
    private final UUID uuid;

    public InvestedDataPacket(IInvestedPlayerData data, Player player) {
        this.uuid = player.m_20148_();
        this.tag = data != null && InvestedPlayerCapabilityRegister.PLAYER_CAP != null ? data.save() : new CompoundTag();
    }

    private InvestedDataPacket(CompoundTag tag, UUID uuid) {
        this.tag = tag;
        this.uuid = uuid;
    }

    public static InvestedDataPacket decode(FriendlyByteBuf buf) {
        return new InvestedDataPacket(buf.m_130260_(), buf.m_130259_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(this.uuid);
            if (player != null && InvestedPlayerCapabilityRegister.PLAYER_CAP != null) {
                player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(cap -> cap.load(this.tag));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

