/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.utils.FoundNearbyMetalUtils;

public class NearbyInvestedPacket {
    private final UUID uuid;
    private final int qty;
    private final List<BlockPos> pos;

    public NearbyInvestedPacket(Player player, int qty, List<BlockPos> pos) {
        this.uuid = player.m_20148_();
        this.qty = qty;
        this.pos = pos;
    }

    private NearbyInvestedPacket(UUID uuid, int qty, List<BlockPos> pos) {
        this.uuid = uuid;
        this.qty = qty;
        this.pos = pos;
    }

    public static NearbyInvestedPacket decode(FriendlyByteBuf buf) {
        UUID uuid = buf.m_130259_();
        int qty = buf.readInt();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = 0; i < qty; ++i) {
            posList.add(buf.m_130135_());
        }
        return new NearbyInvestedPacket(uuid, qty, posList);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeInt(this.qty);
        for (int i = 0; i < this.qty; ++i) {
            buf.m_130064_(this.pos.get(i));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && this.qty != 0) {
                FoundNearbyMetalUtils.setNearbyAllomancers(this.pos);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

