/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.rudahee.metallics_arts.data.enums.implementations.custom_items.SpikeEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.data.player.data.model.SpikeEntity;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodyPartEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodySlotEnum;
import net.rudahee.metallics_arts.modules.error_handling.utils.LoggerUtils;

public class HemalurgyUtils {
    public static ItemStack generateTags(SpikeEntity spikeEntity) {
        if (spikeEntity != null) {
            ItemStack stack = new ItemStack((ItemLike)SpikeEnum.valueOf(spikeEntity.getMetal().getMetalNameUpper()).getSpike());
            if (!(stack.m_41783_().m_128441_("metal_spike") && stack.m_41783_().m_128441_("feruchemic_power") && stack.m_41783_().m_128441_("allomantic_power"))) {
                stack.m_41751_(HemalurgyUtils.generateDefaultTags(stack, spikeEntity.getMetal().getIndex()));
            }
            stack.m_41783_().m_128379_(spikeEntity.getType().getType() + "_power", true);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static SpikeEntity generateSpikeEntity(IInvestedPlayerData playerData, int slotNum, BodySlotEnum slotType, BodyPartEnum part) {
        if (part == BodyPartEnum.HEAD) {
            return playerData.getPlayerData().getHead().getSpikeBySlot(slotNum, slotType);
        }
        if (part == BodyPartEnum.BACK) {
            return playerData.getPlayerData().getBack().getSpikeBySlot(slotNum, slotType);
        }
        if (part == BodyPartEnum.CHEST) {
            return playerData.getPlayerData().getChest().getSpikeBySlot(slotNum, slotType);
        }
        if (part == BodyPartEnum.ARMS) {
            return playerData.getPlayerData().getArms().getSpikeBySlot(slotNum, slotType);
        }
        if (part == BodyPartEnum.LEGS) {
            return playerData.getPlayerData().getLegs().getSpikeBySlot(slotNum, slotType);
        }
        LoggerUtils.printLogInfo("Error in HemalurgyAltarBackMenu: generateSpikeEntity: part not found");
        return null;
    }

    public static CompoundTag generateDefaultTags(ItemStack stack, int index) {
        stack.m_41783_().m_128405_("metal_spike", index);
        stack.m_41783_().m_128379_("feruchemic_power", false);
        stack.m_41783_().m_128379_("allomantic_power", false);
        return stack.m_41783_();
    }

    public static int calculateSlotNumBySlotIndex(int slotIndex) {
        if (slotIndex == 0) {
            return 0;
        }
        if (slotIndex == 1) {
            return 1;
        }
        if (slotIndex >= 2 && slotIndex <= 7) {
            return slotIndex - 2;
        }
        if (slotIndex >= 8 && slotIndex <= 13) {
            return slotIndex - 8;
        }
        if (slotIndex >= 14 && slotIndex <= 19) {
            return slotIndex - 14;
        }
        return -1;
    }

    public static BodyPartEnum calculateBodyPartBySlotIndex(int slotIndex) {
        if (slotIndex >= 0 && slotIndex <= 1) {
            return BodyPartEnum.HEAD;
        }
        if (slotIndex >= 2 && slotIndex <= 7) {
            return BodyPartEnum.CHEST;
        }
        if (slotIndex >= 8 && slotIndex <= 13) {
            return BodyPartEnum.ARMS;
        }
        if (slotIndex >= 14 && slotIndex <= 19) {
            return BodyPartEnum.LEGS;
        }
        return null;
    }
}

