/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DrawUtils {
    public static void drawMetalLine(PoseStack stack, Vec3 player, Vec3 dest, float width, float r, float g, float b) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        builder.m_252986_(matrix4f, (float)player.f_82479_, (float)player.f_82480_, (float)player.f_82481_).m_85950_(r, g, b, 0.6f).m_5752_();
        builder.m_252986_(matrix4f, (float)dest.f_82479_, (float)dest.f_82480_, (float)dest.f_82481_).m_85950_(r, g, b, 0.6f).m_5752_();
        RenderSystem.m_69832_((float)width);
        tessellator.m_85914_();
    }

    public static Matrix4f setUpForDrawingQuadLines(RenderLevelStageEvent event) {
        RenderSystem.m_157427_(GameRenderer::m_172744_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69464_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        Matrix4f translationMatrix = stack.m_85850_().m_252922_();
        stack.m_85849_();
        return translationMatrix;
    }

    private static void addVertexToBuffer(BufferBuilder buffer, Matrix4f translationMatrix, Vec3 vertex, float uv1, float uv2) {
        buffer.m_252986_(translationMatrix, (float)vertex.f_82479_, (float)vertex.f_82480_, (float)vertex.f_82481_).m_7421_(uv1, uv2).m_5752_();
    }

    private static void drawInOrder(BufferBuilder buffer, Matrix4f translationMatrix, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, double frame, double spriteLength, double columnWidthFraction, String key) {
        switch (key) {
            case "pH1": {
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v1, (float)(columnWidthFraction * frame), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v2, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v3, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), (float)spriteLength);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v4, (float)(columnWidthFraction * frame), (float)spriteLength);
                break;
            }
            case "pV1": {
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v1, (float)(columnWidthFraction * frame), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v2, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v3, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), (float)spriteLength);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v4, (float)(columnWidthFraction * frame), (float)spriteLength);
                break;
            }
            case "pV2": {
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v1, (float)(columnWidthFraction * frame), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v2, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v3, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), (float)spriteLength);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v4, (float)(columnWidthFraction * frame), (float)spriteLength);
                break;
            }
            case "pH2": {
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v1, (float)(columnWidthFraction * frame + columnWidthFraction), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v2, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), 0.0f);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v3, (float)(columnWidthFraction * frame + columnWidthFraction * 0.5), (float)spriteLength);
                DrawUtils.addVertexToBuffer(buffer, translationMatrix, v4, (float)(columnWidthFraction * frame + columnWidthFraction), (float)spriteLength);
            }
        }
    }

    public static void drawMetalQuadLines(int tick, Vec3 viewPosition, Matrix4f translationMatrix, Vec3 target, Vec3 source, double scale, ResourceLocation texture, int numberOfFrames, int columnWidth, int columnHeight) {
        Vec3 sourceTargetVector = target.m_82546_(source);
        Vec3 sourceTargetDirection = sourceTargetVector.m_82541_();
        Vec3 horizontalDependent = sourceTargetDirection.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (horizontalDependent.m_82553_() == 0.0) {
            horizontalDependent = sourceTargetVector.m_82546_(sourceTargetDirection.m_82490_(0.001)).m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        }
        Vec3 verticalDependent = sourceTargetDirection.m_82537_(horizontalDependent).m_82541_();
        Vec3 pH1 = source.m_82549_(horizontalDependent.m_82549_(verticalDependent).m_82490_(scale));
        Vec3 pH2 = source.m_82546_(horizontalDependent.m_82549_(verticalDependent).m_82490_(scale));
        Vec3 pV1 = source.m_82549_(verticalDependent.m_82546_(horizontalDependent).m_82490_(scale));
        Vec3 pV2 = source.m_82546_(verticalDependent.m_82546_(horizontalDependent).m_82490_(scale));
        float aspectRatio = (float)columnHeight / (float)columnWidth;
        double sourceTargetDistance = sourceTargetVector.m_82553_();
        double spriteLength = sourceTargetDistance / (horizontalDependent.m_82549_(verticalDependent).m_82490_(scale).m_82553_() * 2.0 * (double)aspectRatio);
        double columnWidthFraction = 1.0f / (float)numberOfFrames;
        double frame = tick % numberOfFrames;
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        ArrayList<Tuple> quadList = new ArrayList<Tuple>();
        quadList.add(new Tuple((Object)"pH1", (Object)pH1));
        quadList.add(new Tuple((Object)"pH2", (Object)pH2));
        quadList.add(new Tuple((Object)"pV1", (Object)pV1));
        quadList.add(new Tuple((Object)"pV2", (Object)pV2));
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (Tuple tup : quadList.stream().sorted(Comparator.comparingDouble(vecTup -> -1.0 * ((Vec3)vecTup.m_14419_()).m_82546_(viewPosition).m_82553_())).toList()) {
            DrawUtils.drawInOrder(buffer, translationMatrix, (Vec3)tup.m_14419_(), source, target, ((Vec3)tup.m_14419_()).m_82549_(sourceTargetVector), frame, spriteLength, columnWidthFraction, (String)tup.m_14418_());
        }
        tesselator.m_85914_();
    }
}

