/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils.powers_utils;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MetalBlockUtils {
    private static final Level level = Minecraft.m_91087_().f_91073_;
    private final Set<BlockPos> blocks = new HashSet<BlockPos>();
    private Vec3 center = null;

    public MetalBlockUtils(BlockPos initial) {
        this.add(initial);
    }

    public MetalBlockUtils() {
    }

    public static MetalBlockUtils merge(MetalBlockUtils blob1, MetalBlockUtils blob2) {
        if (blob1 == null) {
            return blob2;
        }
        if (blob2 == null) {
            return blob1;
        }
        MetalBlockUtils blob3 = new MetalBlockUtils();
        blob3.blocks.addAll(blob1.blocks);
        blob3.blocks.addAll(blob2.blocks);
        blob3.center = blob1.center.m_82490_((double)blob1.blocks.size()).m_82549_(blob2.center.m_82490_((double)blob2.blocks.size())).m_82490_(1.0 / (double)blob3.blocks.size());
        return blob3;
    }

    public boolean isMatch(BlockPos pos) {
        return this.blocks.stream().anyMatch(bp -> Vec3.m_82512_((Vec3i)bp).m_82554_(Vec3.m_82512_((Vec3i)pos)) <= 1.5);
    }

    public int size() {
        return this.blocks.size();
    }

    private Vec3 getCenterOfBlock(BlockPos pos) {
        try {
            return Vec3.m_82528_((Vec3i)pos).m_82549_(level.m_8055_(pos).m_60808_((BlockGetter)level, pos).m_83215_().m_82399_());
        }
        catch (UnsupportedOperationException e) {
            return Vec3.m_82512_((Vec3i)pos);
        }
    }

    public boolean add(BlockPos pos) {
        if (this.blocks.add(pos = pos.m_7949_())) {
            if (this.center == null) {
                this.center = this.getCenterOfBlock(pos);
            } else {
                int count = this.blocks.size();
                this.center = this.center.m_82490_((double)(count - 1)).m_82549_(this.getCenterOfBlock(pos)).m_82490_(1.0 / (double)count);
            }
            return true;
        }
        return false;
    }

    public Vec3 getCenter() {
        return this.center;
    }
}

