/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.custom_recipes.tables;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleFurnaceRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public CrucibleFurnaceRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(@NotNull SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        if (container.m_8020_(0).m_150930_(Items.f_42448_)) {
            return true;
        }
        return ((Ingredient)this.recipeItems.get(0)).test(container.m_8020_(1)) && ((Ingredient)this.recipeItems.get(1)).test(container.m_8020_(2)) && ((Ingredient)this.recipeItems.get(2)).test(container.m_8020_(3)) && ((Ingredient)this.recipeItems.get(3)).test(container.m_8020_(4));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess acess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ItemStack getResultItem() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleFurnaceRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("metallics_arts", "crucible_furnace_recipe");

        @NotNull
        public CrucibleFurnaceRecipe fromJson(@NotNull ResourceLocation loc, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new CrucibleFurnaceRecipe(ID.m_266382_("_" + loc.m_135815_()), output, (NonNullList<Ingredient>)inputs);
        }

        @Nullable
        public CrucibleFurnaceRecipe fromNetwork(ResourceLocation loc, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new CrucibleFurnaceRecipe(ID.m_266382_("_" + loc.m_135815_()), output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, CrucibleFurnaceRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(recipe.getResultItem(), false);
        }
    }

    public static class Type
    implements RecipeType<CrucibleFurnaceRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crucible_furnace_recipe_type";

        private Type() {
        }
    }
}

