/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.custom_recipes.vials;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import net.rudahee.metallics_arts.setup.registries.ModRecipeTypesRegister;
import net.rudahee.metallics_arts.setup.registries.items.ModTags;
import org.jetbrains.annotations.NotNull;

public class SmallVialItemRecipe
extends CustomRecipe {
    private static final Ingredient INGREDIENT_VIAL = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.SMALL_VIAL.get()});
    private static final HashMap<String, Ingredient> INGREDIENT_MAP = new HashMap<String, Ingredient>(){
        {
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                if (metal.getNameLower().equals("iron")) {
                    this.put(metal.getNameLower(), Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_IRON));
                    continue;
                }
                if (metal.getNameLower().equals("gold")) {
                    this.put(metal.getNameLower(), Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_GOLD));
                    continue;
                }
                this.put(metal.getNameLower(), Ingredient.m_204132_(ModTags.NUGGETS.get(metal.getMetalNameLower())));
            }
        }
    };
    private final HashMap<String, Integer> required = new HashMap();
    private final HashMap<String, Integer> available = new HashMap();
    private final HashMap<String, Integer> inVial = new HashMap();
    private boolean cancel;

    public SmallVialItemRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, category);
    }

    public boolean matches(@NotNull CraftingContainer inventory, @NotNull Level level) {
        ItemStack actualIngredient;
        int i;
        boolean[] ingredients = new boolean[]{false, false};
        int posVial = 0;
        this.cancel = false;
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            this.inVial.put(metal.getNameLower(), 0);
            this.required.put(metal.getNameLower(), 0);
            this.available.put(metal.getNameLower(), 0);
        }
        if (!this.containsInvalidElements(inventory, new ArrayList<Ingredient>(){
            {
                this.addAll(INGREDIENT_MAP.values());
                this.add(INGREDIENT_VIAL);
                this.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemStack.f_41583_}));
            }
        })) {
            return false;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            actualIngredient = inventory.m_8020_(i);
            if (actualIngredient.m_41619_() || !INGREDIENT_VIAL.test(actualIngredient)) continue;
            if (ingredients[0]) {
                return false;
            }
            posVial = i;
            ingredients[0] = true;
            if (actualIngredient.m_41782_()) {
                for (MetalTagEnum metal : MetalTagEnum.values()) {
                    if (actualIngredient.m_41783_().m_128441_(metal.getNameLower())) {
                        this.inVial.put(metal.getNameLower(), actualIngredient.m_41783_().m_128451_(metal.getNameLower()));
                        this.required.put(metal.getNameLower(), 5 - this.inVial.get(metal.getNameLower()));
                        continue;
                    }
                    this.inVial.put(metal.getNameLower(), 0);
                    this.required.put(metal.getNameLower(), 5);
                }
                continue;
            }
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                this.inVial.put(metal.getNameLower(), 0);
                this.required.put(metal.getNameLower(), 5);
            }
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            actualIngredient = inventory.m_8020_(i);
            if (actualIngredient.m_41619_() || !ingredients[0] || i == posVial) continue;
            ItemStack auxIngredient = actualIngredient;
            int finalI = i;
            INGREDIENT_MAP.forEach((name, ing) -> {
                if (ing.test(auxIngredient)) {
                    if (this.required.get(name) > 0) {
                        this.available.put((String)name, auxIngredient.m_41613_());
                        ingredients[1] = true;
                    } else {
                        this.cancel = true;
                    }
                    if (this.duplicateIngredients(inventory, finalI, (Ingredient)ing)) {
                        this.cancel = true;
                    }
                }
            });
        }
        return ingredients[0] && ingredients[1] && !this.cancel;
    }

    private boolean duplicateIngredients(CraftingContainer inventory, int slot, Ingredient ingredient) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack actual;
            if (i == slot || !ingredient.test(actual = inventory.m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    private boolean containsInvalidElements(CraftingContainer inventory, ArrayList<Ingredient> list) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!list.stream().noneMatch(e -> e.test(itemStack))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack actualIngredient = inventory.m_8020_(i);
            if (actualIngredient.m_41619_() || INGREDIENT_VIAL.test(actualIngredient)) continue;
            int finalI = i;
            INGREDIENT_MAP.forEach((name, ing) -> {
                if (ing.test(actualIngredient)) {
                    inventory.m_7407_(finalI, this.required.get(name) - 1);
                }
            });
        }
        return super.m_7457_((Container)inventory);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inventory, RegistryAccess registryAccess) {
        ItemStack finalResult = new ItemStack((ItemLike)ModItemsRegister.SMALL_VIAL.get(), 1);
        CompoundTag compoundNBT = new CompoundTag();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (this.available.get(metal.getNameLower()) >= this.required.get(metal.getNameLower())) {
                compoundNBT.m_128405_(metal.getNameLower(), 5);
                continue;
            }
            compoundNBT.m_128405_(metal.getNameLower(), this.inVial.get(metal.getNameLower()) + this.available.get(metal.getNameLower()));
        }
        compoundNBT.m_128350_("CustomModelData", 1.0f);
        finalResult.m_41751_(compoundNBT);
        return finalResult.m_41777_();
    }

    public boolean m_8004_(int num1, int num2) {
        return true;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypesRegister.SMALL_VIAL_ITEM_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<SmallVialItemRecipe> {
        public Serializer() {
            super(SmallVialItemRecipe::new);
        }
    }
}

