/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.custom_tiers;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;

public enum CustomMaterials implements ArmorMaterial
{
    STEEL("steel", 45, 0.9f, 1.5f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.STEEL_CORE.get()})),
    ALUMINUM("aluminum", 30, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.ALUMINUM_CORE.get()})),
    ETTMETAL("ettmetal", 45, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.ETTMETAL_CORE.get()})),
    LERASIUM("lerasium", 45, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.LERASIUM_CORE.get()})),
    ATIUM("atium", 45, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.ATIUM_CORE.get()})),
    COPPER("copper", 45, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItemsRegister.COPPER_CORE.get()}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Ingredient repairIngredient;

    private CustomMaterials(String name, int durability, Ingredient repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.slotProtections = new int[]{4, 6, 8, 4};
        this.enchantmentValue = 15;
        this.sound = SoundEvents.f_11679_;
        this.toughness = 3.0f;
        this.knockbackResistance = 0.1f;
        this.repairIngredient = repairIngredient;
    }

    private CustomMaterials(String name, int durability, float knockbackResistance, float toughness, Ingredient repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.slotProtections = new int[]{4, 6, 8, 4};
        this.enchantmentValue = 15;
        this.sound = SoundEvents.f_11679_;
        this.toughness = 3.0f + toughness;
        this.knockbackResistance = 0.1f + knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type slot) {
        return HEALTH_PER_SLOT[slot.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type slot) {
        return this.slotProtections[slot.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient;
    }

    public String m_6082_() {
        return "metallics_arts:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

