/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.enums.implementations;

import net.rudahee.metallics_arts.data.enums.interfaces.IGems;
import net.rudahee.metallics_arts.data.enums.interfaces.IMetal;

public enum MetalTagEnum implements IMetal,
IGems
{
    IRON("iron", "IRON", 0, 6000, 3, true, false, 2, 9600, 3000),
    STEEL("steel", "STEEL", 0, 6000, 3, true, false, 3, 9600, 3000),
    TIN("tin", "TIN", 1, 24000, 3, false, false, 2, 24000, 7200),
    PEWTER("pewter", "PEWTER", 1, 4000, 3, false, false, 3, 6000, 1200),
    ZINC("zinc", "ZINC", 3, 6000, 3, true, false, 1, 6000, 2400),
    BRASS("brass", "BRASS", 3, 6000, 3, true, false, 0, 6000, 2800),
    COPPER("copper", "COPPER", 2, 8400, 3, false, false, 1, 5345, 315),
    BRONZE("bronze", "BRONZE", 2, 8400, 3, false, false, 0, 7200, 2200),
    ALUMINUM("aluminum", "ALUMINUM", 5, 2400, 3, false, false, 5, 4, 4),
    DURALUMIN("duralumin", "DURALUMIN", 5, 100, 3, false, false, 4, 12000, 4000),
    CHROMIUM("chromium", "CHROMIUM", 4, 400, 3, true, false, 5, 6000, 2400),
    NICROSIL("nicrosil", "NICROSIL", 4, 400, 3, true, false, 4, 9600, 3000),
    GOLD("gold", "GOLD", 7, 12000, 3, false, false, 6, 6000, 1000),
    ELECTRUM("electrum", "ELECTRUM", 7, 12000, 3, false, false, 7, 4800, 1200),
    CADMIUM("cadmium", "CADMIUM", 6, 2400, 3, true, false, 6, 12000, 4000),
    BENDALLOY("bendalloy", "BENDALLOY", 6, 1800, 3, true, false, 7, 9600, 3000),
    ATIUM("atium", "ATIUM", 8, 800, 3, false, true, 0, 2400, 600),
    MALATIUM("malatium", "MALATIUM", 8, 12000, 3, false, true, 1, 3000, 500),
    LERASIUM("lerasium", "LERASIUM", 9, 6000, 3, false, true, 2, 2, 2),
    ETTMETAL("ettmetal", "ETTMETAL", 9, 100, 3, false, true, 3, 4100, 1640);

    private final String nameLower;
    private final String nameUpper;
    private final int group;
    private final int maxAllomanticTicksStorage;
    private final int feruchemicCompoundingMultiplier;
    private final int chargeForNugget;
    private final boolean external;
    private final boolean divine;
    private final int order;
    private final int maxReserveBand;
    private final int maxReserveRing;

    private MetalTagEnum(String nameLower, String nameUpper, int group, int maxAllomanticTicksStorage, int feruchemicCompoundingMultiplier, boolean external, boolean divine, int order, int maxReserveBand, int maxReserveRing) {
        this.nameLower = nameLower;
        this.nameUpper = nameUpper;
        this.group = group;
        this.maxAllomanticTicksStorage = maxAllomanticTicksStorage;
        this.feruchemicCompoundingMultiplier = feruchemicCompoundingMultiplier;
        this.chargeForNugget = this.maxAllomanticTicksStorage / 10;
        this.external = external;
        this.divine = divine;
        this.order = order;
        this.maxReserveBand = maxReserveBand;
        this.maxReserveRing = maxReserveRing;
    }

    public String getNameLower() {
        return this.nameLower;
    }

    public String getNameUpper() {
        return this.nameUpper;
    }

    public int getGroup() {
        return this.group;
    }

    @Override
    public String getGemNameLower() {
        return this.nameLower;
    }

    @Override
    public String getGemNameUpper() {
        return this.nameUpper;
    }

    @Override
    public String getMetalNameLower() {
        return this.nameLower;
    }

    @Override
    public String getMetalNameUpper() {
        return this.nameUpper;
    }

    public int getMaxAllomanticTicksStorage() {
        return this.maxAllomanticTicksStorage;
    }

    public int getFeruchemicCompoundingMultiplier() {
        return this.feruchemicCompoundingMultiplier;
    }

    public int getIndex() {
        return this.ordinal();
    }

    public static MetalTagEnum getMetal(int index) {
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (metal.getIndex() != index) continue;
            return metal;
        }
        throw new IllegalArgumentException("Allomancy: Bad Metal Index");
    }

    public boolean isDivine() {
        return this.divine;
    }

    public boolean isExternal() {
        return this.external;
    }

    public int getOrder() {
        return this.order;
    }

    public int getMaxReserveBand() {
        return this.maxReserveBand;
    }

    public int getMaxReserveRing() {
        return this.maxReserveRing;
    }

    public int getChargeForNugget() {
        return this.chargeForNugget;
    }

    public static MetalTagEnum getMetal(String name) {
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (!metal.getNameLower().equals(name)) continue;
            return metal;
        }
        return null;
    }
}

