/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.player.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.data.player.data.model.PlayerEntity;
import net.rudahee.metallics_arts.data.player.data.model.SpikeEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.BodyPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodyPartEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodySlotEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.EttmetalStateEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.TypeOfSpikeEnum;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import net.rudahee.metallics_arts.utils.MetalTagsUtils;

public class InvestedPlayerData
implements IInvestedPlayerData {
    PlayerEntity player = new PlayerEntity();

    public InvestedPlayerData() {
        this.player.setEnhanced(false);
        this.player.setModifiedHealth(false);
        this.player.setBurningMetals(new CapabilityUtils<Boolean>().fillMetalTagMap(false));
        this.player.setTappingMetals(new CapabilityUtils<Boolean>().fillMetalTagMap(false));
        this.player.setStoringMetals(new CapabilityUtils<Boolean>().fillMetalTagMap(false));
        this.player.setAllomanticReserve(new CapabilityUtils<Integer>().fillMetalTagMap(0));
        this.player.setMetalMindEquipped(new CapabilityUtils<Boolean>().fillListWithDefaultValue(false, 10));
        this.player.setEttmetalState(EttmetalStateEnum.NOTHING);
    }

    @Override
    public void tickAllomancyBurningMetals(Player player, int tick) {
        boolean readyToSync = false;
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (!this.isBurning(metal)) continue;
            if (metal == MetalTagEnum.ALUMINUM) {
                System.out.println("x");
            }
            if (!this.hasAllomanticPower(metal)) {
                this.setBurning(metal, false);
            } else {
                if (this.isTapping(metal)) {
                    if (tick % metal.getFeruchemicCompoundingMultiplier() == 0) {
                        this.setAllomanticMetalsAmount(metal, this.getAllomanticAmount(metal) - 1);
                    }
                } else {
                    this.setAllomanticMetalsAmount(metal, this.getAllomanticAmount(metal) - 1);
                }
                if (this.getAllomanticAmount(metal) <= 0) {
                    this.setBurning(metal, false);
                }
            }
            readyToSync = true;
        }
        if (readyToSync) {
            ModNetwork.syncInvestedDataPacket(this, player);
        }
    }

    @Override
    public boolean isFirstJoin() {
        return this.player.isFirstJoin();
    }

    @Override
    public void setFirstJoin(boolean joined) {
        this.player.setFirstJoin(joined);
    }

    @Override
    public void alreadyJoin() {
        this.player.setFirstJoin(false);
    }

    @Override
    public boolean isBurningAnything() {
        return this.player.getBurningMetals().values().stream().anyMatch(isBurning -> true);
    }

    @Override
    public boolean isTappingAnything() {
        return this.player.getTappingMetals().values().stream().anyMatch(isTapping -> true);
    }

    @Override
    public boolean isStoringAnything() {
        return this.player.getStoringMetals().values().stream().anyMatch(isStoring -> true);
    }

    @Override
    public void clearMetalsEnhanced() {
        this.player.getMetalsEnhanced().clear();
    }

    @Override
    public void addMetalsEnhanced(MetalTagEnum metal) {
        this.player.getMetalsEnhanced().add(metal);
    }

    @Override
    public ArrayList<MetalTagEnum> getMetalsEnhanced() {
        return this.player.getMetalsEnhanced();
    }

    @Override
    public boolean containsMetalsEnhanced(MetalTagEnum metal) {
        return this.player.getMetalsEnhanced().contains(metal);
    }

    @Override
    public boolean hasAllomanticPower(MetalTagEnum metal) {
        return this.player.hasAllomanticMetal(metal);
    }

    @Override
    public boolean hasFeruchemicPower(MetalTagEnum metal) {
        return this.player.hasFeruchemicMetal(metal);
    }

    @Override
    public int getAllomanticPowerCount() {
        return (int)this.player.getCountAllomanticMetal();
    }

    @Override
    public int getFeruchemicPowerCount() {
        return (int)this.player.getCountFeruchemicMetal();
    }

    @Override
    public boolean hasAnyAllomanticPower() {
        return this.player.hasAnyAllomanticMetal();
    }

    @Override
    public boolean hasAnyFeruchemicPower() {
        return this.player.hasAnyFeruchemicMetal();
    }

    @Override
    public ArrayList<MetalTagEnum> getAllomanticPowers() {
        ArrayList<MetalTagEnum> powers = new ArrayList<MetalTagEnum>();
        for (MetalTagEnum metals : MetalTagEnum.values()) {
            if (!this.hasAllomanticPower(metals)) continue;
            powers.add(metals);
        }
        return powers;
    }

    @Override
    public ArrayList<MetalTagEnum> getFeruchemicPowers() {
        ArrayList<MetalTagEnum> powers = new ArrayList<MetalTagEnum>();
        for (MetalTagEnum metals : MetalTagEnum.values()) {
            if (!this.hasFeruchemicPower(metals)) continue;
            powers.add(metals);
        }
        return powers;
    }

    @Override
    public void drainMetals(MetalTagEnum ... metals) {
        for (MetalTagEnum metal : metals) {
            this.setAllomanticMetalsAmount(metal, 0);
            this.setBurning(metal, false);
        }
    }

    @Override
    public boolean hasMetalMindEquiped(int group) {
        return this.player.getMetalMindEquipped().get(group);
    }

    @Override
    public void setMetalMindEquiped(int group, boolean value) {
        this.player.getMetalMindEquipped().set(group, value);
    }

    @Override
    public ArrayList<Boolean> getMetalMindEquipedList() {
        return this.player.getMetalMindEquipped();
    }

    @Override
    public void setMetalMindEquipedList(ArrayList<Boolean> list) {
        this.player.setMetalMindEquipped(list);
    }

    @Override
    public boolean getEnhanced() {
        return this.player.getEnhanced();
    }

    @Override
    public void setEnhanced(boolean isEnhanced) {
        this.player.setEnhanced(isEnhanced);
    }

    @Override
    public boolean hasModifiedHealth() {
        return this.player.getModifiedHealth();
    }

    @Override
    public void setModifiedHealth(boolean modifiedHealth) {
        this.player.setModifiedHealth(modifiedHealth);
    }

    @Override
    public void addAllomanticPower(MetalTagEnum metal) {
        if (this.player.getLegs().getActualQtySpikes() < this.player.getLegs().getMaxQtySpikes()) {
            if (this.player.getLegs().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.ALLOMANTIC)) {
                this.player.getLegs().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC));
            }
        } else if (this.player.getHead().getActualQtySpikes() < this.player.getHead().getMaxQtySpikes()) {
            if (this.player.getHead().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.ALLOMANTIC)) {
                this.player.getHead().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC));
            }
        } else if (this.player.getBack().getActualQtySpikes() < this.player.getBack().getMaxQtySpikes()) {
            if (this.player.getBack().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.ALLOMANTIC)) {
                this.player.getBack().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC));
            }
        } else if (this.player.getArms().getActualQtySpikes() < this.player.getArms().getMaxQtySpikes()) {
            if (this.player.getArms().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.ALLOMANTIC)) {
                this.player.getArms().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC));
            }
        } else if (this.player.getChest().getActualQtySpikes() < this.player.getChest().getMaxQtySpikes()) {
            if (this.player.getChest().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.ALLOMANTIC)) {
                this.player.getChest().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC));
            }
        } else {
            System.out.println("NO HAY HUECO");
        }
    }

    @Override
    public void addAllomanticPower(MetalTagEnum metal, BodyPartEnum part, BodySlotEnum slotPos, int slotNum) {
        if (part.equals((Object)BodyPartEnum.HEAD)) {
            this.player.getHead().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.CHEST)) {
            this.player.getChest().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.ARMS)) {
            this.player.getArms().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.BACK)) {
            this.player.getBack().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.LEGS)) {
            this.player.getLegs().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC), slotNum, slotPos);
        } else {
            Optional<BodyPartEntity> partEntity = Stream.of(this.player.getLegs(), this.player.getHead(), this.player.getBack(), this.player.getArms(), this.player.getChest()).filter(bodyPart -> bodyPart.getActualQtySpikes() < bodyPart.getMaxQtySpikes()).findFirst();
            if (partEntity.isPresent()) {
                partEntity.get().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC));
            }
        }
    }

    @Override
    public void addFeruchemicPower(MetalTagEnum metal) {
        if (this.player.getLegs().getActualQtySpikes() < this.player.getLegs().getMaxQtySpikes()) {
            if (this.player.getLegs().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.FERUCHEMIC)) {
                this.player.getLegs().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC));
            }
        } else if (this.player.getHead().getActualQtySpikes() < this.player.getHead().getMaxQtySpikes()) {
            if (this.player.getHead().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.FERUCHEMIC)) {
                this.player.getHead().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC));
            }
        } else if (this.player.getBack().getActualQtySpikes() < this.player.getBack().getMaxQtySpikes()) {
            if (this.player.getBack().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.FERUCHEMIC)) {
                this.player.getBack().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC));
            }
        } else if (this.player.getArms().getActualQtySpikes() < this.player.getArms().getMaxQtySpikes()) {
            if (this.player.getArms().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.FERUCHEMIC)) {
                this.player.getArms().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC));
            }
        } else if (this.player.getChest().getActualQtySpikes() < this.player.getChest().getMaxQtySpikes()) {
            if (this.player.getChest().getAllSpikes().stream().noneMatch(spike -> spike.getMetal().getNameLower().equals(metal.getNameLower()) && spike.getType() == TypeOfSpikeEnum.FERUCHEMIC)) {
                this.player.getChest().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC));
            }
        } else {
            System.out.println("No available body part to add feruchemic power");
        }
    }

    @Override
    public void addFeruchemicPower(MetalTagEnum metal, BodyPartEnum part, BodySlotEnum slotPos, int slotNum) {
        if (part.equals((Object)BodyPartEnum.HEAD)) {
            this.player.getHead().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.CHEST)) {
            this.player.getChest().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.ARMS)) {
            this.player.getArms().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.BACK)) {
            this.player.getBack().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC), slotNum, slotPos);
        } else if (part.equals((Object)BodyPartEnum.LEGS)) {
            this.player.getLegs().addSpikeBySlot(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC), slotNum, slotPos);
        } else {
            Optional<BodyPartEntity> partEntity = Stream.of(this.player.getLegs(), this.player.getHead(), this.player.getBack(), this.player.getArms(), this.player.getChest()).filter(bodyPart -> bodyPart.getActualQtySpikes() < bodyPart.getMaxQtySpikes()).findFirst();
            if (partEntity.isPresent()) {
                partEntity.get().addSpikeRandom(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC));
            }
        }
    }

    @Override
    public void addAllAllomantic() {
        List<MetalTagEnum> metals = Arrays.asList(MetalTagEnum.values());
        List<MetalTagEnum> filteredMetals = metals.stream().filter(metal -> !this.getAllomanticPowers().contains(metal)).toList();
        for (MetalTagEnum metal2 : filteredMetals) {
            this.addAllomanticPower(metal2);
        }
    }

    @Override
    public void addAllFeruchemic() {
        List<MetalTagEnum> metals = Arrays.asList(MetalTagEnum.values());
        List<MetalTagEnum> filteredMetals = metals.stream().filter(metal -> !this.getFeruchemicPowers().contains(metal)).toList();
        for (MetalTagEnum metal2 : filteredMetals) {
            this.addFeruchemicPower(metal2);
        }
    }

    @Override
    public void removeAllomanticPower(MetalTagEnum metal) {
        System.out.println("InvestedPlayerData: Removing allomantic power: " + String.valueOf(metal));
        Stream.of(this.player.getLegs(), this.player.getHead(), this.player.getBack(), this.player.getArms(), this.player.getChest()).forEach(bodyPart -> bodyPart.removeSpikeBySpikeEntity(new SpikeEntity(metal, TypeOfSpikeEnum.ALLOMANTIC)));
    }

    @Override
    public void removeAllAllomanticPower() {
        ArrayList<MetalTagEnum> metals = this.getAllomanticPowers();
        for (MetalTagEnum metal : metals) {
            this.removeAllomanticPower(metal);
        }
    }

    @Override
    public void removeFeruchemicPower(MetalTagEnum metal) {
        System.out.println("InvestedPlayerData: Removing feruchemic power: " + String.valueOf(metal));
        Stream.of(this.player.getLegs(), this.player.getHead(), this.player.getBack(), this.player.getArms(), this.player.getChest()).forEach(bodyPart -> bodyPart.removeSpikeBySpikeEntity(new SpikeEntity(metal, TypeOfSpikeEnum.FERUCHEMIC)));
    }

    @Override
    public void removeAllFeruchemicPower() {
        ArrayList<MetalTagEnum> metals = this.getFeruchemicPowers();
        for (MetalTagEnum metal : metals) {
            this.removeFeruchemicPower(metal);
        }
    }

    @Override
    public boolean isTapping(MetalTagEnum metal) {
        return this.player.getTappingMetals().get(metal);
    }

    @Override
    public boolean isStoring(MetalTagEnum metal) {
        return this.player.getStoringMetals().get(metal);
    }

    @Override
    public boolean isBurning(MetalTagEnum metal) {
        return this.player.getBurningMetals().get(metal);
    }

    @Override
    public boolean isUsingPowers() {
        return this.isBurningAnything() || this.isStoringAnything() || this.isTappingAnything();
    }

    @Override
    public int cantMetalsTapping() {
        int cant = 0;
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (metal == MetalTagEnum.ALUMINUM || metal == MetalTagEnum.LERASIUM || metal == MetalTagEnum.NICROSIL || metal == MetalTagEnum.MALATIUM || metal == MetalTagEnum.COPPER || metal == MetalTagEnum.ETTMETAL || metal == MetalTagEnum.ZINC || !this.isTapping(metal)) continue;
            ++cant;
        }
        return cant;
    }

    @Override
    public int cantMetalsStoring() {
        int cant = 0;
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (metal == MetalTagEnum.ALUMINUM || metal == MetalTagEnum.LERASIUM || metal == MetalTagEnum.NICROSIL || metal == MetalTagEnum.MALATIUM || metal == MetalTagEnum.COPPER || metal == MetalTagEnum.ETTMETAL || metal == MetalTagEnum.ZINC || !this.isStoring(metal)) continue;
            ++cant;
        }
        return cant;
    }

    @Override
    public void setTapping(MetalTagEnum metal, boolean value) {
        this.player.getTappingMetals().put(metal, value);
    }

    @Override
    public void setStoring(MetalTagEnum metal, boolean value) {
        this.player.getStoringMetals().put(metal, value);
    }

    @Override
    public void setBurning(MetalTagEnum metal, boolean value) {
        this.player.getBurningMetals().put(metal, value);
    }

    @Override
    public void setAllomanticMetalsAmount(MetalTagEnum metal, int qty) {
        if (metal.getMaxAllomanticTicksStorage() < qty) {
            qty = metal.getMaxAllomanticTicksStorage();
        }
        this.player.getAllomanticReserve().put(metal, qty);
    }

    @Override
    public boolean addAllomanticMetalAmount(MetalTagEnum metal, int qty) {
        int value = this.player.getAllomanticReserve().get(metal);
        if (metal.getMaxAllomanticTicksStorage() < value + qty) {
            this.player.getAllomanticReserve().put(metal, metal.getMaxAllomanticTicksStorage());
            return false;
        }
        this.player.getAllomanticReserve().put(metal, value + qty);
        return true;
    }

    @Override
    public boolean substractAllomanticMetalAmount(MetalTagEnum metal, int qty) {
        int value = this.player.getAllomanticReserve().get(metal);
        if (value - qty < 0) {
            this.player.getAllomanticReserve().put(metal, 0);
            return false;
        }
        this.player.getAllomanticReserve().put(metal, value - qty);
        return true;
    }

    @Override
    public int getAllomanticAmount(MetalTagEnum metal) {
        return this.player.getAllomanticReserve().get(metal);
    }

    @Override
    public void setEttmetalState(EttmetalStateEnum state) {
        this.player.setEttmetalState(state);
    }

    @Override
    public EttmetalStateEnum getEttmetalState() {
        return this.player.getEttmetalState();
    }

    @Override
    public boolean hasAllomanticAmountOf(MetalTagEnum metal) {
        return this.getAllomanticAmount(metal) > 0;
    }

    @Override
    public PlayerEntity getPlayerData() {
        return this.player;
    }

    @Override
    public CompoundTag save() {
        CompoundTag playerData = new CompoundTag();
        CompoundTag head = new CompoundTag();
        CompoundTag chest = new CompoundTag();
        CompoundTag back = new CompoundTag();
        CompoundTag arms = new CompoundTag();
        CompoundTag legs = new CompoundTag();
        CompoundTag spikes = new CompoundTag();
        CompoundTag metalminds = new CompoundTag();
        CompoundTag extraData = new CompoundTag();
        CompoundTag reserve = new CompoundTag();
        CompoundTag burningMetals = new CompoundTag();
        CompoundTag tappingMetals = new CompoundTag();
        CompoundTag storingMetals = new CompoundTag();
        CompoundTag enhanced = new CompoundTag();
        CompoundTag metalEnhanced = new CompoundTag();
        if (this.player.getHead() != null) {
            if (this.player.getHead().getSpikeBySlot(0, BodySlotEnum.FRONT) != null) {
                head.m_128359_("head_front_0", MetalTagsUtils.getStringBySpike(this.player.getHead().getSpikeBySlot(0, BodySlotEnum.FRONT)));
            } else {
                head.m_128359_("head_front_0", "empty");
            }
            if (this.player.getHead().getSpikeBySlot(1, BodySlotEnum.FRONT) != null) {
                head.m_128359_("head_front_1", MetalTagsUtils.getStringBySpike(this.player.getHead().getSpikeBySlot(1, BodySlotEnum.FRONT)));
            } else {
                head.m_128359_("head_front_1", "empty");
            }
            if (this.player.getHead().getSpikeBySlot(0, BodySlotEnum.BACK) != null) {
                head.m_128359_("head_back_0", MetalTagsUtils.getStringBySpike(this.player.getHead().getSpikeBySlot(0, BodySlotEnum.BACK)));
            } else {
                head.m_128359_("head_back_0", "empty");
            }
        }
        if (this.player.getChest() != null) {
            if (this.player.getChest().getSpikeBySlot(0, BodySlotEnum.FRONT) != null) {
                chest.m_128359_("chest_front_0", MetalTagsUtils.getStringBySpike(this.player.getChest().getSpikeBySlot(0, BodySlotEnum.FRONT)));
            } else {
                chest.m_128359_("chest_front_0", "empty");
            }
            if (this.player.getChest().getSpikeBySlot(1, BodySlotEnum.FRONT) != null) {
                chest.m_128359_("chest_front_1", MetalTagsUtils.getStringBySpike(this.player.getChest().getSpikeBySlot(1, BodySlotEnum.FRONT)));
            } else {
                chest.m_128359_("chest_front_1", "empty");
            }
            if (this.player.getChest().getSpikeBySlot(2, BodySlotEnum.FRONT) != null) {
                chest.m_128359_("chest_front_2", MetalTagsUtils.getStringBySpike(this.player.getChest().getSpikeBySlot(2, BodySlotEnum.FRONT)));
            } else {
                chest.m_128359_("chest_front_2", "empty");
            }
            if (this.player.getChest().getSpikeBySlot(3, BodySlotEnum.FRONT) != null) {
                chest.m_128359_("chest_front_3", MetalTagsUtils.getStringBySpike(this.player.getChest().getSpikeBySlot(3, BodySlotEnum.FRONT)));
            } else {
                chest.m_128359_("chest_front_3", "empty");
            }
            if (this.player.getChest().getSpikeBySlot(4, BodySlotEnum.FRONT) != null) {
                chest.m_128359_("chest_front_4", MetalTagsUtils.getStringBySpike(this.player.getChest().getSpikeBySlot(4, BodySlotEnum.FRONT)));
            } else {
                chest.m_128359_("chest_front_4", "empty");
            }
            if (this.player.getChest().getSpikeBySlot(5, BodySlotEnum.FRONT) != null) {
                chest.m_128359_("chest_front_5", MetalTagsUtils.getStringBySpike(this.player.getChest().getSpikeBySlot(5, BodySlotEnum.FRONT)));
            } else {
                chest.m_128359_("chest_front_5", "empty");
            }
        }
        if (this.player.getBack() != null) {
            if (this.player.getBack().getSpikeBySlot(0, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_0", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(0, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_0", "empty");
            }
            if (this.player.getBack().getSpikeBySlot(1, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_1", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(1, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_1", "empty");
            }
            if (this.player.getBack().getSpikeBySlot(2, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_2", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(2, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_2", "empty");
            }
            if (this.player.getBack().getSpikeBySlot(3, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_3", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(3, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_3", "empty");
            }
            if (this.player.getBack().getSpikeBySlot(4, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_4", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(4, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_4", "empty");
            }
            if (this.player.getBack().getSpikeBySlot(5, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_5", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(5, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_5", "empty");
            }
            if (this.player.getBack().getSpikeBySlot(6, BodySlotEnum.BACK) != null) {
                back.m_128359_("back_back_6", MetalTagsUtils.getStringBySpike(this.player.getBack().getSpikeBySlot(6, BodySlotEnum.BACK)));
            } else {
                back.m_128359_("back_back_6", "empty");
            }
        }
        if (this.player.getArms() != null) {
            if (this.player.getArms().getSpikeBySlot(0, BodySlotEnum.FRONT) != null) {
                arms.m_128359_("arms_front_0", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(0, BodySlotEnum.FRONT)));
            } else {
                arms.m_128359_("arms_front_0", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(1, BodySlotEnum.FRONT) != null) {
                arms.m_128359_("arms_front_1", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(1, BodySlotEnum.FRONT)));
            } else {
                arms.m_128359_("arms_front_1", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(2, BodySlotEnum.FRONT) != null) {
                arms.m_128359_("arms_front_2", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(2, BodySlotEnum.FRONT)));
            } else {
                arms.m_128359_("arms_front_2", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(3, BodySlotEnum.FRONT) != null) {
                arms.m_128359_("arms_front_3", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(3, BodySlotEnum.FRONT)));
            } else {
                arms.m_128359_("arms_front_3", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(4, BodySlotEnum.FRONT) != null) {
                arms.m_128359_("arms_front_4", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(4, BodySlotEnum.FRONT)));
            } else {
                arms.m_128359_("arms_front_4", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(5, BodySlotEnum.FRONT) != null) {
                arms.m_128359_("arms_front_5", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(5, BodySlotEnum.FRONT)));
            } else {
                arms.m_128359_("arms_front_5", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(0, BodySlotEnum.BACK) != null) {
                arms.m_128359_("arms_back_0", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(0, BodySlotEnum.BACK)));
            } else {
                arms.m_128359_("arms_back_0", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(1, BodySlotEnum.BACK) != null) {
                arms.m_128359_("arms_back_1", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(1, BodySlotEnum.BACK)));
            } else {
                arms.m_128359_("arms_back_1", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(2, BodySlotEnum.BACK) != null) {
                arms.m_128359_("arms_back_2", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(2, BodySlotEnum.BACK)));
            } else {
                arms.m_128359_("arms_back_2", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(3, BodySlotEnum.BACK) != null) {
                arms.m_128359_("arms_back_3", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(3, BodySlotEnum.BACK)));
            } else {
                arms.m_128359_("arms_back_3", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(4, BodySlotEnum.BACK) != null) {
                arms.m_128359_("arms_back_4", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(4, BodySlotEnum.BACK)));
            } else {
                arms.m_128359_("arms_back_4", "empty");
            }
            if (this.player.getArms().getSpikeBySlot(5, BodySlotEnum.BACK) != null) {
                arms.m_128359_("arms_back_5", MetalTagsUtils.getStringBySpike(this.player.getArms().getSpikeBySlot(5, BodySlotEnum.BACK)));
            } else {
                arms.m_128359_("arms_back_5", "empty");
            }
        }
        if (this.player.getLegs() != null) {
            if (this.player.getLegs().getSpikeBySlot(0, BodySlotEnum.FRONT) != null) {
                legs.m_128359_("legs_front_0", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(0, BodySlotEnum.FRONT)));
            } else {
                legs.m_128359_("legs_front_0", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(1, BodySlotEnum.FRONT) != null) {
                legs.m_128359_("legs_front_1", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(1, BodySlotEnum.FRONT)));
            } else {
                legs.m_128359_("legs_front_1", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(2, BodySlotEnum.FRONT) != null) {
                legs.m_128359_("legs_front_2", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(2, BodySlotEnum.FRONT)));
            } else {
                legs.m_128359_("legs_front_2", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(3, BodySlotEnum.FRONT) != null) {
                legs.m_128359_("legs_front_3", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(3, BodySlotEnum.FRONT)));
            } else {
                legs.m_128359_("legs_front_3", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(4, BodySlotEnum.FRONT) != null) {
                legs.m_128359_("legs_front_4", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(4, BodySlotEnum.FRONT)));
            } else {
                legs.m_128359_("legs_front_4", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(5, BodySlotEnum.FRONT) != null) {
                legs.m_128359_("legs_front_5", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(5, BodySlotEnum.FRONT)));
            } else {
                legs.m_128359_("legs_front_5", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(0, BodySlotEnum.BACK) != null) {
                legs.m_128359_("legs_back_0", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(0, BodySlotEnum.BACK)));
            } else {
                legs.m_128359_("legs_back_0", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(1, BodySlotEnum.BACK) != null) {
                legs.m_128359_("legs_back_1", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(1, BodySlotEnum.BACK)));
            } else {
                legs.m_128359_("legs_back_1", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(2, BodySlotEnum.BACK) != null) {
                legs.m_128359_("legs_back_2", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(2, BodySlotEnum.BACK)));
            } else {
                legs.m_128359_("legs_back_2", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(3, BodySlotEnum.BACK) != null) {
                legs.m_128359_("legs_back_3", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(3, BodySlotEnum.BACK)));
            } else {
                legs.m_128359_("legs_back_3", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(4, BodySlotEnum.BACK) != null) {
                legs.m_128359_("legs_back_4", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(4, BodySlotEnum.BACK)));
            } else {
                legs.m_128359_("legs_back_4", "empty");
            }
            if (this.player.getLegs().getSpikeBySlot(5, BodySlotEnum.BACK) != null) {
                legs.m_128359_("legs_back_5", MetalTagsUtils.getStringBySpike(this.player.getLegs().getSpikeBySlot(5, BodySlotEnum.BACK)));
            } else {
                legs.m_128359_("legs_back_5", "empty");
            }
        }
        spikes.m_128365_("body_head", (Tag)head);
        spikes.m_128365_("body_chest", (Tag)chest);
        spikes.m_128365_("body_back", (Tag)back);
        spikes.m_128365_("body_arms", (Tag)arms);
        spikes.m_128365_("body_legs", (Tag)legs);
        playerData.m_128365_("spikes", (Tag)spikes);
        for (int i = 0; i < 10; ++i) {
            metalminds.m_128379_("group_" + i, this.hasMetalMindEquiped(i));
        }
        playerData.m_128365_("metalminds", (Tag)metalminds);
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            reserve.m_128405_(metal.getNameLower(), this.getAllomanticAmount(metal));
            burningMetals.m_128379_(metal.getNameLower(), this.isBurning(metal));
            tappingMetals.m_128379_(metal.getNameLower(), this.isTapping(metal));
            storingMetals.m_128379_(metal.getNameLower(), this.isStoring(metal));
        }
        extraData.m_128365_("reserve", (Tag)reserve);
        extraData.m_128365_("burning", (Tag)burningMetals);
        extraData.m_128365_("tapping", (Tag)tappingMetals);
        extraData.m_128365_("storing", (Tag)storingMetals);
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            metalEnhanced.m_128379_(metal.getNameLower(), this.getMetalsEnhanced().contains(metal));
        }
        enhanced.m_128379_("is_enhanced", this.getEnhanced());
        enhanced.m_128365_("metal_enhanced", (Tag)metalEnhanced);
        extraData.m_128365_("enhanced_data", (Tag)enhanced);
        extraData.m_128379_("has_modified_health", this.hasModifiedHealth());
        extraData.m_128359_("ettmetal_state", this.getEttmetalState().getName());
        extraData.m_128379_("is_first_join", this.isFirstJoin());
        playerData.m_128365_("extra_data", (Tag)extraData);
        return playerData;
    }

    @Override
    public void load(CompoundTag playerData) {
        CompoundTag spikes = playerData.m_128469_("spikes");
        CompoundTag head = spikes.m_128469_("body_head");
        CompoundTag back = spikes.m_128469_("body_back");
        CompoundTag chest = spikes.m_128469_("body_chest");
        CompoundTag legs = spikes.m_128469_("body_legs");
        CompoundTag arms = spikes.m_128469_("body_arms");
        CompoundTag metalminds = playerData.m_128469_("metalminds");
        CompoundTag extraData = playerData.m_128469_("extra_data");
        CompoundTag reserve = extraData.m_128469_("reserve");
        CompoundTag burning = extraData.m_128469_("burning");
        CompoundTag tapping = extraData.m_128469_("tapping");
        CompoundTag storing = extraData.m_128469_("storing");
        CompoundTag enhanced = extraData.m_128469_("enhanced_data");
        CompoundTag metalEnhanced = extraData.m_128469_("metal_enhanced");
        if (head.m_128461_("head_front_0") != null && !head.m_128461_("head_front_0").equals("empty")) {
            if (head.m_128461_("head_front_0").contains("allomantic")) {
                this.player.getHead().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(head.m_128461_("head_front_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.FRONT);
            } else {
                this.player.getHead().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(head.m_128461_("head_front_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.FRONT);
            }
        }
        if (head.m_128461_("head_back_0") != null && !head.m_128461_("head_back_0").equals("empty")) {
            if (head.m_128461_("head_back_0").contains("allomantic")) {
                this.player.getHead().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(head.m_128461_("head_back_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.BACK);
            } else {
                this.player.getHead().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(head.m_128461_("head_back_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.BACK);
            }
        }
        if (head.m_128461_("head_front_1") != null && !head.m_128461_("head_front_1").equals("empty")) {
            if (head.m_128461_("head_front_1").contains("allomantic")) {
                this.player.getHead().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(head.m_128461_("head_front_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.FRONT);
            } else {
                this.player.getHead().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(head.m_128461_("head_front_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.FRONT);
            }
        }
        if (back.m_128461_("back_back_0") != null && !back.m_128461_("back_back_0").equals("empty")) {
            if (back.m_128461_("back_back_0").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.BACK);
            }
        }
        if (back.m_128461_("back_back_1") != null && !back.m_128461_("back_back_1").equals("empty")) {
            if (back.m_128461_("back_back_1").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.BACK);
            }
        }
        if (back.m_128461_("back_back_2") != null && !back.m_128461_("back_back_2").equals("empty")) {
            if (back.m_128461_("back_back_2").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_2")), TypeOfSpikeEnum.ALLOMANTIC), 2, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_2")), TypeOfSpikeEnum.FERUCHEMIC), 2, BodySlotEnum.BACK);
            }
        }
        if (back.m_128461_("back_back_3") != null && !back.m_128461_("back_back_3").equals("empty")) {
            if (back.m_128461_("back_back_3").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_3")), TypeOfSpikeEnum.ALLOMANTIC), 3, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_3")), TypeOfSpikeEnum.FERUCHEMIC), 3, BodySlotEnum.BACK);
            }
        }
        if (back.m_128461_("back_back_4") != null && !back.m_128461_("back_back_4").equals("empty")) {
            if (back.m_128461_("back_back_4").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_4")), TypeOfSpikeEnum.ALLOMANTIC), 4, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_4")), TypeOfSpikeEnum.FERUCHEMIC), 4, BodySlotEnum.BACK);
            }
        }
        if (back.m_128461_("back_back_5") != null && !back.m_128461_("back_back_5").equals("empty")) {
            if (back.m_128461_("back_back_5").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_5")), TypeOfSpikeEnum.ALLOMANTIC), 5, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_5")), TypeOfSpikeEnum.FERUCHEMIC), 5, BodySlotEnum.BACK);
            }
        }
        if (back.m_128461_("back_back_6") != null && !back.m_128461_("back_back_6").equals("empty")) {
            if (back.m_128461_("back_back_6").contains("allomantic")) {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_6")), TypeOfSpikeEnum.ALLOMANTIC), 6, BodySlotEnum.BACK);
            } else {
                this.player.getBack().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(back.m_128461_("back_back_6")), TypeOfSpikeEnum.FERUCHEMIC), 6, BodySlotEnum.BACK);
            }
        }
        if (chest.m_128461_("chest_front_0") != null && !chest.m_128461_("chest_front_0").equals("empty")) {
            if (chest.m_128461_("chest_front_0").contains("allomantic")) {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.FRONT);
            } else {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.FRONT);
            }
        }
        if (chest.m_128461_("chest_front_1") != null && !chest.m_128461_("chest_front_1").equals("empty")) {
            if (chest.m_128461_("chest_front_1").contains("allomantic")) {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.FRONT);
            } else {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.FRONT);
            }
        }
        if (chest.m_128461_("chest_front_2") != null && !chest.m_128461_("chest_front_2").equals("empty")) {
            if (chest.m_128461_("chest_front_2").contains("allomantic")) {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_2")), TypeOfSpikeEnum.ALLOMANTIC), 2, BodySlotEnum.FRONT);
            } else {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_2")), TypeOfSpikeEnum.FERUCHEMIC), 2, BodySlotEnum.FRONT);
            }
        }
        if (chest.m_128461_("chest_front_3") != null && !chest.m_128461_("chest_front_3").equals("empty")) {
            if (chest.m_128461_("chest_front_3").contains("allomantic")) {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_3")), TypeOfSpikeEnum.ALLOMANTIC), 3, BodySlotEnum.FRONT);
            } else {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_3")), TypeOfSpikeEnum.FERUCHEMIC), 3, BodySlotEnum.FRONT);
            }
        }
        if (chest.m_128461_("chest_front_4") != null && !chest.m_128461_("chest_front_4").equals("empty")) {
            if (chest.m_128461_("chest_front_4").contains("allomantic")) {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_4")), TypeOfSpikeEnum.ALLOMANTIC), 4, BodySlotEnum.FRONT);
            } else {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_4")), TypeOfSpikeEnum.FERUCHEMIC), 4, BodySlotEnum.FRONT);
            }
        }
        if (chest.m_128461_("chest_front_5") != null && !chest.m_128461_("chest_front_5").equals("empty")) {
            if (chest.m_128461_("chest_front_5").contains("allomantic")) {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_5")), TypeOfSpikeEnum.ALLOMANTIC), 5, BodySlotEnum.FRONT);
            } else {
                this.player.getChest().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(chest.m_128461_("chest_front_5")), TypeOfSpikeEnum.FERUCHEMIC), 5, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_front_0") != null && !arms.m_128461_("arms_front_0").equals("empty")) {
            if (arms.m_128461_("arms_front_0").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.FRONT);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_front_1") != null && !arms.m_128461_("arms_front_1").equals("empty")) {
            if (arms.m_128461_("arms_front_1").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.FRONT);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_front_2") != null && !arms.m_128461_("arms_front_2").equals("empty")) {
            if (arms.m_128461_("arms_front_2").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_2")), TypeOfSpikeEnum.ALLOMANTIC), 2, BodySlotEnum.FRONT);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_2")), TypeOfSpikeEnum.FERUCHEMIC), 2, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_front_3") != null && !arms.m_128461_("arms_front_3").equals("empty")) {
            if (arms.m_128461_("arms_front_3").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_3")), TypeOfSpikeEnum.ALLOMANTIC), 3, BodySlotEnum.FRONT);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_3")), TypeOfSpikeEnum.FERUCHEMIC), 3, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_front_4") != null && !arms.m_128461_("arms_front_4").equals("empty")) {
            if (arms.m_128461_("arms_front_4").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_4")), TypeOfSpikeEnum.ALLOMANTIC), 4, BodySlotEnum.FRONT);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_4")), TypeOfSpikeEnum.FERUCHEMIC), 4, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_front_5") != null && !arms.m_128461_("arms_front_5").equals("empty")) {
            if (arms.m_128461_("arms_front_5").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_5")), TypeOfSpikeEnum.ALLOMANTIC), 5, BodySlotEnum.FRONT);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_front_5")), TypeOfSpikeEnum.FERUCHEMIC), 5, BodySlotEnum.FRONT);
            }
        }
        if (arms.m_128461_("arms_back_0") != null && !arms.m_128461_("arms_back_0").equals("empty")) {
            if (arms.m_128461_("arms_back_0").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.BACK);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.BACK);
            }
        }
        if (arms.m_128461_("arms_back_1") != null && !arms.m_128461_("arms_back_1").equals("empty")) {
            if (arms.m_128461_("arms_back_1").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.BACK);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.BACK);
            }
        }
        if (arms.m_128461_("arms_back_2") != null && !arms.m_128461_("arms_back_2").equals("empty")) {
            if (arms.m_128461_("arms_back_2").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_2")), TypeOfSpikeEnum.ALLOMANTIC), 2, BodySlotEnum.BACK);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_2")), TypeOfSpikeEnum.FERUCHEMIC), 2, BodySlotEnum.BACK);
            }
        }
        if (arms.m_128461_("arms_back_3") != null && !arms.m_128461_("arms_back_3").equals("empty")) {
            if (arms.m_128461_("arms_back_3").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_3")), TypeOfSpikeEnum.ALLOMANTIC), 3, BodySlotEnum.BACK);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_3")), TypeOfSpikeEnum.FERUCHEMIC), 3, BodySlotEnum.BACK);
            }
        }
        if (arms.m_128461_("arms_back_4") != null && !arms.m_128461_("arms_back_4").equals("empty")) {
            if (arms.m_128461_("arms_back_4").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_4")), TypeOfSpikeEnum.ALLOMANTIC), 4, BodySlotEnum.BACK);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_4")), TypeOfSpikeEnum.FERUCHEMIC), 4, BodySlotEnum.BACK);
            }
        }
        if (arms.m_128461_("arms_back_5") != null && !arms.m_128461_("arms_back_5").equals("empty")) {
            if (arms.m_128461_("arms_back_5").contains("allomantic")) {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_5")), TypeOfSpikeEnum.ALLOMANTIC), 5, BodySlotEnum.BACK);
            } else {
                this.player.getArms().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(arms.m_128461_("arms_back_5")), TypeOfSpikeEnum.FERUCHEMIC), 5, BodySlotEnum.BACK);
            }
        }
        if (legs.m_128461_("legs_front_0") != null && !legs.m_128461_("legs_front_0").equals("empty")) {
            if (legs.m_128461_("legs_front_0").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.FRONT);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.FRONT);
            }
        }
        if (legs.m_128461_("legs_front_1") != null && !legs.m_128461_("legs_front_1").equals("empty")) {
            if (legs.m_128461_("legs_front_1").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.FRONT);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.FRONT);
            }
        }
        if (legs.m_128461_("legs_front_2") != null && !legs.m_128461_("legs_front_2").equals("empty")) {
            if (legs.m_128461_("legs_front_2").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_2")), TypeOfSpikeEnum.ALLOMANTIC), 2, BodySlotEnum.FRONT);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_2")), TypeOfSpikeEnum.FERUCHEMIC), 2, BodySlotEnum.FRONT);
            }
        }
        if (legs.m_128461_("legs_front_3") != null && !legs.m_128461_("legs_front_3").equals("empty")) {
            if (legs.m_128461_("legs_front_3").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_3")), TypeOfSpikeEnum.ALLOMANTIC), 3, BodySlotEnum.FRONT);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_3")), TypeOfSpikeEnum.FERUCHEMIC), 3, BodySlotEnum.FRONT);
            }
        }
        if (legs.m_128461_("legs_front_4") != null && !legs.m_128461_("legs_front_4").equals("empty")) {
            if (legs.m_128461_("legs_front_4").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_4")), TypeOfSpikeEnum.ALLOMANTIC), 4, BodySlotEnum.FRONT);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_4")), TypeOfSpikeEnum.FERUCHEMIC), 4, BodySlotEnum.FRONT);
            }
        }
        if (legs.m_128461_("legs_front_5") != null && !legs.m_128461_("legs_front_5").equals("empty")) {
            if (legs.m_128461_("legs_front_5").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_5")), TypeOfSpikeEnum.ALLOMANTIC), 5, BodySlotEnum.FRONT);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_front_5")), TypeOfSpikeEnum.FERUCHEMIC), 5, BodySlotEnum.FRONT);
            }
        }
        if (legs.m_128461_("legs_back_0") != null && !legs.m_128461_("legs_back_0").equals("empty")) {
            if (legs.m_128461_("legs_back_0").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_0")), TypeOfSpikeEnum.ALLOMANTIC), 0, BodySlotEnum.BACK);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_0")), TypeOfSpikeEnum.FERUCHEMIC), 0, BodySlotEnum.BACK);
            }
        }
        if (legs.m_128461_("legs_back_1") != null && !legs.m_128461_("legs_back_1").equals("empty")) {
            if (legs.m_128461_("legs_back_1").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_1")), TypeOfSpikeEnum.ALLOMANTIC), 1, BodySlotEnum.BACK);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_1")), TypeOfSpikeEnum.FERUCHEMIC), 1, BodySlotEnum.BACK);
            }
        }
        if (legs.m_128461_("legs_back_2") != null && !legs.m_128461_("legs_back_2").equals("empty")) {
            if (legs.m_128461_("legs_back_2").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_2")), TypeOfSpikeEnum.ALLOMANTIC), 2, BodySlotEnum.BACK);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_2")), TypeOfSpikeEnum.FERUCHEMIC), 2, BodySlotEnum.BACK);
            }
        }
        if (legs.m_128461_("legs_back_3") != null && !legs.m_128461_("legs_back_3").equals("empty")) {
            if (legs.m_128461_("legs_back_3").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_3")), TypeOfSpikeEnum.ALLOMANTIC), 3, BodySlotEnum.BACK);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_3")), TypeOfSpikeEnum.FERUCHEMIC), 3, BodySlotEnum.BACK);
            }
        }
        if (legs.m_128461_("legs_back_4") != null && !legs.m_128461_("legs_back_4").equals("empty")) {
            if (legs.m_128461_("legs_back_4").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_4")), TypeOfSpikeEnum.ALLOMANTIC), 4, BodySlotEnum.BACK);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_4")), TypeOfSpikeEnum.FERUCHEMIC), 4, BodySlotEnum.BACK);
            }
        }
        if (legs.m_128461_("legs_back_5") != null && !legs.m_128461_("legs_back_5").equals("empty")) {
            if (legs.m_128461_("legs_back_5").contains("allomantic")) {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_5")), TypeOfSpikeEnum.ALLOMANTIC), 5, BodySlotEnum.BACK);
            } else {
                this.player.getLegs().addSpikeBySlot(new SpikeEntity(MetalTagsUtils.getMetalTagEnumByString(legs.m_128461_("legs_back_5")), TypeOfSpikeEnum.FERUCHEMIC), 5, BodySlotEnum.BACK);
            }
        }
        for (int i = 0; i < 10; ++i) {
            this.setMetalMindEquiped(i, metalminds.m_128471_("group_" + i));
        }
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            this.setTapping(metal, tapping.m_128471_(metal.getNameLower()));
            this.setStoring(metal, storing.m_128471_(metal.getNameLower()));
            this.setAllomanticMetalsAmount(metal, reserve.m_128451_(metal.getNameLower()));
            this.setBurning(metal, burning.m_128471_(metal.getNameLower()));
        }
        this.setEnhanced(enhanced.m_128471_("is_enhanced"));
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (!metalEnhanced.m_128471_(metal.getNameLower())) continue;
            this.addMetalsEnhanced(metal);
        }
        this.setModifiedHealth(extraData.m_128471_("has_modified_health"));
        this.setEttmetalState(EttmetalStateEnum.getEttmetaStateByName(extraData.m_128461_("ettmetal_state")));
        this.setFirstJoin(extraData.m_128471_("is_first_join"));
    }
}

