/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.player.data.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.model.body.ArmsPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.BackPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.BodyPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.ChestPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.HeadPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.LegsPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.enums.EttmetalStateEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.TypeOfSpikeEnum;

public class PlayerEntity {
    private HeadPartEntity head;
    private ChestPartEntity chest;
    private BackPartEntity back;
    private ArmsPartEntity arms;
    private LegsPartEntity legs;
    private HashMap<MetalTagEnum, Integer> allomanticReserve;
    private HashMap<MetalTagEnum, Boolean> burningMetals;
    private HashMap<MetalTagEnum, Boolean> tappingMetals;
    private HashMap<MetalTagEnum, Boolean> storingMetals;
    private ArrayList<Boolean> metalMindEquipped = new ArrayList(10);
    private Boolean enhanced = false;
    private ArrayList<MetalTagEnum> metalsEnhanced = new ArrayList();
    private Boolean modifiedHealth = false;
    private EttmetalStateEnum ettmetalStateEnum;
    private boolean firstJoin = true;

    public PlayerEntity() {
        this.head = new HeadPartEntity();
        this.chest = new ChestPartEntity();
        this.back = new BackPartEntity();
        this.arms = new ArmsPartEntity();
        this.legs = new LegsPartEntity();
        this.allomanticReserve = new HashMap();
        this.burningMetals = new HashMap();
        this.tappingMetals = new HashMap();
        this.storingMetals = new HashMap();
        this.metalMindEquipped = new ArrayList();
        this.metalsEnhanced = new ArrayList();
        this.ettmetalStateEnum = EttmetalStateEnum.NOTHING;
    }

    public boolean isFirstJoin() {
        return this.firstJoin;
    }

    public void setFirstJoin(boolean firstJoin) {
        this.firstJoin = firstJoin;
    }

    public boolean hasAnyAllomanticMetal() {
        boolean anyAllomanticMetal = Stream.of(this.head, this.chest, this.back, this.arms, this.legs).anyMatch(partOfBody -> partOfBody.getAllSpikes().stream().anyMatch(spike -> spike.getType().equals((Object)TypeOfSpikeEnum.ALLOMANTIC)));
        return anyAllomanticMetal;
    }

    public boolean hasAllomanticMetal(MetalTagEnum metal) {
        Optional<BodyPartEntity> bodyPart = Stream.of(this.head, this.chest, this.back, this.arms, this.legs).filter(bodyPartEntity -> bodyPartEntity.getAllSpikes().stream().anyMatch(spikeEntity -> spikeEntity.getType().equals((Object)TypeOfSpikeEnum.ALLOMANTIC) && spikeEntity.getMetal() != null && spikeEntity.getMetal().equals(metal))).findAny();
        return bodyPart.isPresent();
    }

    public boolean hasAnyFeruchemicMetal() {
        boolean anyFeruchemicMetal = Stream.of(this.head, this.chest, this.back, this.arms, this.legs).anyMatch(partOfBody -> partOfBody.getAllSpikes().stream().anyMatch(spike -> spike.getType().equals((Object)TypeOfSpikeEnum.FERUCHEMIC)));
        return anyFeruchemicMetal;
    }

    public boolean hasFeruchemicMetal(MetalTagEnum metal) {
        Optional<BodyPartEntity> bodyPart = Stream.of(this.head, this.chest, this.back, this.arms, this.legs).filter(bodyPartEntity -> bodyPartEntity.getAllSpikes().stream().anyMatch(spikeEntity -> spikeEntity.getType().equals((Object)TypeOfSpikeEnum.FERUCHEMIC) && spikeEntity.getMetal() != null && spikeEntity.getMetal().equals(metal))).findAny();
        return bodyPart.isPresent();
    }

    public long getCountAllomanticMetal() {
        return this.head.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.ALLOMANTIC).count() + this.chest.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.ALLOMANTIC).count() + this.back.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.ALLOMANTIC).count() + this.arms.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.ALLOMANTIC).count() + this.legs.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.ALLOMANTIC).count();
    }

    public long getCountFeruchemicMetal() {
        return this.head.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.FERUCHEMIC).count() + this.chest.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.FERUCHEMIC).count() + this.back.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.FERUCHEMIC).count() + this.arms.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.FERUCHEMIC).count() + this.legs.getAllSpikes().stream().filter(spike -> spike.getType() == TypeOfSpikeEnum.FERUCHEMIC).count();
    }

    public HeadPartEntity getHead() {
        return this.head;
    }

    public void setHead(HeadPartEntity head) {
        this.head = head;
    }

    public ChestPartEntity getChest() {
        return this.chest;
    }

    public void setChest(ChestPartEntity chest) {
        this.chest = chest;
    }

    public BackPartEntity getBack() {
        return this.back;
    }

    public void setBack(BackPartEntity back) {
        this.back = back;
    }

    public ArmsPartEntity getArms() {
        return this.arms;
    }

    public void setArms(ArmsPartEntity arms) {
        this.arms = arms;
    }

    public LegsPartEntity getLegs() {
        return this.legs;
    }

    public void setLegs(LegsPartEntity legs) {
        this.legs = legs;
    }

    public HashMap<MetalTagEnum, Integer> getAllomanticReserve() {
        return this.allomanticReserve;
    }

    public void setAllomanticReserve(HashMap<MetalTagEnum, Integer> allomanticReserve) {
        this.allomanticReserve = allomanticReserve;
    }

    public HashMap<MetalTagEnum, Boolean> getBurningMetals() {
        return this.burningMetals;
    }

    public void setBurningMetals(HashMap<MetalTagEnum, Boolean> burningMetals) {
        this.burningMetals = burningMetals;
    }

    public HashMap<MetalTagEnum, Boolean> getTappingMetals() {
        return this.tappingMetals;
    }

    public void setTappingMetals(HashMap<MetalTagEnum, Boolean> tappingMetals) {
        this.tappingMetals = tappingMetals;
    }

    public HashMap<MetalTagEnum, Boolean> getStoringMetals() {
        return this.storingMetals;
    }

    public void setStoringMetals(HashMap<MetalTagEnum, Boolean> storingMetals) {
        this.storingMetals = storingMetals;
    }

    public ArrayList<Boolean> getMetalMindEquipped() {
        return this.metalMindEquipped;
    }

    public void setMetalMindEquipped(ArrayList<Boolean> metalMindEquipped) {
        this.metalMindEquipped = metalMindEquipped;
    }

    public Boolean getEnhanced() {
        return this.enhanced;
    }

    public void setEnhanced(Boolean enhanced) {
        this.enhanced = enhanced;
    }

    public ArrayList<MetalTagEnum> getMetalsEnhanced() {
        return this.metalsEnhanced;
    }

    public void setMetalsEnhanced(ArrayList<MetalTagEnum> metalsEnhanced) {
        this.metalsEnhanced = metalsEnhanced;
    }

    public Boolean getModifiedHealth() {
        return this.modifiedHealth;
    }

    public void setModifiedHealth(Boolean modifiedHealth) {
        this.modifiedHealth = modifiedHealth;
    }

    public EttmetalStateEnum getEttmetalState() {
        return this.ettmetalStateEnum;
    }

    public void setEttmetalState(EttmetalStateEnum ettmetalStateEnum) {
        this.ettmetalStateEnum = ettmetalStateEnum;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PlayerEntity{");
        sb.append("head=").append(this.head);
        sb.append(", chest=").append(this.chest);
        sb.append(", back=").append(this.back);
        sb.append(", arms=").append(this.arms);
        sb.append(", legs=").append(this.legs);
        sb.append(", allomanticReserve=").append(this.allomanticReserve);
        sb.append(", burningMetals=").append(this.burningMetals);
        sb.append(", tappingMetals=").append(this.tappingMetals);
        sb.append(", storingMetals=").append(this.storingMetals);
        sb.append(", metalMindEquipped=").append(this.metalMindEquipped);
        sb.append(", enhanced=").append(this.enhanced);
        sb.append(", metalsEnhanced=").append(this.metalsEnhanced);
        sb.append(", modifiedHealth=").append(this.modifiedHealth);
        sb.append(", ettmetalState=").append((Object)this.ettmetalStateEnum);
        sb.append(", firstJoin=").append(this.firstJoin);
        sb.append(", hasAnyAllomanticMetal=").append(this.hasAnyAllomanticMetal());
        sb.append(", hasAnyFeruchemicMetal=").append(this.hasAnyFeruchemicMetal());
        sb.append(", countAllomanticMetal=").append(this.getCountAllomanticMetal());
        sb.append(", countFeruchemicMetal=").append(this.getCountFeruchemicMetal());
        sb.append('}');
        return sb.toString();
    }
}

