/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.providers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.data.player.data.InvestedPlayerData;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class ModInvestedPlayerDataProvider
implements ICapabilitySerializable<CompoundTag> {
    private final InvestedPlayerData data = new InvestedPlayerData();
    private final LazyOptional<IInvestedPlayerData> dataOptional = LazyOptional.of(() -> this.data);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return InvestedPlayerCapabilityRegister.PLAYER_CAP.orEmpty(cap, this.dataOptional.cast());
    }

    public CompoundTag serializeNBT() {
        if (InvestedPlayerCapabilityRegister.PLAYER_CAP == null) {
            return new CompoundTag();
        }
        return this.data.save();
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (InvestedPlayerCapabilityRegister.PLAYER_CAP != null) {
            this.data.load(nbt);
        }
    }

    public void invalidate() {
        this.dataOptional.invalidate();
    }
}

