/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_block_entities.crucible_furnace;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.rudahee.metallics_arts.modules.custom_block_entities.crucible_furnace.CrucibleFurnaceBlockEntity;
import net.rudahee.metallics_arts.setup.registries.ModBlocksRegister;
import net.rudahee.metallics_arts.setup.registries.ModMenuRegister;

public class CrucibleFurnaceMenu
extends AbstractContainerMenu {
    public final CrucibleFurnaceBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 6;

    public CrucibleFurnaceMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, (CrucibleFurnaceBlockEntity)inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(7));
    }

    public CrucibleFurnaceMenu(int id, Inventory inv, CrucibleFurnaceBlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuRegister.CRUCIBLE_FURNACE_MENU.get(), id);
        CrucibleFurnaceMenu.m_38869_((Container)inv, (int)6);
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.blockEntity = entity;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 7, 23));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 55, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 74, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 55, 63));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 74, 63));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 137, 65));
        });
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 42, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 42) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return CrucibleFurnaceMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocksRegister.CRUCIBLE_FURNACE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 7 + l * 18, 113 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 7 + i * 18, 171));
        }
    }

    public int getFuelQty() {
        int maxHeight = 51;
        double percentage = (double)this.data.m_6413_(2) / (double)this.data.m_6413_(3) * 100.0;
        return Math.min(maxHeight, (int)(percentage / 100.0 * (double)maxHeight));
    }

    public int getProgress() {
        int maxWidth = 24;
        double percentage = (double)this.data.m_6413_(0) / (double)this.data.m_6413_(1) * 100.0;
        return Math.min(maxWidth, (int)(percentage / 100.0 * (double)maxWidth));
    }

    public boolean isHot() {
        return this.data.m_6413_(2) != 0;
    }

    public int timeWithoutRecipe() {
        return this.data.m_6413_(4);
    }
}

