/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_block_entities.distillery;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.modules.custom_block_entities.distillery.DistilleryMenu;
import net.rudahee.metallics_arts.modules.custom_items.vials.LargeVial;
import net.rudahee.metallics_arts.modules.custom_items.vials.Vial;
import net.rudahee.metallics_arts.setup.registries.ModBlockEntitiesRegister;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DistilleryBlockEntity
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache instanceCache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            DistilleryBlockEntity.this.m_6596_();
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0, 1, 2, 3 -> 64;
                case 4 -> 1;
                default -> 0;
            };
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (Items.f_42593_ == stack.m_41720_()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (Items.f_151050_ == stack.m_41720_() || Items.f_151053_ == stack.m_41720_() || Items.f_151051_ == stack.m_41720_() || ModItemsRegister.ITEM_RAW_METAL.values().stream().anyMatch(m -> m == stack.m_41720_())) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (Items.f_42749_ == stack.m_41720_() || Items.f_42587_ == stack.m_41720_() || ModItemsRegister.ITEM_METAL_NUGGET.values().stream().anyMatch(m -> m == stack.m_41720_()) || ModItemsRegister.ITEM_GEMS_NUGGET.values().stream().anyMatch(m -> m == stack.m_41720_())) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (Items.f_42416_ == stack.m_41720_() || Items.f_42417_ == stack.m_41720_() || Items.f_151052_ == stack.m_41720_() || ModItemsRegister.ITEM_METAL_INGOT.values().stream().anyMatch(m -> m == stack.m_41720_()) || ModItemsRegister.ITEM_GEMS_BASE.values().stream().anyMatch(m -> m == stack.m_41720_())) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (ModItemsRegister.LARGE_VIAL.get() == stack.m_41720_()) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> DistilleryBlockEntity.this.progress;
                case 1 -> DistilleryBlockEntity.this.maxProgress;
                case 2 -> DistilleryBlockEntity.this.fuelStorage;
                case 3 -> DistilleryBlockEntity.this.maxFuelStorage;
                case 4 -> DistilleryBlockEntity.this.vialCanBeFilled;
                case 5 -> DistilleryBlockEntity.this.tickFuelAdded;
                case 6 -> DistilleryBlockEntity.this.tickProgress;
                case 7 -> DistilleryBlockEntity.this.tickAnimFuel;
                case 8 -> DistilleryBlockEntity.this.tickAnimRecipe;
                case 9 -> DistilleryBlockEntity.this.slotToCheck;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    DistilleryBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    DistilleryBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    DistilleryBlockEntity.this.fuelStorage = value;
                    break;
                }
                case 3: {
                    DistilleryBlockEntity.this.maxFuelStorage = value;
                    break;
                }
                case 4: {
                    DistilleryBlockEntity.this.vialCanBeFilled = value;
                    break;
                }
                case 5: {
                    DistilleryBlockEntity.this.tickFuelAdded = value;
                    break;
                }
                case 6: {
                    DistilleryBlockEntity.this.tickProgress = value;
                    break;
                }
                case 7: {
                    DistilleryBlockEntity.this.tickAnimFuel = value;
                    break;
                }
                case 8: {
                    DistilleryBlockEntity.this.tickAnimRecipe = value;
                    break;
                }
                case 9: {
                    DistilleryBlockEntity.this.slotToCheck = value;
                }
            }
        }

        public int m_6499_() {
            return 10;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int fuelStorage = 0;
    private int maxFuelStorage = 100;
    private int vialCanBeFilled = 0;
    private int tickFuelAdded = 0;
    private int slotToCheck = -1;
    private int tickProgress = 0;
    private int tickAnimFuel = 0;
    private int tickAnimRecipe = 0;
    public static final int SLOT_VOID = -1;
    public static final int SLOT_RAW = 1;
    public static final int SLOT_NUGGET = 2;
    public static final int SLOT_INGOT = 3;

    public DistilleryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntitiesRegister.DISTILLERY_ENTITY.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.metallics_arts.menu.distillery_menu.name");
    }

    @Deprecated(since="1.6.5", forRemoval=true)
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("distillery.progress", this.progress);
        tag.m_128405_("distillery.max_progress", this.maxProgress);
        tag.m_128405_("distillery.fuel_storage", this.fuelStorage);
        tag.m_128405_("distillery.max_fuel_storage", this.maxFuelStorage);
        tag.m_128405_("distillery.can_be_filled", this.vialCanBeFilled);
        tag.m_128405_("distillery.tick_fuel_added", this.tickFuelAdded);
        tag.m_128405_("distillery.slot_to_check", this.slotToCheck);
        tag.m_128405_("distillery.tick_progress", this.tickProgress);
        tag.m_128405_("distillery.tick_anim_fuel", this.tickAnimFuel);
        tag.m_128405_("distillery.tick_anim_recipe", this.tickAnimRecipe);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("distillery.progress");
        this.maxProgress = tag.m_128451_("distillery.max_progress");
        this.fuelStorage = tag.m_128451_("distillery.fuel_storage");
        this.maxFuelStorage = tag.m_128451_("distillery.max_fuel_storage");
        this.vialCanBeFilled = tag.m_128451_("distillery.can_be_filled");
        this.tickFuelAdded = tag.m_128451_("distillery.tick_fuel_added");
        this.tickProgress = tag.m_128451_("distillery.tick_progress");
        this.slotToCheck = tag.m_128451_("distillery.slot_to_check");
        this.tickAnimFuel = tag.m_128451_("distillery.tick_anim_fuel");
        this.tickAnimRecipe = tag.m_128451_("distillery.tick_anim_recipe");
        super.m_142466_(tag);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DistilleryBlockEntity entity) {
        if (!level.m_5776_()) {
            DistilleryBlockEntity.manageFuel(entity, level, pos, state);
            if (entity.fuelStorage > 0) {
                if (entity.slotToCheck == -1) {
                    entity.slotToCheck = DistilleryBlockEntity.hasMinimalItemsForRecipe(entity, level, pos, state);
                } else {
                    entity.slotToCheck = DistilleryBlockEntity.hasMinimalItemsForRecipe(entity, level, pos, state);
                    int newSlot = entity.slotToCheck;
                    if (newSlot != entity.slotToCheck) {
                        entity.tickProgress = 0;
                        entity.progress = 0;
                        entity.slotToCheck = -1;
                        DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                    } else if (entity.progress < entity.maxProgress) {
                        ++entity.progress;
                        DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                    } else {
                        DistilleryBlockEntity.removeItemsFromRecipe(entity, level, pos, state);
                        DistilleryBlockEntity.craftItemWithTags(entity, level, pos, state);
                        entity.tickProgress = 0;
                        entity.progress = 0;
                        entity.slotToCheck = -1;
                        entity.fuelStorage -= 3;
                        DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                    }
                }
            } else if (entity.fuelStorage <= 0) {
                entity.tickProgress = 0;
                entity.progress = 0;
                entity.slotToCheck = -1;
                DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
            if (entity.progress > 0 && (entity.slotToCheck == -1 || entity.itemHandler.getStackInSlot(4).m_150930_(ItemStack.f_41583_.m_41720_()) || Vial.hasFullReserveWithoutDivine(entity.itemHandler.getStackInSlot(4)))) {
                entity.tickProgress = 0;
                entity.progress = 0;
                entity.slotToCheck = -1;
                DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel servLevel = (ServerLevel)level;
            if (entity.fuelStorage > 0) {
                if (entity.tickProgress > 0) {
                    if (entity.tickAnimRecipe == 2) {
                        servLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, 0.0);
                        entity.tickAnimRecipe = 0;
                    } else {
                        ++entity.tickAnimRecipe;
                    }
                }
                if (entity.tickFuelAdded > 0) {
                    if (entity.tickAnimFuel == 1) {
                        servLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, 0.0);
                        entity.tickAnimRecipe = 0;
                    } else {
                        ++entity.tickAnimFuel;
                    }
                }
            }
        }
    }

    private static void manageFuel(DistilleryBlockEntity entity, Level level, BlockPos pos, BlockState state) {
        if (entity.itemHandler.getStackInSlot(0).m_150930_(Items.f_42593_)) {
            if (entity.fuelStorage < entity.maxFuelStorage) {
                if (entity.tickFuelAdded < 100) {
                    ++entity.tickFuelAdded;
                    DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                } else {
                    DistilleryBlockEntity.addFuel(entity, level, pos, state);
                    entity.tickFuelAdded = 0;
                    DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                }
            } else {
                entity.tickFuelAdded = 0;
                DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else {
            entity.tickFuelAdded = 0;
            DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static void removeItemsFromRecipe(DistilleryBlockEntity entity, Level level, BlockPos pos, BlockState state) {
        entity.itemHandler.extractItem(entity.slotToCheck, 1, false);
    }

    private static void craftItemWithTags(DistilleryBlockEntity entity, Level level, BlockPos pos, BlockState state) {
        MetalTagEnum metal = DistilleryBlockEntity.getMetalBasedOnSlot(entity);
        if (metal == null) {
            return;
        }
        ItemStack vialStack = entity.itemHandler.getStackInSlot(4);
        CompoundTag vialTag = vialStack.m_41784_();
        DistilleryBlockEntity.updateVialTag(entity, vialTag, metal);
        vialTag.m_128350_("CustomModelData", 1.0f);
        ItemStack finalResult = new ItemStack((ItemLike)ModItemsRegister.LARGE_VIAL.get(), 1);
        finalResult.m_41751_(vialTag);
    }

    private static MetalTagEnum getMetalBasedOnSlot(DistilleryBlockEntity entity) {
        ItemStack item = entity.itemHandler.getStackInSlot(entity.slotToCheck);
        if (item.m_41619_()) {
            return null;
        }
        String itemKey = item.m_41720_().toString().toLowerCase();
        if (entity.slotToCheck == 1 && itemKey.contains("raw_")) {
            return MetalTagEnum.getMetal(itemKey.replace("raw_", ""));
        }
        if (entity.slotToCheck == 3 && itemKey.contains("_ingot")) {
            return MetalTagEnum.getMetal(itemKey.replace("_ingot", ""));
        }
        if (entity.slotToCheck == 2 && itemKey.contains("_nugget")) {
            return MetalTagEnum.getMetal(itemKey.replace("_nugget", ""));
        }
        return null;
    }

    private static void updateVialTag(DistilleryBlockEntity entity, CompoundTag tag, MetalTagEnum metal) {
        int addedValue;
        String metalKey = metal.getNameLower();
        int currentValue = tag.m_128451_(metalKey);
        switch (entity.slotToCheck) {
            case 3: {
                int n = 10;
                break;
            }
            case 1: {
                int n = DistilleryBlockEntity.calculateRawSlotValue(currentValue);
                break;
            }
            case 2: {
                int n = Math.min(currentValue + 1, 10);
                break;
            }
            default: {
                int n = addedValue = 0;
            }
        }
        if (addedValue > currentValue) {
            tag.m_128405_(metalKey, addedValue);
        }
    }

    private static int calculateRawSlotValue(int currentValue) {
        if (currentValue < 10) {
            return Math.min(currentValue + 5, 10);
        }
        return currentValue;
    }

    private static int hasMinimalItemsForRecipe(DistilleryBlockEntity entity, Level level, BlockPos pos, BlockState state) {
        if (entity.itemHandler.getStackInSlot(3).m_41619_() && entity.itemHandler.getStackInSlot(1).m_41619_() && entity.itemHandler.getStackInSlot(2).m_41619_()) {
            return -1;
        }
        if (entity.itemHandler.getStackInSlot(4).m_41619_()) {
            return -1;
        }
        MetalTagEnum metalRaw = null;
        MetalTagEnum metalIngot = null;
        MetalTagEnum metalNugget = null;
        if (entity.itemHandler.getStackInSlot(1).m_41720_().toString().toLowerCase().contains("raw_")) {
            metalRaw = MetalTagEnum.getMetal(entity.itemHandler.getStackInSlot(1).m_41720_().toString().toLowerCase().replace("raw_", ""));
        }
        if (entity.itemHandler.getStackInSlot(2).m_41720_().toString().toLowerCase().contains("_nugget")) {
            metalNugget = MetalTagEnum.getMetal(entity.itemHandler.getStackInSlot(2).m_41720_().toString().toLowerCase().replace("_nugget", ""));
        }
        if (entity.itemHandler.getStackInSlot(3).m_41720_().toString().toLowerCase().contains("_ingot")) {
            metalIngot = MetalTagEnum.getMetal(entity.itemHandler.getStackInSlot(3).m_41720_().toString().toLowerCase().replace("_ingot", ""));
        }
        boolean flagRaw = false;
        boolean flagNugget = false;
        boolean flagIngot = false;
        if (metalRaw != null && !LargeVial.hasCompletedMetalReserve(entity.itemHandler.getStackInSlot(4), metalRaw)) {
            flagRaw = true;
        }
        if (metalNugget != null && !LargeVial.hasCompletedMetalReserve(entity.itemHandler.getStackInSlot(4), metalNugget)) {
            flagNugget = true;
        }
        if (metalIngot != null && !LargeVial.hasCompletedMetalReserve(entity.itemHandler.getStackInSlot(4), metalIngot)) {
            flagIngot = true;
        }
        if (!(flagRaw || flagNugget || flagIngot)) {
            return -1;
        }
        if (flagIngot) {
            return 3;
        }
        if (flagRaw) {
            return 1;
        }
        if (flagNugget) {
            return 2;
        }
        return -1;
    }

    private static void addFuel(DistilleryBlockEntity entity, Level level, BlockPos pos, BlockState state) {
        if (entity.fuelStorage >= 95) {
            entity.fuelStorage = entity.maxFuelStorage;
            DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        } else {
            entity.fuelStorage += 5;
            DistilleryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        entity.itemHandler.extractItem(0, 1, false);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new DistilleryMenu(id, inv, this, this.data);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }
}

