/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_block_entities.hemalurgy_altar_block.back;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.data.player.data.model.SpikeEntity;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodyPartEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodySlotEnum;
import net.rudahee.metallics_arts.modules.custom_block_entities.hemalurgy_altar_block.back.HemalurgyAltarBackBlockEntity;
import net.rudahee.metallics_arts.modules.custom_items.metal_spikes.MetalSpike;
import net.rudahee.metallics_arts.modules.error_handling.utils.LoggerUtils;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.setup.registries.ModBlocksRegister;
import net.rudahee.metallics_arts.setup.registries.ModMenuRegister;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import net.rudahee.metallics_arts.utils.HemalurgyUtils;
import org.jetbrains.annotations.NotNull;

public class HemalurgyAltarBackMenu
extends AbstractContainerMenu {
    private final Level level;
    private Player player;
    private final ContainerData data;
    private HemalurgyAltarBackBlockEntity blockEntity;

    public HemalurgyAltarBackMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, (HemalurgyAltarBackBlockEntity)inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(0));
    }

    public HemalurgyAltarBackMenu(int id, Inventory inv, HemalurgyAltarBackBlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuRegister.HEMALURGY_ALTAR_BACK_MENU.get(), id);
        HemalurgyAltarBackMenu.m_38869_((Container)inv, (int)20);
        this.player = inv.f_35978_;
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.blockEntity = entity;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, -9, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 14, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 33, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 53, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 74, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 95, 44));
            this.m_38897_((Slot)new SlotItemHandler(handler, 6, 47, 25));
            this.m_38897_((Slot)new SlotItemHandler(handler, 7, 47, 63));
            this.m_38897_((Slot)new SlotItemHandler(handler, 8, 44, 4));
            this.m_38897_((Slot)new SlotItemHandler(handler, 9, 65, 4));
            this.m_38897_((Slot)new SlotItemHandler(handler, 10, 86, 4));
            this.m_38897_((Slot)new SlotItemHandler(handler, 11, 44, 84));
            this.m_38897_((Slot)new SlotItemHandler(handler, 12, 65, 84));
            this.m_38897_((Slot)new SlotItemHandler(handler, 13, 86, 84));
            this.m_38897_((Slot)new SlotItemHandler(handler, 14, 122, 26));
            this.m_38897_((Slot)new SlotItemHandler(handler, 15, 145, 26));
            this.m_38897_((Slot)new SlotItemHandler(handler, 16, 168, 26));
            this.m_38897_((Slot)new SlotItemHandler(handler, 17, 122, 61));
            this.m_38897_((Slot)new SlotItemHandler(handler, 18, 145, 61));
            this.m_38897_((Slot)new SlotItemHandler(handler, 19, 168, 61));
        });
        this.m_38884_(data);
        this.initializeDataSlots();
    }

    private void initializeDataSlots() {
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            ItemStack stack = null;
            SpikeEntity spikeEntity = null;
            IInvestedPlayerData playerData = CapabilityUtils.getCapability(this.player);
            if (playerData == null) {
                return;
            }
            spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 0, BodySlotEnum.BACK, BodyPartEnum.HEAD);
            if (spikeEntity != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(0, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 1, BodySlotEnum.BACK, BodyPartEnum.HEAD)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(1, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 0, BodySlotEnum.BACK, BodyPartEnum.BACK)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(2, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 1, BodySlotEnum.BACK, BodyPartEnum.BACK)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(3, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 2, BodySlotEnum.BACK, BodyPartEnum.BACK)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(4, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 3, BodySlotEnum.BACK, BodyPartEnum.BACK)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(5, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 4, BodySlotEnum.BACK, BodyPartEnum.BACK)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(6, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 5, BodySlotEnum.BACK, BodyPartEnum.BACK)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(7, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 0, BodySlotEnum.BACK, BodyPartEnum.ARMS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(8, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 1, BodySlotEnum.BACK, BodyPartEnum.ARMS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(9, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 2, BodySlotEnum.BACK, BodyPartEnum.ARMS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(10, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 3, BodySlotEnum.BACK, BodyPartEnum.ARMS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(11, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 4, BodySlotEnum.BACK, BodyPartEnum.ARMS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(12, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 5, BodySlotEnum.BACK, BodyPartEnum.ARMS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(13, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 0, BodySlotEnum.BACK, BodyPartEnum.LEGS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(14, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 1, BodySlotEnum.BACK, BodyPartEnum.LEGS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(15, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 2, BodySlotEnum.BACK, BodyPartEnum.LEGS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(16, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 3, BodySlotEnum.BACK, BodyPartEnum.LEGS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(17, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 4, BodySlotEnum.BACK, BodyPartEnum.LEGS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(18, stack, false);
            }
            if ((spikeEntity = HemalurgyUtils.generateSpikeEntity(playerData, 5, BodySlotEnum.BACK, BodyPartEnum.LEGS)) != null) {
                stack = HemalurgyUtils.generateTags(spikeEntity);
                handler.insertItem(19, stack, false);
            }
        });
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return HemalurgyAltarBackMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocksRegister.HEMALURGY_ALTAR_BACK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 6 + l * 18, 131 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 6 + i * 18, 189));
        }
    }

    public void m_150399_(int slot, int button, @NotNull ClickType type, @NotNull Player player) {
        super.m_150399_(slot, button, type, player);
        if (player instanceof ServerPlayer) {
            LoggerUtils.printLogWarn("Holi: " + slot + ", " + button + ", " + String.valueOf(type));
            Player actualPlayer = player;
            try {
                IInvestedPlayerData cap = CapabilityUtils.getCapability(actualPlayer);
                if (button == 1) {
                    return;
                }
                if (ClickType.QUICK_MOVE == type || ClickType.CLONE == type || ClickType.PICKUP_ALL == type || ClickType.SWAP == type || ClickType.THROW == type) {
                    System.out.println("Haciendo nada con un click invalido");
                    return;
                }
                if ((ClickType.PICKUP == type || ClickType.QUICK_CRAFT == type) && button == 0 && slot >= 36 && slot <= 55) {
                    if (((Slot)this.f_38839_.get(slot)).m_7993_() == ItemStack.f_41583_) {
                        actualPlayer = this.removeMetalFromSlot(this.m_142621_(), (Slot)this.f_38839_.get(slot), cap, actualPlayer);
                    } else if (((Slot)this.f_38839_.get(slot)).m_7993_().m_41720_() instanceof MetalSpike) {
                        actualPlayer = this.addMetalFromSlot((Slot)this.f_38839_.get(slot), cap, actualPlayer);
                    }
                }
                if (actualPlayer == null) {
                    return;
                }
                this.player = actualPlayer;
                this.initializeDataSlots();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            player.m_6469_(player.m_269291_().m_269075_(player), 18.0f);
        }
    }

    private Player removeMetalFromSlot(ItemStack stack, Slot slot, IInvestedPlayerData playerData, Player player) {
        if (stack.m_41783_() == null) {
            return null;
        }
        if (MetalTagEnum.values()[stack.m_41783_().m_128451_("metal_spike")] == null) {
            return null;
        }
        MetalTagEnum metal = MetalTagEnum.values()[stack.m_41783_().m_128451_("metal_spike")];
        slot.m_6654_();
        if (stack.m_41783_().m_128471_("allomantic_power")) {
            playerData.removeAllomanticPower(metal);
        } else {
            playerData.removeFeruchemicPower(metal);
        }
        System.out.println("REMOVE METAL FROM SLOT. Is server?: " + (player instanceof ServerPlayer));
        if (player instanceof ServerPlayer) {
            ModNetwork.syncInvestedDataPacket(playerData, player);
        }
        return player;
    }

    private Player addMetalFromSlot(Slot slot, IInvestedPlayerData playerData, Player player) {
        boolean isAllomancy;
        if (slot.m_7993_().m_41783_() == null) {
            return null;
        }
        if (MetalTagEnum.values()[slot.m_7993_().m_41783_().m_128451_("metal_spike")] == null) {
            return null;
        }
        MetalTagEnum metal = MetalTagEnum.values()[slot.m_7993_().m_41783_().m_128451_("metal_spike")];
        int slotIndex = slot.getSlotIndex();
        int slotNum = HemalurgyUtils.calculateSlotNumBySlotIndex(slotIndex);
        BodyPartEnum part = HemalurgyUtils.calculateBodyPartBySlotIndex(slotIndex);
        if (slot.m_7993_().m_41783_().m_128471_("allomantic_power")) {
            playerData.addAllomanticPower(metal, part, BodySlotEnum.BACK, slotNum);
            isAllomancy = true;
        } else {
            playerData.addFeruchemicPower(metal, part, BodySlotEnum.BACK, slotNum);
            isAllomancy = false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HemalurgyUtils.giveAdvancements(metal, isAllomancy, serverPlayer);
            ModNetwork.syncInvestedDataPacket(playerData, player);
        }
        return player;
    }
}

