/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_entities.custom_bosses.iron_inquisitor;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.rudahee.metallics_arts.modules.custom_goals.PullBossGoal;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class IronInquisitor
extends PathfinderMob
implements GeoEntity,
Enemy,
PowerableMob {
    private final AnimatableInstanceCache instanceCache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean powered = false;
    private int phase = 0;
    private boolean alreadyGoalChanged = false;
    private int tickCounterPowered = 0;
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public IronInquisitor(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 1000;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.4, true));
        this.f_21345_.m_25352_(2, (Goal)new PullBossGoal((Mob)this, Player.class, this.phase));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder getIronInquisitorAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 130.0).m_22268_(Attributes.f_22283_, 4.5);
    }

    public static boolean canSpawn(EntityType<IronInquisitor> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return false;
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.powered && this.phase == 0 && !this.alreadyGoalChanged) {
            this.phase = 1;
            this.alreadyGoalChanged = true;
            Optional<WrappedGoal> goal = this.f_21345_.m_148105_().stream().filter(wrapped -> wrapped.m_26015_() instanceof PullBossGoal).findFirst();
            goal.ifPresent(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
            this.f_21345_.m_25352_(2, (Goal)new PullBossGoal((Mob)this, Player.class, this.phase));
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f) {
            if (this.tickCounterPowered++ < 100) {
                this.powered = true;
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().m_7096_() + 0.5, this.m_20182_().m_7098_() + 0.5, this.m_20182_().m_7094_() + 0.5, 0, 0.0, 0.5, 0.5, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.m_20182_().m_7096_() + 0.5, this.m_20182_().m_7098_() + 0.5, this.m_20182_().m_7094_() + 0.5, 0, 0.0, 0.5, 0.5, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20182_().m_7096_() + 0.5, this.m_20182_().m_7098_() + 0.5, this.m_20182_().m_7094_() + 0.5, 0, 0.0, 0.5, 0.5, 0.0);
                }
            } else {
                this.powered = false;
            }
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float v) {
        if (this.m_7090_()) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    public boolean m_7327_(Entity entity) {
        if (this.m_7090_()) {
            return false;
        }
        return super.m_7327_(entity);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> animationState) {
        if (this.m_7090_()) {
            animationState.getController().setAnimationSpeed(10.0);
        } else {
            animationState.getController().setAnimationSpeed(1.0);
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public boolean m_7090_() {
        return this.powered;
    }
}

