/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.metal_minds;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalmindType;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.abstracts.MetalmindAbstract;
import net.rudahee.metallics_arts.modules.effects.ModEffects;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import top.theillusivec4.curios.api.SlotContext;

public class AluminumDuraluminMetalmind
extends MetalmindAbstract {
    public AluminumDuraluminMetalmind(Item.Properties properties, MetalmindType type) {
        super(properties, MetalTagEnum.ALUMINUM, MetalTagEnum.DURALUMIN, type);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> toolTips, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            int reserve = stack.m_41783_().m_128451_(this.getMetals(0).getNameLower() + "_feruchemic_reserve");
            if (reserve == 1) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.store_identity")));
            } else if (reserve == 2) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.tapping_identity")));
            } else {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.off_power")));
            }
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(1).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") / 20 + "s"));
            } else {
                int maxReserve = this.isBand(MetalmindType.BAND) ? this.getMetals(1).getMaxReserveBand() : this.getMetals(1).getMaxReserveRing();
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(1).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") * 100 / maxReserve + "%"));
            }
            if (level != null) {
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind.owner").m_130946_(": " + String.valueOf(stack.m_41783_().m_128461_("key").equals("Nobody") ? Component.m_237115_((String)"metallics_arts.metal_mind.nobody").getString() : (level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))) == null ? Component.m_237115_((String)"metallics_arts.metal_mind.owner_someone") : level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))).m_7755_().getString()))));
            }
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237113_((String)" "));
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.shift_info").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        CompoundTag compoundTag = stack.m_41783_();
        if (stack.m_41782_() && livingEntity.f_19853_ instanceof ServerLevel && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            IInvestedPlayerData playerCapability = CapabilityUtils.getCapability(player);
            int actualReserve = stack.m_41783_().m_128451_(this.getMetals(0).getNameLower() + "_feruchemic_reserve");
            if (!playerCapability.isTapping(MetalTagEnum.ALUMINUM) && !playerCapability.isStoring(MetalTagEnum.ALUMINUM) && actualReserve != 3) {
                stack.m_41751_(AluminumDuraluminMetalmind.turnOffPower(compoundTag, this.getMetals(0).getNameLower() + "_feruchemic_reserve"));
            }
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.m_41782_()) {
            stack.m_41751_(AluminumDuraluminMetalmind.turnOffPower(stack.m_41783_(), this.getMetals(0).getNameLower() + "_feruchemic_reserve"));
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    @Override
    public CompoundTag calculateFirstMetalDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalTapEffect(player, metal);
        compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", 1);
        return compoundTag;
    }

    @Override
    public CompoundTag calculateFirstMetalCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalStorageEffect(player, metal);
        compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", 2);
        return compoundTag;
    }

    public static CompoundTag turnOffPower(CompoundTag compoundTag, String metalKey) {
        compoundTag.m_128405_(metalKey, 3);
        return compoundTag;
    }
}

