/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.metal_minds;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalmindType;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.abstracts.MetalmindAbstract;
import net.rudahee.metallics_arts.modules.effects.ModEffects;

public class ChromiumNicrosilMetalmind
extends MetalmindAbstract {
    public ChromiumNicrosilMetalmind(Item.Properties properties, MetalmindType type) {
        super(properties, MetalTagEnum.CHROMIUM, MetalTagEnum.NICROSIL, type);
    }

    @Override
    public CompoundTag calculateSecondMetalDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalTapEffect(player, metal);
        compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", metalReserve - (nicConsume ? 0 : playerCapability.cantMetalsTapping()));
        return compoundTag;
    }

    @Override
    public CompoundTag calculateSecondMetalCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalStorageEffect(player, metal);
        int value = playerCapability.cantMetalsStoring();
        if (playerCapability.isStoring(MetalTagEnum.BRASS) && !player.m_6060_()) {
            --value;
        }
        compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", metalReserve + (nicConsume ? 0 : value));
        return compoundTag;
    }
}

