/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.metal_minds;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalmindType;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.abstracts.MetalmindAbstract;
import net.rudahee.metallics_arts.modules.effects.ModEffects;

public class LerasiumEttmetalMetalmind
extends MetalmindAbstract {
    public LerasiumEttmetalMetalmind(Item.Properties properties, MetalmindType type) {
        super(properties, MetalTagEnum.LERASIUM, MetalTagEnum.ETTMETAL, type);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> toolTips, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128451_(this.getMetals(0).getNameLower() + "_feruchemic_reserve") > 0) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.has_reserve")));
            } else {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(0).getNameLower())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.not_has_reserve")));
            }
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(1).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") / 41));
                if (level != null) {
                    toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind.owner").m_130946_(": " + String.valueOf(stack.m_41783_().m_128461_("key").equals("Nobody") ? Component.m_237115_((String)"metallics_arts.metal_mind.nobody").getString() : (level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))) == null ? Component.m_237115_((String)"metallics_arts.metal_mind.owner_someone") : level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))).m_7755_().getString()))));
                }
                toolTips.add((Component)Component.m_237115_((String)" "));
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.shift_info").m_130940_(ChatFormatting.BLUE));
            } else {
                int maxReserve = this.isBand(MetalmindType.BAND) ? this.getMetals(1).getMaxReserveBand() : this.getMetals(1).getMaxReserveRing();
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.getMetals(1).getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.getMetals(1).getNameLower() + "_feruchemic_reserve") * 100 / maxReserve + "%"));
                if (level != null) {
                    toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind.owner").m_130946_(": " + String.valueOf(stack.m_41783_().m_128461_("key").equals("Nobody") ? Component.m_237115_((String)"metallics_arts.metal_mind.nobody").getString() : (level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))) == null ? Component.m_237115_((String)"metallics_arts.metal_mind.owner_someone") : level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))).m_7755_().getString()))));
                }
                toolTips.add((Component)Component.m_237115_((String)"-------------------"));
                for (MetalTagEnum metal : MetalTagEnum.values()) {
                    if (stack.m_41783_().m_128451_(metal.getNameLower() + "inLerasiumBand") <= 0) continue;
                    toolTips.add((Component)Component.m_237115_((String)" * ").m_7220_((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + metal.getNameLower()))).m_130946_(": " + stack.m_41783_().m_128451_(metal.getNameLower() + "inLerasiumBand")));
                }
            }
        }
    }

    @Override
    public CompoundTag calculateFirstMetalDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalTapEffect(player, metal);
        if (this.allLerasiumReservesEmpty(compoundTag)) {
            compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", 0);
        } else {
            compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", 1);
        }
        return this.loadAllomanticReserve(playerCapability, compoundTag);
    }

    @Override
    public CompoundTag calculateFirstMetalCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        ModEffects.giveFeruchemicalStorageEffect(player, metal);
        if (this.hasAllReservesLerasiumFull(compoundTag)) {
            compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", 2);
        } else if (this.havePlayerAnyReserve(playerCapability)) {
            compoundTag = this.saveAllomanticReserve(playerCapability, compoundTag);
            compoundTag.m_128405_(metal.getNameLower() + "_feruchemic_reserve", 1);
        }
        return compoundTag;
    }

    private boolean hasAllReservesLerasiumFull(CompoundTag compoundTag) {
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (!compoundTag.m_128441_(metal.getNameLower() + "inLerasiumBand")) {
                compoundTag.m_128405_(metal.getNameLower() + "inLerasiumBand", 0);
            }
            if (compoundTag.m_128451_(metal.getNameLower() + "inLerasiumBand") >= metal.getMaxAllomanticTicksStorage() * 2) continue;
            return false;
        }
        return true;
    }

    private boolean allLerasiumReservesEmpty(CompoundTag compoundTag) {
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (!compoundTag.m_128441_(metal.getNameLower() + "inLerasiumBand")) {
                compoundTag.m_128405_(metal.getNameLower() + "inLerasiumBand", 0);
            }
            if (compoundTag.m_128451_(metal.getNameLower() + "inLerasiumBand") <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean havePlayerAnyReserve(IInvestedPlayerData playerCapability) {
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (playerCapability.getAllomanticAmount(metal) <= 0) continue;
            return true;
        }
        return false;
    }

    private CompoundTag saveAllomanticReserve(IInvestedPlayerData playerCapability, CompoundTag compoundTag) {
        ArrayList<MetalTagEnum> metals = playerCapability.getAllomanticPowers();
        for (MetalTagEnum metal : metals) {
            int reserveInBand = compoundTag.m_128451_(metal.getNameLower() + "inLerasiumBand");
            if (!playerCapability.hasAllomanticAmountOf(metal) || reserveInBand >= metal.getMaxAllomanticTicksStorage() * 2) continue;
            if (playerCapability.getAllomanticAmount(metal) <= metal.getMaxAllomanticTicksStorage() * 2 - reserveInBand) {
                compoundTag.m_128405_(metal.getNameLower() + "inLerasiumBand", reserveInBand + playerCapability.getAllomanticAmount(metal));
                playerCapability.setAllomanticMetalsAmount(metal, 0);
                continue;
            }
            compoundTag.m_128405_(metal.getNameLower() + "inLerasiumBand", metal.getMaxAllomanticTicksStorage() * 2);
            playerCapability.setAllomanticMetalsAmount(metal, playerCapability.getAllomanticAmount(metal) - (metal.getMaxAllomanticTicksStorage() * 2 - reserveInBand));
        }
        return compoundTag;
    }

    private CompoundTag loadAllomanticReserve(IInvestedPlayerData playerCapability, CompoundTag compoundTag) {
        ArrayList<MetalTagEnum> metals = playerCapability.getAllomanticPowers();
        for (MetalTagEnum metal : metals) {
            int reserveInBand = compoundTag.m_128451_(metal.getNameLower() + "inLerasiumBand");
            if (playerCapability.getAllomanticAmount(metal) >= metal.getMaxAllomanticTicksStorage() || reserveInBand <= 0) continue;
            if (metal.getMaxAllomanticTicksStorage() - playerCapability.getAllomanticAmount(metal) >= reserveInBand) {
                playerCapability.setAllomanticMetalsAmount(metal, reserveInBand);
                compoundTag.m_128405_(metal.getNameLower() + "inLerasiumBand", 0);
                continue;
            }
            playerCapability.setAllomanticMetalsAmount(metal, metal.getMaxAllomanticTicksStorage());
            compoundTag.m_128405_(metal.getNameLower() + "inLerasiumBand", reserveInBand - (metal.getMaxAllomanticTicksStorage() - playerCapability.getAllomanticAmount(metal)));
        }
        return compoundTag;
    }
}

