/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.metal_minds.abstracts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalmindType;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.effects.ModEffects;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import net.rudahee.metallics_arts.utils.MetalMindsUtils;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.RenderUtils;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class MetalmindAbstract
extends Item
implements ICurioItem,
GeoAnimatable {
    private final MetalTagEnum[] metals = new MetalTagEnum[2];
    public String unkeyedString = "Nobody";
    private MetalmindType type;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean nicConsume = false;
    private int tick;

    public MetalmindAbstract(Item.Properties properties, MetalTagEnum metal0, MetalTagEnum metal1, MetalmindType type) {
        super(properties);
        this.metals[0] = metal0;
        this.metals[1] = metal1;
        this.type = type;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        Player player = (Player)slotContext.getWearer();
        IInvestedPlayerData playerCapability = CapabilityUtils.getCapability(player);
        playerCapability.setMetalMindEquiped(this.metals[0].getGroup(), true);
        playerCapability.setMetalMindEquiped(this.metals[1].getGroup(), true);
        ModNetwork.syncInvestedDataPacket(playerCapability, player);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        Player player = (Player)slotContext.getWearer();
        if (stack.m_41720_() != newStack.m_41720_()) {
            IInvestedPlayerData playerCapability = CapabilityUtils.getCapability(player);
            playerCapability.setMetalMindEquiped(this.metals[0].getGroup(), false);
            playerCapability.setMetalMindEquiped(this.metals[1].getGroup(), false);
            playerCapability.setStoring(this.metals[0], false);
            playerCapability.setStoring(this.metals[1], false);
            playerCapability.setTapping(this.metals[0], false);
            playerCapability.setTapping(this.metals[1], false);
            ModNetwork.syncInvestedDataPacket(playerCapability, player);
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        IInvestedPlayerData playerCapability;
        super.canEquip(slotContext, stack);
        Player player = (Player)slotContext.entity();
        if (!stack.m_41782_()) {
            stack.m_41751_(this.addTags());
        }
        return !(playerCapability = CapabilityUtils.getCapability(player)).hasMetalMindEquiped(this.metals[0].getGroup()) && (stack.m_41783_().m_128461_("key").equals(this.unkeyedString) || player.m_20149_().equals(stack.m_41783_().m_128461_("key")));
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        IInvestedPlayerData playerCapability;
        super.canEquip(slotContext, stack);
        Player player = (Player)slotContext.entity();
        if (!stack.m_41782_()) {
            stack.m_41751_(this.addTags());
        }
        return !(playerCapability = CapabilityUtils.getCapability(player)).hasMetalMindEquiped(this.metals[0].getGroup()) && (stack.m_41783_().m_128461_("key").equals(this.unkeyedString) || player.m_20149_().equals(stack.m_41783_().m_128461_("key")));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> toolTips, TooltipFlag flagIn) {
        int maxReserve1;
        if (!stack.m_41782_()) {
            stack.m_41751_(this.addTags());
        }
        int maxReserve0 = this.type == MetalmindType.BAND ? this.metals[0].getMaxReserveBand() : this.metals[0].getMaxReserveRing();
        int n = maxReserve1 = this.type == MetalmindType.BAND ? this.metals[1].getMaxReserveBand() : this.metals[1].getMaxReserveRing();
        if (stack.m_41782_()) {
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.metals[0].getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.metals[0].getNameLower() + "_feruchemic_reserve") / 20 + "s"));
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.metals[1].getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.metals[1].getNameLower() + "_feruchemic_reserve") / 20 + "s"));
            } else {
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.metals[0].getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.metals[0].getNameLower() + "_feruchemic_reserve") * 100 / maxReserve0 + "%"));
                toolTips.add((Component)Component.m_237115_((String)("metallics_arts.metal_translate." + this.metals[1].getNameLower())).m_130946_(": " + stack.m_41783_().m_128451_(this.metals[1].getNameLower() + "_feruchemic_reserve") * 100 / maxReserve1 + "%"));
            }
            if (level != null) {
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind.owner").m_130946_(": " + String.valueOf(stack.m_41783_().m_128461_("key").equals("Nobody") ? Component.m_237115_((String)"metallics_arts.metal_mind.nobody").getString() : (level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))) == null ? Component.m_237115_((String)"metallics_arts.metal_mind.owner_someone") : level.m_46003_(UUID.fromString(stack.m_41783_().m_128461_("key"))).m_7755_().getString()))));
            }
            if (!Screen.m_96638_()) {
                toolTips.add((Component)Component.m_237113_((String)" "));
                toolTips.add((Component)Component.m_237115_((String)"metallics_arts.metal_mind_translate.shift_info").m_130940_(ChatFormatting.BLUE));
            }
        }
        super.m_7373_(stack, level, toolTips, flagIn);
    }

    private CompoundTag addTags() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_(this.metals[0].getNameLower() + "_feruchemic_reserve", 0);
        compoundTag.m_128405_(this.metals[1].getNameLower() + "_feruchemic_reserve", 0);
        compoundTag.m_128359_("key", this.unkeyedString);
        return compoundTag;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        CompoundTag compoundTag;
        LivingEntity livingEntity = slotContext.entity();
        if (!stack.m_41782_()) {
            stack.m_41751_(this.addTags());
        }
        if ((compoundTag = stack.m_41783_()) == null) {
            return;
        }
        if (livingEntity.f_19853_ instanceof ServerLevel && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            IInvestedPlayerData playerCapability = CapabilityUtils.getCapability(player);
            if (playerCapability.isTapping(MetalTagEnum.ALUMINUM) || playerCapability.isStoring(MetalTagEnum.ALUMINUM)) {
                stack.m_41751_(MetalMindsUtils.changeOwner(player, compoundTag, false, this.metals[0], this.metals[1]));
            }
            this.powerUse(compoundTag, stack, playerCapability, player, this.metals[0], true);
            this.powerUse(compoundTag, stack, playerCapability, player, this.metals[1], false);
            if (playerCapability.isStoring(MetalTagEnum.NICROSIL) || playerCapability.isTapping(MetalTagEnum.NICROSIL)) {
                this.nicConsume = !this.nicConsume;
            }
            ModNetwork.syncInvestedDataPacket(playerCapability, player);
        }
        super.curioTick(slotContext, stack);
    }

    private void powerUse(CompoundTag compoundTag, ItemStack stack, IInvestedPlayerData playerCapability, Player player, MetalTagEnum metal, boolean first) {
        int maxReserve;
        int actualReserve = stack.m_41783_().m_128451_(metal.getNameLower() + "_feruchemic_reserve");
        int n = maxReserve = this.type.equals((Object)MetalmindType.BAND) ? metal.getMaxReserveBand() : metal.getMaxReserveRing();
        if (playerCapability.isTapping(metal)) {
            if (actualReserve > 0) {
                if (first) {
                    stack.m_41751_(this.calculateFirstMetalDischarge(compoundTag, player, playerCapability, actualReserve, this.nicConsume, metal));
                } else {
                    stack.m_41751_(this.calculateSecondMetalDischarge(compoundTag, player, playerCapability, actualReserve, this.nicConsume, metal));
                }
            } else {
                stack.m_41751_(MetalMindsUtils.changeOwner(player, compoundTag, false, this.metals[0], this.metals[1]));
                playerCapability.setTapping(metal, false);
            }
        } else if (playerCapability.isStoring(metal)) {
            if (actualReserve < maxReserve) {
                stack.m_41751_(MetalMindsUtils.changeOwner(player, compoundTag, true, this.metals[0], this.metals[1]));
                if (first) {
                    stack.m_41751_(this.calculateFirstMetalCharge(compoundTag, player, playerCapability, actualReserve, this.nicConsume, metal));
                } else {
                    stack.m_41751_(this.calculateSecondMetalCharge(compoundTag, player, playerCapability, actualReserve, this.nicConsume, metal));
                }
            } else {
                playerCapability.setStoring(metal, false);
            }
        }
    }

    public MetalTagEnum getMetals(int pos) {
        return this.metals[pos];
    }

    public boolean isBand(MetalmindType type) {
        return this.type.equals((Object)type);
    }

    public CompoundTag calculateFirstMetalCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        return this.basicCharge(compoundTag, player, playerCapability, metalReserve, nicConsume, metal);
    }

    public CompoundTag calculateSecondMetalCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        return this.basicCharge(compoundTag, player, playerCapability, metalReserve, nicConsume, metal);
    }

    public CompoundTag calculateFirstMetalDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        return this.basicDischarge(compoundTag, player, playerCapability, metalReserve, nicConsume, metal);
    }

    public CompoundTag calculateSecondMetalDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        return this.basicDischarge(compoundTag, player, playerCapability, metalReserve, nicConsume, metal);
    }

    private CompoundTag basicCharge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        String metalKey = metal.getNameLower() + "_feruchemic_reserve";
        ModEffects.giveFeruchemicalStorageEffect(player, metal);
        if (!playerCapability.isStoring(MetalTagEnum.NICROSIL) || !nicConsume) {
            compoundTag.m_128405_(metalKey, metalReserve + 1);
        }
        return compoundTag;
    }

    private CompoundTag basicDischarge(CompoundTag compoundTag, Player player, IInvestedPlayerData playerCapability, int metalReserve, boolean nicConsume, MetalTagEnum metal) {
        String metalKey = metal.getNameLower() + "_feruchemic_reserve";
        ModEffects.giveFeruchemicalTapEffect(player, metal);
        if (playerCapability.isBurning(metal)) {
            if (!(this.tick % metal.getFeruchemicCompoundingMultiplier() != 0 || playerCapability.isTapping(MetalTagEnum.NICROSIL) && nicConsume)) {
                compoundTag.m_128405_(metalKey, metalReserve - 1);
            }
            ++this.tick;
            if (this.tick >= 4) {
                this.tick = 0;
            }
        } else if (!playerCapability.isTapping(MetalTagEnum.NICROSIL) || !nicConsume) {
            compoundTag.m_128405_(metalKey, metalReserve - 1);
        }
        return compoundTag;
    }

    public static CompoundTag addBandTagsFull(MetalTagEnum metal1, MetalTagEnum metal2) {
        CompoundTag nbt = new CompoundTag();
        if (metal1.equals(MetalTagEnum.ALUMINUM)) {
            nbt.m_128405_(metal1.getNameLower() + "_feruchemic_reserve", 3);
        } else if (metal1.equals(MetalTagEnum.LERASIUM)) {
            nbt.m_128405_(metal1.getNameLower() + "_feruchemic_reserve", 1);
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                nbt.m_128405_(metal.getNameLower() + "inLerasiumBand", metal.getMaxAllomanticTicksStorage());
            }
        } else {
            nbt.m_128405_(metal1.getNameLower() + "_feruchemic_reserve", metal1.getMaxReserveBand());
        }
        nbt.m_128405_(metal2.getNameLower() + "_feruchemic_reserve", metal2.getMaxReserveBand());
        nbt.m_128359_("key", "Nobody");
        return nbt;
    }

    public static CompoundTag addRingTagsFull(MetalTagEnum metal1, MetalTagEnum metal2) {
        CompoundTag nbt = new CompoundTag();
        if (metal1.equals(MetalTagEnum.ALUMINUM)) {
            nbt.m_128405_(metal1.getNameLower() + "_feruchemic_reserve", 3);
        } else if (metal1.equals(MetalTagEnum.LERASIUM)) {
            nbt.m_128405_(metal1.getNameLower() + "_feruchemic_reserve", 1);
            for (MetalTagEnum metal : MetalTagEnum.values()) {
                nbt.m_128405_(metal.getNameLower() + "inLerasiumBand", metal.getMaxAllomanticTicksStorage());
            }
        } else {
            nbt.m_128405_(metal1.getNameLower() + "_feruchemic_reserve", metal1.getMaxReserveRing());
        }
        nbt.m_128405_(metal2.getNameLower() + "_feruchemic_reserve", metal2.getMaxReserveRing());
        nbt.m_128359_("key", "Nobody");
        return nbt;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }
}

