/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.metal_spikes;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.error_handling.exceptions.PlayerException;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import net.rudahee.metallics_arts.utils.HemalurgyUtils;
import net.rudahee.metallics_arts.utils.StringsUtils;
import org.jetbrains.annotations.NotNull;

public class MetalSpike
extends SwordItem {
    private static final int ATTACK_DAMAGE = 1;
    private static final float ATTACK_SPEED = -3.0f;
    private MetalTagEnum metalSpike;
    private static final Tier tier = new Tier(){

        public int m_6609_() {
            return 1;
        }

        public float m_6624_() {
            return 0.0f;
        }

        public float m_6631_() {
            return 0.0f;
        }

        public int m_6604_() {
            return 0;
        }

        public int m_6601_() {
            return 0;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50723_});
        }
    };

    public MetalSpike(Item.Properties properties, MetalTagEnum metalTagEnum) {
        super(tier, 1, -3.0f, properties);
        this.metalSpike = metalTagEnum;
    }

    public boolean m_5812_(ItemStack stack) {
        try {
            if (stack.m_41782_()) {
                if (!(stack.m_41783_().m_128441_("metal_spike") && stack.m_41783_().m_128441_("feruchemic_power") && stack.m_41783_().m_128441_("allomantic_power"))) {
                    stack.m_41751_(this.generateTags(stack));
                }
                return stack.m_41783_().m_128471_("feruchemic_power") || stack.m_41783_().m_128471_("allomantic_power");
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasPlayerBothPowers(MetalTagEnum metal, IInvestedPlayerData capability) {
        return capability.hasAllomanticPower(metal) && capability.hasFeruchemicPower(metal);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> toolTips, @NotNull TooltipFlag flag) {
        if (stack.m_41782_()) {
            if (!(stack.m_41783_().m_128441_("metal_spike") && stack.m_41783_().m_128441_("feruchemic_power") && stack.m_41783_().m_128441_("allomantic_power"))) {
                stack.m_41751_(this.generateTags(stack));
            }
            if (stack.m_41783_().m_128471_("feruchemic_power")) {
                toolTips.add(StringsUtils.generateComponent("metallics_arts.spike_feruchemic_power"));
            }
            if (stack.m_41783_().m_128471_("allomantic_power")) {
                toolTips.add(StringsUtils.generateComponent("metallics_arts.spike_allomantic_power"));
            }
        }
        super.m_7373_(stack, level, toolTips, flag);
    }

    public CompoundTag generateTags(ItemStack stack) {
        stack.m_41783_().m_128405_("metal_spike", this.metalSpike.getIndex());
        stack.m_41783_().m_128379_("feruchemic_power", false);
        stack.m_41783_().m_128379_("allomantic_power", false);
        return stack.m_41783_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity source) {
        if (!(stack.m_41783_().m_128441_("metal_spike") && stack.m_41783_().m_128441_("feruchemic_power") && stack.m_41783_().m_128441_("allomantic_power"))) {
            stack.m_41751_(this.generateTags(stack));
        }
        if (target instanceof Player && source instanceof Player) {
            IInvestedPlayerData targetData;
            try {
                targetData = CapabilityUtils.getCapability((Entity)target);
            }
            catch (PlayerException ex) {
                ex.printCompleteLog();
                return false;
            }
            boolean hasAllomanticPower = targetData.hasAllomanticPower(MetalTagEnum.getMetal(stack.m_41783_().m_128451_("metal_spike")));
            boolean hasFeruchemicPower = targetData.hasFeruchemicPower(MetalTagEnum.getMetal(stack.m_41783_().m_128451_("metal_spike")));
            boolean couldStealPower = Math.random() > 0.5;
            boolean couldRemovePower = Math.random() < 0.75;
            boolean isAllomantic = Math.random() > 0.5;
            MetalTagEnum localMetal = MetalTagEnum.getMetal(stack.m_41783_().m_128451_("metal_spike"));
            Random rng = new Random();
            Level world = target.f_19853_;
            BlockPos pos = new BlockPos((Vec3i)target.m_20183_());
            if (stack.m_41783_().m_128471_("allomantic_power")) {
                if (!targetData.hasAllomanticPower(localMetal)) {
                    targetData.addAllomanticPower(localMetal);
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)target;
                        HemalurgyUtils.giveAdvancements(MetalTagEnum.getMetal(stack.m_41783_().m_128451_("metal_spike")), true, serverPlayer);
                    }
                    this.doEffects(world, pos);
                }
            } else if (stack.m_41783_().m_128471_("feruchemic_power")) {
                if (!targetData.hasFeruchemicPower(localMetal)) {
                    targetData.addFeruchemicPower(localMetal);
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)target;
                        HemalurgyUtils.giveAdvancements(MetalTagEnum.getMetal(stack.m_41783_().m_128451_("metal_spike")), false, serverPlayer);
                    }
                    this.doEffects(world, pos);
                }
            } else if (this.hasPlayerBothPowers(localMetal, targetData)) {
                if (isAllomantic) {
                    if (couldStealPower) {
                        if (couldRemovePower) {
                            targetData.removeAllomanticPower(localMetal);
                            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 1, false, false, false));
                            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false, false));
                        }
                        stack.m_41783_().m_128379_("allomantic_power", true);
                        this.addItemToPlayer((Player)source, stack);
                    }
                } else if (couldStealPower) {
                    if (couldRemovePower) {
                        targetData.removeFeruchemicPower(localMetal);
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 1, false, false, false));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false, false));
                    }
                    stack.m_41783_().m_128379_("feruchemic_power", true);
                    this.addItemToPlayer((Player)source, stack);
                }
            } else if (hasAllomanticPower) {
                if (couldStealPower) {
                    if (couldRemovePower) {
                        targetData.removeAllomanticPower(localMetal);
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 1, false, false, false));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 1, true, true, false));
                    }
                    stack.m_41783_().m_128379_("allomantic_power", true);
                    this.addItemToPlayer((Player)source, stack);
                }
            } else if (hasFeruchemicPower && couldStealPower) {
                if (couldRemovePower) {
                    targetData.removeFeruchemicPower(localMetal);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 1, true, true, false));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 1, true, true, false));
                }
                stack.m_41783_().m_128379_("feruchemic_power", true);
                this.addItemToPlayer((Player)source, stack);
            }
            ((Player)source).m_150109_().m_36057_(stack);
            ModNetwork.syncInvestedDataPacket(targetData, (Player)target);
        }
        return super.m_7579_(stack, target, source);
    }

    private void doEffects(Level level, BlockPos pos) {
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, level);
        lightning.m_20874_(true);
        lightning.m_20219_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        level.m_7967_((Entity)lightning);
    }

    public void addItemToPlayer(Player attacker, ItemStack stack) {
        ItemStack itemStack = stack.m_41777_();
        if (attacker.m_150109_().m_36062_() == -1) {
            attacker.m_7197_(itemStack, true, true);
        } else {
            attacker.m_36356_(itemStack);
        }
    }

    public static CompoundTag addSpikeWithAllomanticPower(MetalTagEnum metal) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("metal_spike", metal.getIndex());
        compoundTag.m_128379_("allomantic_power", true);
        compoundTag.m_128379_("feruchemic_power", false);
        return compoundTag;
    }

    public static CompoundTag addSpikeWithFeruchemicalPower(MetalTagEnum metal) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("metal_spike", metal.getIndex());
        compoundTag.m_128379_("allomantic_power", false);
        compoundTag.m_128379_("feruchemic_power", true);
        return compoundTag;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }
}

