/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_items.weapons.guns;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.rudahee.metallics_arts.data.enums.implementations.BulletType;
import net.rudahee.metallics_arts.data.enums.implementations.GunType;
import net.rudahee.metallics_arts.data.enums.implementations.GunsAccess;
import net.rudahee.metallics_arts.modules.custom_projectiles.BulletProjectile;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;

public class GunUtils {
    public static CompoundTag reload(CompoundTag compoundTag, Player player, GunType gunType) {
        int slot = GunUtils.hasBulletOfType(player, compoundTag.m_128461_(GunsAccess.BULLET_TYPE.getKey()), gunType);
        if (slot != -1 && compoundTag.m_128451_(GunsAccess.BULLETS.getKey()) < gunType.getMaxAmount()) {
            compoundTag.m_128405_(GunsAccess.BULLETS.getKey(), compoundTag.m_128451_(GunsAccess.BULLETS.getKey()) + 1);
            compoundTag.m_128350_("CustomModelData", GunUtils.updateTexture(compoundTag.m_128451_(GunsAccess.BULLETS.getKey()), gunType));
            player.m_150109_().m_7407_(slot, 1);
        } else {
            compoundTag.m_128359_(GunsAccess.STATE.getKey(), GunsAccess.READY.getKey());
            compoundTag.m_128350_("CustomModelData", 0.0f);
        }
        return compoundTag;
    }

    public static float updateTexture(int bullets, GunType gunType) {
        if (gunType == GunType.SHOTGUN) {
            if (bullets == 0) {
                return 2.0f;
            }
            if (bullets == 1) {
                return 3.0f;
            }
            return 4.0f;
        }
        if (gunType == GunType.RIFLE || gunType == GunType.RIFLE_SPYGLASS) {
            if (bullets == 0) {
                return 2.0f;
            }
            if (bullets == 1) {
                return 3.0f;
            }
        } else {
            if (gunType == GunType.REVOLVER) {
                if (bullets == 0) {
                    return 2.0f;
                }
                if (bullets == 1) {
                    return 3.0f;
                }
                if (bullets == 2) {
                    return 4.0f;
                }
                if (bullets == 3) {
                    return 5.0f;
                }
                if (bullets == 4) {
                    return 6.0f;
                }
                if (bullets == 5) {
                    return 7.0f;
                }
                return 8.0f;
            }
            if (gunType == GunType.VINDICATOR) {
                if (bullets == 0) {
                    return 2.0f;
                }
                if (bullets == 1) {
                    return 3.0f;
                }
                if (bullets == 2) {
                    return 4.0f;
                }
                if (bullets == 3) {
                    return 5.0f;
                }
                if (bullets == 4) {
                    return 6.0f;
                }
                if (bullets == 5) {
                    return 7.0f;
                }
                if (bullets == 6) {
                    return 8.0f;
                }
                if (bullets == 7) {
                    return 9.0f;
                }
                return 10.0f;
            }
        }
        return 0.0f;
    }

    private static int hasBulletOfType(Player player, String type, GunType gunType) {
        Item item = gunType == GunType.SHOTGUN ? (type.equals(BulletType.LEAD.getType()) ? (Item)ModItemsRegister.SHOTGUN_LEAD_BULLET.get() : (Item)ModItemsRegister.SHOTGUN_ALUMINUM_BULLET.get()) : (gunType == GunType.RIFLE || gunType == GunType.RIFLE_SPYGLASS ? (type.equals(BulletType.LEAD.getType()) ? (Item)ModItemsRegister.RIFLE_LEAD_BULLET.get() : (Item)ModItemsRegister.RIFLE_ALUMINUM_BULLET.get()) : (type.equals(BulletType.LEAD.getType()) ? (Item)ModItemsRegister.REVOLVER_LEAD_BULLET.get() : (Item)ModItemsRegister.REVOLVER_ALUMINUM_BULLET.get()));
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_(item)) continue;
            return player.m_150109_().m_36030_(stack);
        }
        return -1;
    }

    public static CompoundTag generateGunTags(GunType gunType) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_(GunsAccess.STATE.getKey(), GunsAccess.READY.getKey());
        compoundTag.m_128405_(GunsAccess.BULLETS.getKey(), 0);
        compoundTag.m_128359_(GunsAccess.BULLET_TYPE.getKey(), BulletType.LEAD.getType());
        return compoundTag;
    }

    public static boolean hasTags(CompoundTag compoundTag) {
        return compoundTag.m_128441_(GunsAccess.STATE.getKey()) && compoundTag.m_128441_(GunsAccess.BULLETS.getKey()) && compoundTag.m_128441_(GunsAccess.BULLET_TYPE.getKey());
    }

    public static CompoundTag shot(ItemStack gun, Level level, Player player, GunType gunType) {
        CompoundTag tag = gun.m_41783_();
        if (tag.m_128451_(GunsAccess.BULLETS.getKey()) > 0) {
            BulletProjectile bullet = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
            if (gunType != GunType.SHOTGUN) {
                if (gunType == GunType.RIFLE) {
                    bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 5.0f, 0.1f);
                } else if (gunType == GunType.RIFLE_SPYGLASS) {
                    bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 4.0f, 0.0f);
                } else {
                    bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 4.0f, 0.3f);
                }
                level.m_7967_((Entity)bullet);
            } else {
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                BulletProjectile bullet1 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet1.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet1);
                BulletProjectile bullet2 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet2.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet2);
                BulletProjectile bullet3 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet3.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet3);
                BulletProjectile bullet4 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet4.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet4);
                BulletProjectile bullet5 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet5.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet5);
                BulletProjectile bullet6 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet6.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet6);
                BulletProjectile bullet7 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet7.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet7);
                BulletProjectile bullet8 = new BulletProjectile(level, (LivingEntity)player, gunType, GunUtils.bulletTypeToShot(tag));
                bullet8.m_37251_((Entity)player, player.m_146909_() + (float)GunUtils.dispersion(), player.m_146908_() + (float)GunUtils.dispersion(), GunUtils.dispersion(), 1.0f, 1.0f);
                level.m_7967_((Entity)bullet8);
            }
            tag.m_128405_(GunsAccess.BULLETS.getKey(), tag.m_128451_(GunsAccess.BULLETS.getKey()) - 1);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"VACIO"));
        }
        return tag;
    }

    private static BulletType bulletTypeToShot(CompoundTag compoundTag) {
        return compoundTag.m_128461_(GunsAccess.BULLET_TYPE.getKey()).equals(BulletType.LEAD.getType()) ? BulletType.LEAD : BulletType.ALUMINUM;
    }

    public static int dispersion() {
        return new Random().nextInt(31) - 15;
    }

    public static CompoundTag changeAmmo(Player player, ItemStack stack) {
        if (stack.m_41783_().m_128451_(GunsAccess.BULLETS.getKey()) == 0) {
            if (stack.m_41783_().m_128461_(GunsAccess.BULLET_TYPE.getKey()).equals(BulletType.LEAD.getType())) {
                stack.m_41783_().m_128359_(GunsAccess.BULLET_TYPE.getKey(), BulletType.ALUMINUM.getType());
            } else {
                stack.m_41783_().m_128359_(GunsAccess.BULLET_TYPE.getKey(), BulletType.LEAD.getType());
            }
            player.m_213846_((Component)Component.m_237115_((String)("Municion actual:" + stack.m_41783_().m_128461_(GunsAccess.BULLET_TYPE.getKey()))));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No se puede cambiar, aun quedan cargas"));
        }
        return stack.m_41783_();
    }
}

