/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_projectiles;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.rudahee.metallics_arts.data.enums.implementations.BulletType;
import net.rudahee.metallics_arts.data.enums.implementations.GunType;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.error_handling.exceptions.PlayerException;
import net.rudahee.metallics_arts.setup.registries.ModEntityTypesRegister;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import net.rudahee.metallics_arts.utils.CapabilityUtils;

public class BulletProjectile
extends ThrowableItemProjectile {
    private GunType gunType;
    private BulletType bulletType;
    private int despawnTime;

    public BulletProjectile(EntityType<? extends BulletProjectile> entityType, Level level) {
        super(entityType, level);
        this.gunType = GunType.REVOLVER;
        this.bulletType = BulletType.LEAD;
        this.despawnTime = this.gunType.getDespawn();
    }

    public BulletProjectile(Level level, LivingEntity livingEntity, GunType gunType, BulletType bulletType) {
        super((EntityType)ModEntityTypesRegister.BULLET_PROJECTILE.get(), livingEntity, level);
        this.gunType = gunType;
        this.bulletType = bulletType;
        this.despawnTime = gunType.getDespawn();
    }

    public BulletProjectile(Level level, LivingEntity livingEntity) {
        super((EntityType)ModEntityTypesRegister.BULLET_PROJECTILE.get(), livingEntity, level);
        this.gunType = GunType.REVOLVER;
        this.bulletType = BulletType.LEAD;
        this.despawnTime = this.gunType.getDespawn();
    }

    public BulletProjectile(Level level, double v, double v1, double v2) {
        super((EntityType)ModEntityTypesRegister.BULLET_PROJECTILE.get(), v, v1, v2, level);
        this.gunType = GunType.REVOLVER;
        this.bulletType = BulletType.LEAD;
        this.despawnTime = this.gunType.getDespawn();
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected float m_7139_() {
        return 0.0f;
    }

    protected Item m_7881_() {
        return this.bulletType == BulletType.LEAD ? (Item)ModItemsRegister.LEAD_BULLET_PROJECTILE.get() : (Item)ModItemsRegister.ALUMINUM_BULLET_PROJECTILE.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.m_37454_();
        return itemstack.m_41619_() ? ParticleTypes.f_123813_ : new ItemParticleOption(ParticleTypes.f_123752_, itemstack);
    }

    public void m_8119_() {
        --this.despawnTime;
        if (this.despawnTime == 0) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public void m_7822_(byte b) {
        if (b == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_(particleoptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                IInvestedPlayerData playerCapability = CapabilityUtils.getCapability(entity);
                if (playerCapability.isBurning(MetalTagEnum.STEEL) && this.bulletType.getType().equals(BulletType.LEAD.getType())) {
                    BulletProjectile bullet = new BulletProjectile(this.f_19853_, (LivingEntity)player, this.gunType, this.bulletType);
                    bullet.m_37251_(entity, entity.m_146909_(), entity.m_146908_(), 0.0f, 5.0f, 1.0f);
                    this.f_19853_.m_7967_((Entity)bullet);
                }
            }
            catch (PlayerException ex) {
                ex.printCompleteLog();
            }
        }
        entity.m_6469_(entity.m_269291_().m_269390_(entity, this.m_19749_()), this.gunType.getDamage());
        Entity entitySource = this.m_19749_();
        if (entitySource != null && entitySource instanceof LivingEntity) {
            ((LivingEntity)entitySource).m_21335_(entity);
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }
}

