/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.client;

import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.data.player.poses.CustomPoses;
import net.rudahee.metallics_arts.modules.error_handling.exceptions.PlayerException;
import net.rudahee.metallics_arts.modules.error_handling.utils.LoggerUtils;
import net.rudahee.metallics_arts.modules.logic.client.client_events.OnClientTick;
import net.rudahee.metallics_arts.modules.logic.client.client_events.OnKeyInputEvent;
import net.rudahee.metallics_arts.modules.logic.client.client_events.OnMouseInputEvent;
import net.rudahee.metallics_arts.modules.logic.client.client_events.OnRenderGameOverlay;
import net.rudahee.metallics_arts.modules.logic.client.client_events.OnRenderLevelStage;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import net.rudahee.metallics_arts.setup.registries.ModRenderRegister;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import net.rudahee.metallics_arts.utils.MistUtils;

public class ClientEventHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderPlayerEvent(RenderPlayerEvent event) {
        Player player = event.getEntity();
        PlayerRenderer renderer = event.getRenderer();
        if (player != null) {
            ItemStack stack = player.m_21205_();
            if (player.m_21205_().m_150930_((Item)ModItemsRegister.REVOLVER.get()) || player.m_21205_().m_150930_((Item)ModItemsRegister.VINDICATOR.get())) {
                if (stack.m_41783_() != null && stack.m_41783_().m_128457_("CustomModelData") == 1.0f) {
                    ((PlayerModel)renderer.m_7200_()).f_102816_ = CustomPoses.getArmPose(CustomPoses.POSE_RIGHT_AIM);
                }
            } else if (player.m_21205_().m_150930_((Item)ModItemsRegister.SHOTGUN.get()) || player.m_21205_().m_150930_((Item)ModItemsRegister.RIFLE.get()) || player.m_21205_().m_150930_((Item)ModItemsRegister.RIFLE_WITH_SPYGLASS.get())) {
                ((PlayerModel)renderer.m_7200_()).f_102816_ = CustomPoses.getArmPose(CustomPoses.POSE_BOTH_AIM);
            } else if (player.m_21205_().m_150930_((Item)ModItemsRegister.KOLOSS_BLADE.get()) && player.m_21205_().m_41782_()) {
                try {
                    if (player.m_21205_().m_41783_() != null && player.m_21205_().m_41783_().m_128457_("CustomModelData") != 1.0f) {
                        ((PlayerModel)renderer.m_7200_()).f_102816_ = CustomPoses.getArmPose(CustomPoses.POSE_RIGHT_KOLOSS);
                    }
                }
                catch (NullPointerException ex) {
                    LoggerUtils.printLogInfo(ex.getMessage());
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogEvent(ViewportEvent.RenderFog event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Stream biome = player.m_9236_().m_204166_(player.m_20183_()).getTagKeys();
        BlockPos playerpos = new BlockPos(player.m_146903_(), player.m_146904_() + 20, player.m_146907_());
        if (biome.anyMatch(tagKey -> tagKey.equals((Object)Tags.Biomes.IS_CAVE)) || player.m_5842_() || !player.f_19853_.m_45527_(playerpos)) {
            return;
        }
        IInvestedPlayerData capabilities = CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_);
        if (capabilities == null) {
            return;
        }
        if (capabilities.isBurning(MetalTagEnum.TIN) || capabilities.isTapping(MetalTagEnum.TIN)) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance(295.0f);
            event.setCanceled(true);
        } else if (MistUtils.mist((Player)player, 12000, 14000)) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance((float)(300.0 - Math.floor((double)(player.m_9236_().m_6106_().m_6792_() - 12000L) / 7.0)));
            event.setCanceled(true);
        } else if (MistUtils.mist((Player)player, 14000, 22000)) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance(15.0f);
            event.setCanceled(true);
        } else if (MistUtils.mist((Player)player, 22000, 24000)) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance((float)(15.0 + Math.floor((double)(player.m_9236_().m_6106_().m_6792_() - 22000L) / 7.0)));
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        try {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            OnClientTick.onClientTick(event, Minecraft.m_91087_(), (Player)Minecraft.m_91087_().f_91074_, CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_));
        }
        catch (PlayerException ex) {
            ex.printResumeLog();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        try {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            OnKeyInputEvent.onKeyInputEvent(event, Minecraft.m_91087_(), (Player)Minecraft.m_91087_().f_91074_, CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_));
        }
        catch (PlayerException ex) {
            ex.printResumeLog();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Post event) {
        try {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            if (event.getButton() == 0 && event.getAction() == 1) {
                OnMouseInputEvent.OnPlayerUsingWeapon(Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND));
            }
            OnMouseInputEvent.OnMouseInputEvent((Player)Minecraft.m_91087_().f_91074_, CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_));
        }
        catch (PlayerException ex) {
            ex.printResumeLog();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGameOverlay(RegisterGuiOverlaysEvent event) {
        try {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            OnRenderGameOverlay.onRenderGameOverlay(event, Minecraft.m_91087_(), (Player)Minecraft.m_91087_().f_91074_, CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_));
        }
        catch (PlayerException ex) {
            ex.printResumeLog();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        try {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            OnRenderLevelStage.onRenderLevelStage(event, Minecraft.m_91087_(), (Player)Minecraft.m_91087_().f_91074_, CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_));
        }
        catch (PlayerException ex) {
            ex.printResumeLog();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onEntityRender(EntityRenderersEvent.RegisterRenderers event) {
        ModRenderRegister.register(event);
    }
}

