/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.client.client_events;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.rudahee.metallics_arts.data.enums.implementations.LinesColorEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.error_handling.exceptions.PlayerException;
import net.rudahee.metallics_arts.modules.error_handling.messages.ErrorTypes;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.mental_metals.BronzeAllomanticHelper;
import net.rudahee.metallics_arts.utils.FoundNearbyMetalUtils;
import net.rudahee.metallics_arts.utils.gui.DrawUtils;
import net.rudahee.metallics_arts.utils.powers_utils.MetalBlockUtils;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class OnRenderLevelStage {
    static GlobalPos respawnPos;
    static GlobalPos anotherPlayerDeathPos;

    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLevelStage(RenderLevelStageEvent event, Minecraft minecraft, @Nullable Player player, @Nullable IInvestedPlayerData capability) throws PlayerException {
        Vec3 sourceCameraVector;
        ResourceLocation texture;
        Vec3 playerPos;
        Vec3 lookDir;
        Vector3f lookDirection;
        Vec3 view;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || minecraft.f_91066_.m_92176_().m_90613_()) {
            return;
        }
        if (player == null) {
            throw new PlayerException(ErrorTypes.PLAYER_ERROR);
        }
        if (capability == null) {
            throw new PlayerException(ErrorTypes.PLAYER_CAPABILITY_ERROR);
        }
        if (!player.m_6084_()) {
            throw new PlayerException(ErrorTypes.PLAYER_DEAD_ERROR);
        }
        if (!capability.hasAnyAllomanticPower() && !capability.hasAnyFeruchemicPower()) {
            return;
        }
        Matrix4f transformationMatrix = DrawUtils.setUpForDrawingQuadLines(event);
        if (capability.isBurning(MetalTagEnum.IRON) || capability.isBurning(MetalTagEnum.STEEL)) {
            view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            lookDirection = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            lookDir = new Vec3((double)lookDirection.x(), (double)lookDirection.y(), (double)lookDirection.z());
            playerPos = Minecraft.m_91087_().f_91074_.m_20318_(event.getPartialTick()).m_82549_(new Vec3(0.0, 1.0, 0.0)).m_82549_(lookDir);
            texture = new ResourceLocation("metallics_arts", "textures/veffects/the_idle4_60_transluscent.png");
            sourceCameraVector = view.m_82546_(playerPos);
            OnRenderLevelStage.metalLines(event.getRenderTick(), event.getPartialTick(), view, transformationMatrix, playerPos, 0.005, texture, 31, 8, 32, FoundNearbyMetalUtils.getMetalEntities().stream().sorted(Comparator.comparingDouble(e -> -1.0 * playerPos.m_82546_(e.m_20318_(event.getPartialTick())).m_82541_().m_82526_(sourceCameraVector.m_82541_()))).toList(), FoundNearbyMetalUtils.getMetalBlocks().stream().sorted(Comparator.comparingDouble(e -> -1.0 * playerPos.m_82546_(e.getCenter()).m_82541_().m_82526_(sourceCameraVector.m_82541_()))).toList());
        }
        if (capability.isBurning(MetalTagEnum.BRONZE)) {
            view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            lookDirection = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            lookDir = new Vec3((double)lookDirection.x(), (double)lookDirection.y(), (double)lookDirection.z());
            playerPos = Minecraft.m_91087_().f_91074_.m_20318_(event.getPartialTick()).m_82549_(new Vec3(0.0, 1.0, 0.0)).m_82549_(lookDir);
            texture = new ResourceLocation("metallics_arts", "textures/veffects/the_idle4_60_copper_translucent.png");
            sourceCameraVector = view.m_82546_(playerPos);
            OnRenderLevelStage.metalLines(event.getRenderTick(), event.getPartialTick(), view, transformationMatrix, playerPos, 0.005, texture, 31, 8, 32, BronzeAllomanticHelper.allomancers(player, capability.isBurning(MetalTagEnum.LERASIUM)));
        }
        if (capability.isBurning(MetalTagEnum.GOLD)) {
            view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            lookDirection = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            lookDir = new Vec3((double)lookDirection.x(), (double)lookDirection.y(), (double)lookDirection.z());
            playerPos = Minecraft.m_91087_().f_91074_.m_20318_(event.getPartialTick()).m_82549_(new Vec3(0.0, 1.0, 0.0)).m_82549_(lookDir);
            texture = new ResourceLocation("metallics_arts", "textures/veffects/the_idle4_60_yellow_translucent.png");
            sourceCameraVector = view.m_82546_(playerPos);
            if (player.m_219759_().isPresent()) {
                DrawUtils.drawMetalQuadLines(event.getRenderTick(), view, transformationMatrix, Vec3.m_82512_((Vec3i)((GlobalPos)player.m_219759_().get()).m_122646_()), playerPos, 0.005, texture, 16, 8, 32);
            } else {
                DrawUtils.drawMetalQuadLines(event.getRenderTick(), view, transformationMatrix, new Vec3((double)player.f_19853_.m_6106_().m_6789_(), (double)(player.f_19853_.m_6106_().m_6527_() + 1), (double)player.f_19853_.m_6106_().m_6526_()), playerPos, 0.005, texture, 16, 8, 32);
            }
        }
        if (capability.isBurning(MetalTagEnum.ELECTRUM)) {
            view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            lookDirection = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            lookDir = new Vec3((double)lookDirection.x(), (double)lookDirection.y(), (double)lookDirection.z());
            playerPos = Minecraft.m_91087_().f_91074_.m_20318_(event.getPartialTick()).m_82549_(new Vec3(0.0, 1.0, 0.0)).m_82549_(lookDir);
            texture = new ResourceLocation("metallics_arts", "textures/veffects/the_idle4_60_yellow_translucent.png");
            sourceCameraVector = view.m_82546_(playerPos);
            if (respawnPos == null) {
                DrawUtils.drawMetalQuadLines(event.getRenderTick(), view, transformationMatrix, new Vec3((double)player.f_19853_.m_6106_().m_6789_(), (double)(player.f_19853_.m_6106_().m_6527_() + 1), (double)player.f_19853_.m_6106_().m_6526_()), playerPos, 0.005, texture, 16, 8, 32);
            } else {
                DrawUtils.drawMetalQuadLines(event.getRenderTick(), view, transformationMatrix, Vec3.m_82512_((Vec3i)respawnPos.m_122646_()), playerPos, 0.005, texture, 16, 8, 32);
            }
        }
        if (capability.isBurning(MetalTagEnum.MALATIUM)) {
            view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            lookDirection = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            lookDir = new Vec3((double)lookDirection.x(), (double)lookDirection.y(), (double)lookDirection.z());
            playerPos = Minecraft.m_91087_().f_91074_.m_20318_(event.getPartialTick()).m_82549_(new Vec3(0.0, 1.0, 0.0)).m_82549_(lookDir);
            texture = new ResourceLocation("metallics_arts", "textures/veffects/the_idle4_60_yellow_translucent.png");
            sourceCameraVector = view.m_82546_(playerPos);
            if (anotherPlayerDeathPos == null) {
                DrawUtils.drawMetalQuadLines(event.getRenderTick(), view, transformationMatrix, new Vec3((double)player.f_19853_.m_6106_().m_6789_(), (double)(player.f_19853_.m_6106_().m_6527_() + 1), (double)player.f_19853_.m_6106_().m_6526_()), playerPos, 0.005, texture, 16, 8, 32);
            } else {
                DrawUtils.drawMetalQuadLines(event.getRenderTick(), view, transformationMatrix, Vec3.m_82512_((Vec3i)anotherPlayerDeathPos.m_122646_()), playerPos, 0.005, texture, 16, 8, 32);
            }
        }
    }

    private static void metalLines(int tick, float partialTick, Vec3 viewPosition, Matrix4f translationMatrix, Vec3 source, double scale, ResourceLocation texture, int numberOfFrames, int columnWidth, int columnHeight, List<Entity> entities, List<MetalBlockUtils> blocks) {
        for (Entity entity : entities) {
            DrawUtils.drawMetalQuadLines(tick, viewPosition, translationMatrix, entity.m_20318_(partialTick), source, scale, texture, numberOfFrames, columnWidth, columnHeight);
        }
        for (MetalBlockUtils block : blocks) {
            DrawUtils.drawMetalQuadLines(tick, viewPosition, translationMatrix, block.getCenter(), source, scale + scale * 0.1 * (double)block.size(), texture, numberOfFrames, columnWidth, columnHeight);
        }
    }

    private static void metalLines(int tick, float partialTick, Vec3 viewPosition, Matrix4f translationMatrix, Vec3 source, double scale, ResourceLocation texture, int numberOfFrames, int columnWidth, int columnHeight, List<Entity> entities) {
        for (Entity entity : entities) {
            DrawUtils.drawMetalQuadLines(tick, viewPosition, translationMatrix, entity.m_20318_(partialTick), source, scale, texture, numberOfFrames, columnWidth, columnHeight);
        }
    }

    public static void setRespawnPos(GlobalPos pos) {
        respawnPos = pos;
    }

    public static Optional<GlobalPos> getRespawnPos() {
        return Optional.of(respawnPos);
    }

    public static void setAnotherPlayerDeathPos(GlobalPos pos) {
        anotherPlayerDeathPos = pos;
    }

    public static Optional<GlobalPos> getAnotherPlayerDeathPos() {
        return Optional.of(anotherPlayerDeathPos);
    }

    private static void IronMetalLines(PoseStack stack, Vec3 playerCameraVector, Set<Entity> entities, Set<MetalBlockUtils> blocks) {
        for (Entity entity : entities) {
            DrawUtils.drawMetalLine(stack, playerCameraVector, entity.m_20182_(), LinesColorEnum.IRON.getSize(), LinesColorEnum.IRON.getR(), LinesColorEnum.IRON.getG(), LinesColorEnum.IRON.getB());
        }
        for (MetalBlockUtils block : blocks) {
            DrawUtils.drawMetalLine(stack, playerCameraVector, block.getCenter(), Mth.m_14036_((float)(0.3f + (float)block.size() * 0.4f), (float)0.5f, (float)7.5f), LinesColorEnum.IRON.getR(), LinesColorEnum.IRON.getG(), LinesColorEnum.IRON.getB());
        }
    }

    private static void SteelMetalLines(PoseStack stack, Vec3 playerCameraVector, Set<Entity> entities, Set<MetalBlockUtils> blocks) {
        for (Entity entity : entities) {
            DrawUtils.drawMetalLine(stack, playerCameraVector, entity.m_20182_(), LinesColorEnum.STEEL.getSize(), LinesColorEnum.STEEL.getR(), LinesColorEnum.STEEL.getG(), LinesColorEnum.STEEL.getB());
        }
        for (MetalBlockUtils block : blocks) {
            DrawUtils.drawMetalLine(stack, playerCameraVector, block.getCenter(), Mth.m_14036_((float)(0.3f + (float)block.size() * 0.4f), (float)0.5f, (float)7.5f), LinesColorEnum.STEEL.getR(), LinesColorEnum.STEEL.getG(), LinesColorEnum.STEEL.getB());
        }
    }

    private static void GoldMetalLines(PoseStack stack, Vec3 playerCameraVector, Optional<GlobalPos> globalPos) {
        if (globalPos.isPresent()) {
            BlockPos pos = globalPos.get().m_122646_();
            DrawUtils.drawMetalLine(stack, playerCameraVector, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), LinesColorEnum.GOLD.getSize(), LinesColorEnum.GOLD.getR(), LinesColorEnum.GOLD.getG(), LinesColorEnum.GOLD.getB());
        }
    }

    private static void ElectrumMetalLines(PoseStack stack, Vec3 playerCameraVector, Optional<GlobalPos> globalPos) {
        if (globalPos.isPresent()) {
            BlockPos pos = globalPos.get().m_122646_();
            DrawUtils.drawMetalLine(stack, playerCameraVector, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), LinesColorEnum.ELECTRUM.getSize(), LinesColorEnum.ELECTRUM.getR(), LinesColorEnum.ELECTRUM.getG(), LinesColorEnum.ELECTRUM.getB());
        }
    }

    private static void MalatiumMetalLines(PoseStack stack, Vec3 playerCameraVector, Optional<GlobalPos> globalPos) {
        if (globalPos.isPresent()) {
            BlockPos pos = globalPos.get().m_122646_();
            DrawUtils.drawMetalLine(stack, playerCameraVector, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), LinesColorEnum.MALATIUM.getSize(), LinesColorEnum.MALATIUM.getR(), LinesColorEnum.MALATIUM.getG(), LinesColorEnum.MALATIUM.getB());
        }
    }
}

