/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.client.custom_guis.selectors;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;
import net.rudahee.metallics_arts.setup.registries.ModKeyRegister;
import net.rudahee.metallics_arts.utils.CapabilityUtils;
import net.rudahee.metallics_arts.utils.ComparatorMetals;
import net.rudahee.metallics_arts.utils.powers_utils.ClientUtils;

@OnlyIn(value=Dist.CLIENT)
public class FeruchemySelector
extends Screen {
    private static final List<MetalTagEnum> internalMetals = Arrays.asList(MetalTagEnum.values()).stream().filter(metal -> !metal.isExternal() && !metal.isDivine()).sorted(new ComparatorMetals()).collect(Collectors.toList());
    private static final List<MetalTagEnum> externalMetals = Arrays.asList(MetalTagEnum.values()).stream().filter(metal -> metal.isExternal() && !metal.isDivine()).sorted(new ComparatorMetals()).collect(Collectors.toList());
    private static final List<MetalTagEnum> divineMetals = Arrays.asList(MetalTagEnum.values()).stream().filter(metal -> metal.isDivine()).sorted(new ComparatorMetals()).collect(Collectors.toList());
    private final Minecraft mc = Minecraft.m_91087_();
    private Player player;
    int slotSelected = -1;
    Point point1 = null;
    Point point2 = null;
    Point point3 = null;
    int tipoTemp = -1;
    boolean paridadTemp;
    MetalTagEnum metalTemp = null;
    int timeIn = 8;
    static int[] normalEven = new int[]{84, 91, 120, 255};
    static int[] normalOdd = new int[]{103, 110, 140, 255};
    static int[] noMetalMindEven = new int[]{125, 125, 125, 255};
    static int[] noMetalMindOdd = new int[]{109, 109, 109, 255};
    static int[] isTappingEven = new int[]{119, 173, 131, 255};
    static int[] isTappingOdd = new int[]{84, 142, 96, 255};
    static int[] isStorageEven = new int[]{206, 160, 32, 255};
    static int[] isStorageOdd = new int[]{235, 190, 68, 255};
    static int[] isCompoundingEven = new int[]{237, 130, 237, 255};
    static int[] isCompoundingOdd = new int[]{219, 65, 219, 255};

    public FeruchemySelector() {
        super((Component)Component.m_237115_((String)"metallic_arts_feruchemic_selector"));
    }

    public void m_86412_(PoseStack matrixStack, int mx, int my, float partialTicks) {
        super.m_86412_(matrixStack, mx, my, partialTicks);
        IInvestedPlayerData data = null;
        data = CapabilityUtils.getCapability((Player)Minecraft.m_91087_().f_91074_);
        Point center = new Point(this.f_96543_ / 2, this.f_96544_ / 2);
        Point mouse = new Point(mx, my);
        Point xPositivo = new Point((int)((double)center.x * 1.2), center.y);
        Point xNegativo = new Point(center.x - (xPositivo.x - center.x), center.y);
        Point yPositivo = new Point(center.x, center.y - (xPositivo.x - center.x));
        Point yNegativo = new Point(center.x, center.y + (xPositivo.x - center.x));
        Point xPositivoExterno = new Point(xPositivo.x + (xPositivo.x - center.x), center.y);
        Point xNegativoExterno = new Point(xNegativo.x - (xPositivo.x - center.x), center.y);
        Point yNegativoExterno = new Point(center.x, yNegativo.y + (xPositivo.x - center.x));
        Point yPositivoExterno = new Point(center.x, yPositivo.y - (xPositivo.x - center.x));
        Point intermedioXPosYNeg = new Point(xPositivo.x, yNegativo.y);
        Point intermedioXPosYPos = new Point(xPositivo.x, yPositivo.y);
        Point intermedioXNegYNeg = new Point(xNegativo.x, yNegativo.y);
        Point intermedioXNegYPos = new Point(xNegativo.x, yPositivo.y);
        Point intermedioXPosYNegExterno = new Point(xPositivoExterno.x, yNegativoExterno.y);
        Point intermedioXPosYPosExterno = new Point(xPositivoExterno.x, yPositivoExterno.y);
        Point intermedioXNegYNegExterno = new Point(xNegativoExterno.x, yNegativoExterno.y);
        Point intermedioXNegYPosExterno = new Point(xNegativoExterno.x, yPositivoExterno.y);
        int large = xPositivo.x - center.x;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buf.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        this.pintar(buf, xPositivo, intermedioXPosYNeg, xPositivoExterno, MetalTagEnum.BRASS, mouse, 2, true, data);
        this.pintar(buf, xPositivo, intermedioXPosYPos, xPositivoExterno, MetalTagEnum.ZINC, mouse, 1, false, data);
        this.pintar(buf, yPositivo, yPositivoExterno, intermedioXPosYPos, MetalTagEnum.IRON, mouse, 1, true, data);
        this.pintar(buf, yPositivo, yPositivoExterno, intermedioXNegYPos, MetalTagEnum.STEEL, mouse, 0, false, data);
        this.pintar(buf, xNegativo, intermedioXNegYPos, xNegativoExterno, MetalTagEnum.CHROMIUM, mouse, 0, true, data);
        this.pintar(buf, xNegativo, intermedioXNegYNeg, xNegativoExterno, MetalTagEnum.NICROSIL, mouse, 3, false, data);
        this.pintar(buf, yNegativo, yNegativoExterno, intermedioXNegYNeg, MetalTagEnum.CADMIUM, mouse, 3, true, data);
        this.pintar(buf, yNegativo, yNegativoExterno, intermedioXPosYNeg, MetalTagEnum.BENDALLOY, mouse, 2, false, data);
        this.pintar(buf, xPositivo, intermedioXPosYNeg, center, MetalTagEnum.BRONZE, mouse, 3, false, data);
        this.pintar(buf, xPositivo, intermedioXPosYPos, center, MetalTagEnum.COPPER, mouse, 0, true, data);
        this.pintar(buf, yPositivo, center, intermedioXPosYPos, MetalTagEnum.TIN, mouse, 2, false, data);
        this.pintar(buf, yPositivo, center, intermedioXNegYPos, MetalTagEnum.PEWTER, mouse, 3, true, data);
        this.pintar(buf, xNegativo, intermedioXNegYPos, center, MetalTagEnum.DURALUMIN, mouse, 1, false, data);
        this.pintar(buf, xNegativo, intermedioXNegYNeg, center, MetalTagEnum.ALUMINUM, mouse, 2, true, data);
        this.pintar(buf, yNegativo, center, intermedioXNegYNeg, MetalTagEnum.GOLD, mouse, 0, false, data);
        this.pintar(buf, yNegativo, center, intermedioXPosYNeg, MetalTagEnum.ELECTRUM, mouse, 1, true, data);
        this.pintar(buf, intermedioXPosYNegExterno, new Point(intermedioXPosYNegExterno.x, intermedioXPosYNegExterno.y - large), new Point(intermedioXPosYNegExterno.x - large, intermedioXPosYNegExterno.y), MetalTagEnum.ATIUM, mouse, 0, false, data);
        this.pintar(buf, intermedioXPosYPosExterno, new Point(intermedioXPosYPosExterno.x, intermedioXPosYPosExterno.y + large), new Point(intermedioXPosYPosExterno.x - large, intermedioXPosYPosExterno.y), MetalTagEnum.MALATIUM, mouse, 3, true, data);
        this.pintar(buf, intermedioXNegYNegExterno, new Point(intermedioXNegYNegExterno.x, intermedioXNegYNegExterno.y - large), new Point(intermedioXNegYNegExterno.x + large, intermedioXNegYNegExterno.y), MetalTagEnum.ETTMETAL, mouse, 1, true, data);
        this.pintar(buf, intermedioXNegYPosExterno, new Point(intermedioXNegYPosExterno.x, intermedioXNegYPosExterno.y + large), new Point(intermedioXNegYPosExterno.x + large, intermedioXNegYPosExterno.y), MetalTagEnum.LERASIUM, mouse, 2, false, data);
        if (this.point1 != null && this.point2 != null && this.point3 != null && this.tipoTemp != -1) {
            if (this.pointInTriangle(mouse, this.point1, this.point2, this.point3)) {
                if (data.hasMetalMindEquiped(this.metalTemp.getGroup())) {
                    this.pintadoUnico(buf, this.point1, this.point2, this.point3, this.metalTemp, mouse, this.paridadTemp, data);
                }
            } else {
                this.point1 = null;
                this.point2 = null;
                this.point3 = null;
                this.metalTemp = null;
            }
        }
        tess.m_85914_();
        if (this.metalTemp != MetalTagEnum.BRASS) {
            this.addpintado(matrixStack, xPositivo, intermedioXPosYNeg, xPositivoExterno, MetalTagEnum.BRASS, mouse, data.hasFeruchemicPower(MetalTagEnum.BRASS));
        }
        if (this.metalTemp != MetalTagEnum.ZINC) {
            this.addpintado(matrixStack, xPositivo, intermedioXPosYPos, xPositivoExterno, MetalTagEnum.ZINC, mouse, data.hasFeruchemicPower(MetalTagEnum.ZINC));
        }
        if (this.metalTemp != MetalTagEnum.IRON) {
            this.addpintado(matrixStack, yPositivo, yPositivoExterno, intermedioXPosYPos, MetalTagEnum.IRON, mouse, data.hasFeruchemicPower(MetalTagEnum.IRON));
        }
        if (this.metalTemp != MetalTagEnum.STEEL) {
            this.addpintado(matrixStack, yPositivo, yPositivoExterno, intermedioXNegYPos, MetalTagEnum.STEEL, mouse, data.hasFeruchemicPower(MetalTagEnum.STEEL));
        }
        if (this.metalTemp != MetalTagEnum.CHROMIUM) {
            this.addpintado(matrixStack, xNegativo, intermedioXNegYPos, xNegativoExterno, MetalTagEnum.CHROMIUM, mouse, data.hasFeruchemicPower(MetalTagEnum.CHROMIUM));
        }
        if (this.metalTemp != MetalTagEnum.NICROSIL) {
            this.addpintado(matrixStack, xNegativo, intermedioXNegYNeg, xNegativoExterno, MetalTagEnum.NICROSIL, mouse, data.hasFeruchemicPower(MetalTagEnum.NICROSIL));
        }
        if (this.metalTemp != MetalTagEnum.CADMIUM) {
            this.addpintado(matrixStack, yNegativo, yNegativoExterno, intermedioXNegYNeg, MetalTagEnum.CADMIUM, mouse, data.hasFeruchemicPower(MetalTagEnum.CADMIUM));
        }
        if (this.metalTemp != MetalTagEnum.BENDALLOY) {
            this.addpintado(matrixStack, yNegativo, yNegativoExterno, intermedioXPosYNeg, MetalTagEnum.BENDALLOY, mouse, data.hasFeruchemicPower(MetalTagEnum.BENDALLOY));
        }
        if (this.metalTemp != MetalTagEnum.BRONZE) {
            this.addpintado(matrixStack, xPositivo, intermedioXPosYNeg, center, MetalTagEnum.BRONZE, mouse, data.hasFeruchemicPower(MetalTagEnum.BRONZE));
        }
        if (this.metalTemp != MetalTagEnum.COPPER) {
            this.addpintado(matrixStack, xPositivo, intermedioXPosYPos, center, MetalTagEnum.COPPER, mouse, data.hasFeruchemicPower(MetalTagEnum.COPPER));
        }
        if (this.metalTemp != MetalTagEnum.TIN) {
            this.addpintado(matrixStack, yPositivo, center, intermedioXPosYPos, MetalTagEnum.TIN, mouse, data.hasFeruchemicPower(MetalTagEnum.TIN));
        }
        if (this.metalTemp != MetalTagEnum.PEWTER) {
            this.addpintado(matrixStack, yPositivo, center, intermedioXNegYPos, MetalTagEnum.PEWTER, mouse, data.hasFeruchemicPower(MetalTagEnum.PEWTER));
        }
        if (this.metalTemp != MetalTagEnum.DURALUMIN) {
            this.addpintado(matrixStack, xNegativo, intermedioXNegYPos, center, MetalTagEnum.DURALUMIN, mouse, data.hasFeruchemicPower(MetalTagEnum.DURALUMIN));
        }
        if (this.metalTemp != MetalTagEnum.ALUMINUM) {
            this.addpintado(matrixStack, xNegativo, intermedioXNegYNeg, center, MetalTagEnum.ALUMINUM, mouse, data.hasFeruchemicPower(MetalTagEnum.ALUMINUM));
        }
        if (this.metalTemp != MetalTagEnum.GOLD) {
            this.addpintado(matrixStack, yNegativo, center, intermedioXNegYNeg, MetalTagEnum.GOLD, mouse, data.hasFeruchemicPower(MetalTagEnum.GOLD));
        }
        if (this.metalTemp != MetalTagEnum.ELECTRUM) {
            this.addpintado(matrixStack, yNegativo, center, intermedioXPosYNeg, MetalTagEnum.ELECTRUM, mouse, data.hasFeruchemicPower(MetalTagEnum.ELECTRUM));
        }
        if (this.metalTemp != MetalTagEnum.ATIUM) {
            this.addpintado(matrixStack, intermedioXPosYNegExterno, new Point(intermedioXPosYNegExterno.x, intermedioXPosYNegExterno.y - large), new Point(intermedioXPosYNegExterno.x - large, intermedioXPosYNegExterno.y), MetalTagEnum.ATIUM, mouse, data.hasFeruchemicPower(MetalTagEnum.ATIUM));
        }
        if (this.metalTemp != MetalTagEnum.MALATIUM) {
            this.addpintado(matrixStack, intermedioXPosYPosExterno, new Point(intermedioXPosYPosExterno.x, intermedioXPosYPosExterno.y + large), new Point(intermedioXPosYPosExterno.x - large, intermedioXPosYPosExterno.y), MetalTagEnum.MALATIUM, mouse, data.hasFeruchemicPower(MetalTagEnum.MALATIUM));
        }
        if (this.metalTemp != MetalTagEnum.ETTMETAL) {
            this.addpintado(matrixStack, intermedioXNegYNegExterno, new Point(intermedioXNegYNegExterno.x, intermedioXNegYNegExterno.y - large), new Point(intermedioXNegYNegExterno.x + large, intermedioXNegYNegExterno.y), MetalTagEnum.ETTMETAL, mouse, data.hasFeruchemicPower(MetalTagEnum.ETTMETAL));
        }
        if (this.metalTemp != MetalTagEnum.LERASIUM) {
            this.addpintado(matrixStack, intermedioXNegYPosExterno, new Point(intermedioXNegYPosExterno.x, intermedioXNegYPosExterno.y + large), new Point(intermedioXNegYPosExterno.x + large, intermedioXNegYPosExterno.y), MetalTagEnum.LERASIUM, mouse, data.hasFeruchemicPower(MetalTagEnum.LERASIUM));
        }
        if (this.point1 != null && this.point2 != null && this.point3 != null) {
            this.addpintado(matrixStack, this.point1, this.point2, this.point3, this.metalTemp, mouse, data.hasFeruchemicPower(this.metalTemp));
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        RenderSystem.m_69461_();
    }

    public void addpintado(PoseStack matrixStack, Point a, Point b, Point c, MetalTagEnum metal, Point mouse, boolean hasPower) {
        Point vertex1 = new Point(a.x, a.y);
        Point vertex2 = new Point(b.x, b.y);
        Point vertex3 = new Point(c.x, c.y);
        Point baticenter = this.baticentro(vertex1, vertex2, vertex3);
        boolean inSelector = this.pointInTriangle(mouse, vertex1, vertex2, vertex3);
        if (hasPower && inSelector) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)("metallics_arts.metal_translate." + metal.getNameLower())), mouse.x, mouse.y);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("metallics_arts", "textures/item/symbols/feruchemic_symbols/" + metal.getNameLower() + "_symbol.png"));
        FeruchemySelector.m_93133_((PoseStack)matrixStack, (int)(baticenter.x - 8), (int)(baticenter.y - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
    }

    public Point baticentro(Point vertex1, Point vertex2, Point vertex3) {
        return new Point((vertex1.x + vertex2.x + vertex3.x) / 3, (vertex1.y + vertex2.y + vertex3.y) / 3);
    }

    public void pintar(BufferBuilder buf, Point a, Point b, Point c, MetalTagEnum metal, Point mouse, int tipo, boolean paridad, IInvestedPlayerData data) {
        Point vertex1 = new Point(a.x, a.y);
        Point vertex2 = new Point(b.x, b.y);
        Point vertex3 = new Point(c.x, c.y);
        boolean inSelector = this.pointInTriangle(mouse, vertex1, vertex2, vertex3);
        this.slotSelected = metal.getIndex();
        if (inSelector && data.hasMetalMindEquiped(metal.getGroup()) && data.hasFeruchemicPower(metal)) {
            if (tipo == 0) {
                vertex2.y -= 4;
                vertex3.x -= 4;
            } else if (tipo == 1) {
                vertex2.y -= 4;
                vertex3.x += 4;
            } else if (tipo == 2) {
                vertex2.y += 4;
                vertex3.x += 4;
            } else if (tipo == 3) {
                vertex2.y += 4;
                vertex3.x -= 4;
            }
            this.point1 = vertex1;
            this.point2 = vertex2;
            this.point3 = vertex3;
            this.tipoTemp = tipo;
            this.paridadTemp = paridad;
            this.metalTemp = metal;
        }
        int[] actualColor = paridad ? (!data.hasFeruchemicPower(metal) ? noMetalMindEven : (data.isStoring(metal) ? isStorageEven : (data.isTapping(metal) ? (!data.isBurning(metal) ? isTappingEven : isCompoundingEven) : normalEven))) : (!data.hasFeruchemicPower(metal) ? noMetalMindOdd : (data.isStoring(metal) ? isStorageOdd : (data.isTapping(metal) ? (!data.isBurning(metal) ? isTappingOdd : isCompoundingOdd) : normalOdd)));
        buf.m_5483_((double)a.x, (double)a.y, 0.0).m_6122_(actualColor[0], actualColor[1], actualColor[2], actualColor[3]).m_5752_();
        buf.m_5483_((double)b.x, (double)b.y, 0.0).m_6122_(actualColor[0], actualColor[1], actualColor[2], actualColor[3]).m_5752_();
        buf.m_5483_((double)c.x, (double)c.y, 0.0).m_6122_(actualColor[0], actualColor[1], actualColor[2], actualColor[3]).m_5752_();
    }

    public void pintadoUnico(BufferBuilder buf, Point a, Point b, Point c, MetalTagEnum metal, Point mouse, boolean paridad, IInvestedPlayerData data) {
        Point vertex1 = new Point(a.x, a.y);
        Point vertex2 = new Point(b.x, b.y);
        Point vertex3 = new Point(c.x, c.y);
        boolean inSelector = this.pointInTriangle(mouse, vertex1, vertex2, vertex3);
        if (inSelector) {
            this.slotSelected = metal.getIndex();
        }
        int[] actualColor = paridad ? (!data.hasFeruchemicPower(metal) ? noMetalMindEven : (data.isStoring(metal) ? isStorageEven : (data.isTapping(metal) ? (!data.isBurning(metal) ? isTappingEven : isCompoundingEven) : normalEven))) : (!data.hasFeruchemicPower(metal) ? noMetalMindOdd : (data.isStoring(metal) ? isStorageOdd : (data.isTapping(metal) ? (!data.isBurning(metal) ? isTappingOdd : isCompoundingOdd) : normalOdd)));
        buf.m_5483_((double)a.x, (double)a.y, 0.0).m_6122_(actualColor[0], actualColor[1], actualColor[2], actualColor[3]).m_5752_();
        buf.m_5483_((double)b.x, (double)b.y, 0.0).m_6122_(actualColor[0], actualColor[1], actualColor[2], actualColor[3]).m_5752_();
        buf.m_5483_((double)c.x, (double)c.y, 0.0).m_6122_(actualColor[0], actualColor[1], actualColor[2], actualColor[3]).m_5752_();
        ++this.timeIn;
    }

    public float sign(Point p1, Point p2, Point p3) {
        return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
    }

    public boolean pointInTriangle(Point pt, Point v1, Point v2, Point v3) {
        boolean b1 = this.sign(pt, v1, v2) < 0.0f;
        boolean b2 = this.sign(pt, v2, v3) < 0.0f;
        boolean b3 = this.sign(pt, v3, v1) < 0.0f;
        return b1 == b2 && b2 == b3;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.toggleSelectedRight();
        } else if (mouseButton == 0) {
            this.toggleSelectedLeft();
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7920_(int keysym, int scancode, int modifiers) {
        if (ModKeyRegister.FERUCHEMIC_POWER_SELECTOR.m_90832_(keysym, scancode)) {
            this.mc.m_91152_(null);
            this.mc.f_91067_.m_91601_();
            return true;
        }
        return super.m_7920_(keysym, scancode, modifiers);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (ModKeyRegister.FERUCHEMIC_POWER_SELECTOR.m_90830_(button)) {
            this.mc.m_91152_(null);
            this.mc.f_91067_.m_91601_();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void toggleSelectedRight() {
        if (this.slotSelected != -1) {
            MetalTagEnum metal = MetalTagEnum.getMetal(this.slotSelected);
            this.mc.f_91074_.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(data -> {
                ClientUtils.toggleStorage(metal, data, (Player)this.mc.f_91074_);
                this.mc.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.1f, 2.0f);
            });
        }
    }

    private void toggleSelectedLeft() {
        if (this.slotSelected != -1) {
            MetalTagEnum metal = MetalTagEnum.getMetal(this.slotSelected);
            this.mc.f_91074_.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(data -> {
                ClientUtils.toggleTap(metal, data, (Player)this.mc.f_91074_);
                this.mc.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.1f, 2.0f);
            });
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

