/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.logic.server.server_events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.error_handling.exceptions.PlayerException;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.god_metals.AtiumAllomanticHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.god_metals.MalatiumAllomanticHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.physical_metals.PewterAllomanticHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.spiritual_metals.ChromiumAllomanticHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.spiritual_metals.NicrosilAllomanticHelper;
import net.rudahee.metallics_arts.modules.logic.server.powers.feruchemy.cognitive_metals.BrassFeruchemicHelper;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.utils.ArmorUtils;
import net.rudahee.metallics_arts.utils.CapabilityUtils;

public class OnDamageEvent {
    public static void onDamageAllomantic(LivingHurtEvent event, ServerPlayer source, ServerPlayer target) {
        try {
            IInvestedPlayerData sourceCapability = CapabilityUtils.getCapability(source);
            IInvestedPlayerData targetCapability = CapabilityUtils.getCapability(target);
            if (sourceCapability.isBurning(MetalTagEnum.PEWTER)) {
                PewterAllomanticHelper.damageWithPewter(event, target, source, sourceCapability.getEnhanced());
            }
            if (sourceCapability.isBurning(MetalTagEnum.CHROMIUM)) {
                ChromiumAllomanticHelper.drainMetalChromium((Player)target, targetCapability);
            }
            if (sourceCapability.isBurning(MetalTagEnum.MALATIUM)) {
                if (target.m_219759_().isPresent()) {
                    MalatiumAllomanticHelper.setPos((GlobalPos)target.m_219759_().get());
                    ModNetwork.syncAnotherPlayerDeathPos((GlobalPos)target.m_219759_().get(), (Player)source);
                } else {
                    MalatiumAllomanticHelper.setPos(GlobalPos.m_122643_((ResourceKey)target.m_8963_(), (BlockPos)target.m_8961_()));
                    ModNetwork.syncAnotherPlayerDeathPos(GlobalPos.m_122643_((ResourceKey)target.m_8963_(), (BlockPos)target.m_8961_()), (Player)source);
                }
                MalatiumAllomanticHelper.setPosRegistered(true);
            }
            if (sourceCapability.isBurning(MetalTagEnum.NICROSIL)) {
                NicrosilAllomanticHelper.changeTargetEnhancedToTrue((Player)target, targetCapability);
            }
            if (targetCapability.isBurning(MetalTagEnum.ATIUM)) {
                event.setCanceled(AtiumAllomanticHelper.getCalculateComplexDamage(targetCapability, sourceCapability, ArmorUtils.hasAtiumArmor((LivingEntity)target)));
            }
        }
        catch (PlayerException ex) {
            ex.printCompleteLog();
        }
    }

    public static void onDamageFeruchemical(LivingHurtEvent event, ServerPlayer source, ServerPlayer target) {
        try {
            IInvestedPlayerData sourceCapability = CapabilityUtils.getCapability(source);
            IInvestedPlayerData targetCapability = CapabilityUtils.getCapability(target);
            if (sourceCapability.isTapping(MetalTagEnum.BRASS)) {
                BrassFeruchemicHelper.addFireAspectToPlayer(event.getEntity(), 4);
            }
            if (targetCapability.isTapping(MetalTagEnum.BRASS) && event.getSource().equals(event.getEntity().m_269291_().m_269109_())) {
                event.setCanceled(true);
            }
        }
        catch (PlayerException ex) {
            ex.printCompleteLog();
        }
    }

    public static void onDamageToArmor(LivingHurtEvent event, LivingEntity entity) {
        if (event.getSource().m_269415_().f_268677_().contains("explosion") && ArmorUtils.hasEttmetalArmor(entity)) {
            event.setAmount(event.getAmount() / 2.0f);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IInvestedPlayerData capability = CapabilityUtils.getCapability(player);
            if (capability == null) {
                return;
            }
            if (!capability.isBurning(MetalTagEnum.ATIUM) && ArmorUtils.hasAtiumArmor((LivingEntity)player)) {
                event.setCanceled(ArmorUtils.cancelHitWithAtiumArmor());
            }
        } else if (ArmorUtils.hasAtiumArmor(entity)) {
            event.setCanceled(ArmorUtils.cancelHitWithAtiumArmor());
        }
    }
}

