/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.rudahee.metallics_arts.data.providers.ModAdvancementsProvider;
import net.rudahee.metallics_arts.data.providers.ModBlockStateProvider;
import net.rudahee.metallics_arts.data.providers.ModEntityLootTableProvider;
import net.rudahee.metallics_arts.data.providers.ModItemModelProvider;
import net.rudahee.metallics_arts.data.providers.ModLootTableProvider;
import net.rudahee.metallics_arts.data.providers.ModRecipeProvider;
import net.rudahee.metallics_arts.data.providers.ModWorldGenerationProvider;
import net.rudahee.metallics_arts.data.providers.language_providers.ModLanguageProviderCAES;
import net.rudahee.metallics_arts.data.providers.language_providers.ModLanguageProviderEN;
import net.rudahee.metallics_arts.data.providers.language_providers.ModLanguageProviderES;
import net.rudahee.metallics_arts.data.providers.language_providers.ModLanguageProviderESAN;
import net.rudahee.metallics_arts.data.providers.language_providers.book.MetallicsArtsGuideBookProvider;
import net.rudahee.metallics_arts.data.providers.tags_providers.ModBannerTagProvider;
import net.rudahee.metallics_arts.data.providers.tags_providers.ModBlockTagProvider;
import net.rudahee.metallics_arts.data.providers.tags_providers.ModItemTagsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="metallics_arts", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @Generated
    private static final Logger log = LogManager.getLogger(DataGenerators.class);

    private DataGenerators() {
        throw new IllegalStateException("Class can't be instantiated");
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        log.info("Starting Generation: Model & States");
        gen.addProvider(event.includeServer(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemModelProvider(gen, existingFileHelper));
        log.info("Starting Generation: Loot Tables");
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModEntityLootTableProvider::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(ModLootTableProvider::new, LootContextParamSets.f_81421_))));
        log.info("Starting Generation: Recipes");
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(gen));
        log.info("Starting Generation: Languages");
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_es"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_ar"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_mx"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_uy"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_ve"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_cl"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderES(gen, "es_ec"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderEN(gen, "en_au"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderEN(gen, "en_ca"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderEN(gen, "en_gb"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderEN(gen, "en_nz"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderEN(gen, "en_us"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderESAN(gen, "esan"));
        gen.addProvider(true, (DataProvider)new ModAdvancementsProvider(gen.getPackOutput(), event.getLookupProvider(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderCAES(gen, "ca_es"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLanguageProviderCAES(gen, "val_es"));
        gen.addProvider(event.includeServer(), (DataProvider)new ModBannerTagProvider(packOutput, lookupProvider, existingFileHelper));
        log.info("Starting Generation: Guide Book");
        gen.addProvider(event.includeServer(), (DataProvider)new MetallicsArtsGuideBookProvider(gen, "metallics_arts", null));
        log.info("Starting Generation: WorldGen");
        gen.addProvider(event.includeServer(), (DataProvider)new ModWorldGenerationProvider(packOutput, lookupProvider));
        log.info("Starting Generation: Tags");
        ModBlockTagProvider blockTags = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
    }
}

