/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class BossPullEntityPacket {
    private final UUID inqusitorId;
    private final UUID playerId;
    private final int direction;
    private final int phase;

    public BossPullEntityPacket(UUID inqusitorId, UUID playerId, int direction, int phase) {
        this.inqusitorId = inqusitorId;
        this.playerId = playerId;
        this.direction = direction;
        this.phase = phase;
    }

    public static BossPullEntityPacket decode(FriendlyByteBuf buf) {
        return new BossPullEntityPacket(buf.m_130259_(), buf.m_130259_(), buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.inqusitorId);
        buf.m_130077_(this.playerId);
        buf.writeInt(this.direction);
        buf.writeInt(this.phase);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            if (serverLevel != null && this.inqusitorId != null && this.playerId != null) {
                Entity inquisitor = serverLevel.m_8791_(this.inqusitorId);
                Entity player = serverLevel.m_8791_(this.playerId);
                if (player.m_20159_()) {
                    player = player.m_20202_();
                }
                if (this.phase == 0) {
                    Vec3 motion = player.m_20182_().m_82546_(new Vec3(inquisitor.m_20185_(), inquisitor.m_20186_(), inquisitor.m_20189_())).m_82490_((double)this.direction);
                    player.m_20256_(motion);
                    player.f_19864_ = true;
                } else if (this.phase == 1) {
                    Vec3 motion = player.m_20182_().m_82546_(new Vec3(inquisitor.m_20185_(), inquisitor.m_20186_() + 4.0, inquisitor.m_20189_())).m_82490_((double)this.direction * 1.3);
                    player.m_6853_(false);
                    player.m_6469_(player.m_269291_().m_268989_(), 5.0f);
                    player.m_20256_(motion);
                    player.f_19864_ = true;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

