/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.physical_metals.IronAndSteelHelpers;

public class PullAndPushBlockPacket {
    private final BlockPos blockPos;
    private final int direction;

    public PullAndPushBlockPacket(BlockPos block, int direction) {
        this.blockPos = block;
        this.direction = direction;
    }

    public static PullAndPushBlockPacket decode(FriendlyByteBuf buf) {
        return new PullAndPushBlockPacket(buf.m_130135_(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeInt(this.direction);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos pos = this.blockPos;
            if (player.f_19853_.m_46749_(pos) && IronAndSteelHelpers.isBlockStateMetal(player.f_19853_.m_8055_(pos))) {
                IronAndSteelHelpers.move(this.direction, (Entity)player, pos);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

