/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.physical_metals.IronAndSteelHelpers;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class PullAndPushEntityPacket {
    private final int entityIDOther;
    private final int direction;

    public PullAndPushEntityPacket(int entityIDOther, int direction) {
        this.entityIDOther = entityIDOther;
        this.direction = direction;
    }

    public static PullAndPushEntityPacket decode(FriendlyByteBuf buf) {
        return new PullAndPushEntityPacket(buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityIDOther);
        buf.writeInt(this.direction);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer source = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity target = source.f_19853_.m_6815_(this.entityIDOther);
            boolean aluminumArmor = false;
            if (target != null && IronAndSteelHelpers.isEntityMetal(target)) {
                if (target instanceof IronGolem || target instanceof ItemFrame) {
                    IronAndSteelHelpers.move(this.direction, (Entity)source, target.m_20183_());
                } else if (target instanceof ItemEntity || target instanceof FallingBlockEntity || target instanceof ArmorStand || target instanceof AbstractMinecart && !target.m_20160_()) {
                    IronAndSteelHelpers.move((double)this.direction / 2.0, target, source.m_20183_());
                }
                if (target instanceof Player && !(aluminumArmor = StreamSupport.stream(target.m_6168_().spliterator(), false).allMatch(stack -> stack.m_41783_().toString().equals("aluminum")))) {
                    IInvestedPlayerData sourceCapability = (IInvestedPlayerData)source.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).resolve().get();
                    IInvestedPlayerData targetCapability = (IInvestedPlayerData)target.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).resolve().get();
                    boolean areInSameState = false;
                    if (sourceCapability.isTapping(MetalTagEnum.IRON) && targetCapability.isTapping(MetalTagEnum.IRON) || sourceCapability.isStoring(MetalTagEnum.IRON) && targetCapability.isStoring(MetalTagEnum.IRON)) {
                        areInSameState = true;
                    } else if (!sourceCapability.isTapping(MetalTagEnum.IRON) && !targetCapability.isTapping(MetalTagEnum.IRON) || !sourceCapability.isStoring(MetalTagEnum.IRON) && !targetCapability.isStoring(MetalTagEnum.IRON)) {
                        areInSameState = true;
                    }
                    if (areInSameState) {
                        IronAndSteelHelpers.move((double)this.direction / 2.0, target, source.m_20183_());
                        IronAndSteelHelpers.move((double)this.direction / 2.0, (Entity)source, target.m_20183_());
                    } else if (sourceCapability.isTapping(MetalTagEnum.IRON)) {
                        IronAndSteelHelpers.move(this.direction, target, target.m_20183_(), targetCapability.isStoring(MetalTagEnum.IRON));
                    } else if (sourceCapability.isStoring(MetalTagEnum.IRON)) {
                        IronAndSteelHelpers.move(this.direction, (Entity)source, source.m_20183_(), targetCapability.isTapping(MetalTagEnum.IRON));
                    } else if (!sourceCapability.isStoring(MetalTagEnum.IRON) && !sourceCapability.isTapping(MetalTagEnum.IRON)) {
                        if (targetCapability.isTapping(MetalTagEnum.IRON)) {
                            IronAndSteelHelpers.move(this.direction, (Entity)source, source.m_20183_(), true);
                        } else if (targetCapability.isStoring(MetalTagEnum.IRON)) {
                            IronAndSteelHelpers.move(this.direction, target, target.m_20183_(), false);
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

