/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class UpdateTapPacket {
    private final MetalTagEnum metal;
    private final boolean value;

    public UpdateTapPacket(MetalTagEnum metal, boolean value) {
        this.metal = metal;
        this.value = value;
    }

    public static UpdateTapPacket decode(FriendlyByteBuf buffer) {
        return new UpdateTapPacket((MetalTagEnum)buffer.m_130066_(MetalTagEnum.class), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.metal);
        buffer.writeBoolean(this.value);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).ifPresent(cap -> {
                if (cap.hasFeruchemicPower(this.metal)) {
                    cap.setTapping(this.metal, this.value);
                } else {
                    cap.setTapping(this.metal, false);
                }
                ModNetwork.syncInvestedDataPacket(cap, (Player)player);
            });
        });
        context.get().setPacketHandled(true);
    }
}

