/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.setup.registries.items;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.rudahee.metallics_arts.MetallicsArts;
import net.rudahee.metallics_arts.data.enums.implementations.GemsEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalEnum;
import net.rudahee.metallics_arts.setup.registries.ModBlocksRegister;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import net.rudahee.metallics_arts.setup.registries.ModSoundsRegister;

public class BasicItemsRegister {
    public static void register() {
        List<MetalEnum> metalList = Arrays.asList(MetalEnum.values());
        List<GemsEnum> gemList = Arrays.asList(GemsEnum.values());
        metalList.forEach(metal -> {
            MetallicsArts.registerItem(metal.getMetalNameLower() + "_ingot", () -> {
                Item item = new Item(new Item.Properties().m_41487_(64));
                ModItemsRegister.ITEM_METAL_INGOT.put(metal.getMetalNameLower(), item);
                if (metal.isAlloy().booleanValue()) {
                    // empty if block
                }
                return item;
            });
            MetallicsArts.registerItem(metal.getMetalNameLower() + "_nugget", () -> {
                Item item = new Item(new Item.Properties().m_41487_(64));
                ModItemsRegister.ITEM_METAL_NUGGET.put(metal.getMetalNameLower(), item);
                return item;
            });
            if (!metal.isAlloy().booleanValue()) {
                MetallicsArts.registerItem("raw_" + metal.getMetalNameLower(), () -> {
                    Item item = new Item(new Item.Properties().m_41487_(64));
                    ModItemsRegister.ITEM_RAW_METAL.put(metal.getMetalNameLower(), item);
                    return item;
                });
            }
        });
        MetallicsArts.registerItem("copper_nugget", () -> {
            Item item = new Item(new Item.Properties().m_41487_(64));
            ModItemsRegister.ITEM_METAL_NUGGET.put("copper", item);
            return item;
        });
        gemList.forEach(gem -> {
            MetallicsArts.registerItem(gem.getGemNameLower(), () -> {
                Item item = new Item(new Item.Properties());
                ModItemsRegister.ITEM_GEMS_BASE.put(gem.getGemNameLower(), item);
                if (gem.getGemNameLower() == "malatium") {
                    // empty if block
                }
                return item;
            });
            MetallicsArts.registerItem(gem.getGemNameLower() + "_nugget", () -> {
                Item item = new Item(new Item.Properties());
                ModItemsRegister.ITEM_GEMS_NUGGET.put(gem.getGemNameLower(), item);
                return item;
            });
        });
        ModItemsRegister.METALLICS_ARTS_BOOK = MetallicsArts.registerItem("metallics_arts_book", () -> new Item(new Item.Properties()));
        ModItemsRegister.IRON_SIGN = MetallicsArts.registerItem("iron_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)ModBlocksRegister.IRON_STANDING_SIGN.get(), (Block)ModBlocksRegister.IRON_WALL_SIGN.get()));
        ModItemsRegister.GOLD_SIGN = MetallicsArts.registerItem("gold_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)ModBlocksRegister.GOLD_STANDING_SIGN.get(), (Block)ModBlocksRegister.GOLD_WALL_SIGN.get()));
        ModItemsRegister.COPPER_SIGN = MetallicsArts.registerItem("copper_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)ModBlocksRegister.COPPER_STANDING_SIGN.get(), (Block)ModBlocksRegister.COPPER_WALL_SIGN.get()));
        ModItemsRegister.ALUMINUM_SIGN = MetallicsArts.registerItem("aluminum_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)ModBlocksRegister.ALUMINUM_STANDING_SIGN.get(), (Block)ModBlocksRegister.ALUMINUM_WALL_SIGN.get()));
        ModItemsRegister.SAZED_DISC = MetallicsArts.registerItem("sazed_disc", () -> new RecordItem(8, ModSoundsRegister.SAZED_SONG, new Item.Properties().m_41487_(1), 2180));
    }
}

