/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.NonNullSupplier;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.error_handling.exceptions.PlayerException;
import net.rudahee.metallics_arts.modules.error_handling.messages.ErrorTypes;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;

public class CapabilityUtils<T> {
    public static IInvestedPlayerData getCapability(@Nullable ServerPlayer player) throws PlayerException {
        if (player == null) {
            throw new PlayerException(ErrorTypes.PLAYER_ERROR);
        }
        if (player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).isPresent()) {
            return (IInvestedPlayerData)player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).orElseThrow((NonNullSupplier)new PlayerException(ErrorTypes.PLAYER_CAPABILITY_ERROR));
        }
        throw new PlayerException(ErrorTypes.PLAYER_CAPABILITY_ERROR);
    }

    public static IInvestedPlayerData getCapability(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        if (player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).isPresent()) {
            return (IInvestedPlayerData)player.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).orElse(null);
        }
        return null;
    }

    public static IInvestedPlayerData getCapability(@Nullable Entity entity) throws PlayerException {
        if (entity == null) {
            throw new PlayerException(ErrorTypes.PLAYER_ERROR);
        }
        if (entity.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).isPresent()) {
            return (IInvestedPlayerData)entity.getCapability(InvestedPlayerCapabilityRegister.PLAYER_CAP).orElseThrow((NonNullSupplier)new PlayerException(ErrorTypes.PLAYER_CAPABILITY_ERROR));
        }
        throw new PlayerException(ErrorTypes.PLAYER_CAPABILITY_ERROR);
    }

    public static AABB getBubble(Player player, int radius) {
        return new AABB(new BlockPos((Vec3i)player.m_20183_()).m_7918_(-radius, -radius, -radius), new BlockPos((Vec3i)player.m_20183_()).m_7918_(radius, radius, radius));
    }

    public HashMap<MetalTagEnum, T> fillMetalTagMap(T defaultValue) {
        HashMap<MetalTagEnum, T> map = new HashMap<MetalTagEnum, T>();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            map.put(metal, defaultValue);
        }
        return map;
    }

    public ArrayList<T> fillListWithDefaultValue(T defaultValue, int qty) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < qty; ++i) {
            list.add(defaultValue);
        }
        return list;
    }

    public static int getRadius(boolean enhanced, boolean lerasium, boolean compounding) {
        if (enhanced && lerasium && compounding) {
            return 18;
        }
        if (enhanced && lerasium) {
            return 16;
        }
        if (enhanced && compounding) {
            return 15;
        }
        if (lerasium && compounding) {
            return 13;
        }
        if (enhanced) {
            return 13;
        }
        if (lerasium) {
            return 11;
        }
        if (compounding) {
            return 10;
        }
        return 8;
    }
}

