/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.modules.logic.server.powers.allomancy.physical_metals.IronAndSteelHelpers;
import net.rudahee.metallics_arts.utils.powers_utils.MetalBlockUtils;

public class FoundNearbyMetalUtils {
    private static final Set<Entity> metalEntities = new HashSet<Entity>();
    private static List<BlockPos> nearbyAllomancers = new ArrayList<BlockPos>();
    private static final Set<MetalBlockUtils> metalBlobs = new HashSet<MetalBlockUtils>();

    @OnlyIn(value=Dist.CLIENT)
    public static Set<Entity> getMetalEntities() {
        return metalEntities;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Set<MetalBlockUtils> getMetalBlocks() {
        return metalBlobs;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void redoLists(Player player, IInvestedPlayerData playerCapability) {
        metalEntities.clear();
        metalBlobs.clear();
        if (playerCapability.isBurning(MetalTagEnum.IRON) || playerCapability.isBurning(MetalTagEnum.STEEL)) {
            int max = 8;
            BlockPos negative = player.m_20183_().m_7918_(-max, -max, -max);
            BlockPos positive = player.m_20183_().m_7918_(max, max, max);
            metalEntities.addAll(player.f_19853_.m_6443_(Entity.class, new AABB(negative, positive), e -> IronAndSteelHelpers.isEntityMetal(e) && !e.equals((Object)player)));
            Stream blocks = BlockPos.m_121990_((BlockPos)negative, (BlockPos)positive);
            blocks.filter(bp -> IronAndSteelHelpers.isBlockStateMetal(player.f_19853_.m_8055_(bp))).forEach(bp -> {
                Set matches = metalBlobs.stream().filter(mbl -> mbl.isMatch((BlockPos)bp)).collect(Collectors.toSet());
                switch (matches.size()) {
                    case 0: {
                        metalBlobs.add(new MetalBlockUtils((BlockPos)bp));
                        break;
                    }
                    case 1: {
                        ((MetalBlockUtils)matches.stream().findAny().get()).add((BlockPos)bp);
                        break;
                    }
                    default: {
                        metalBlobs.removeAll(matches);
                        MetalBlockUtils mbb = matches.stream().reduce(null, MetalBlockUtils::merge);
                        mbb.add((BlockPos)bp);
                        metalBlobs.add(mbb);
                    }
                }
            });
        }
    }

    public static List<BlockPos> getNearbyAllomancers() {
        return nearbyAllomancers;
    }

    public static void setNearbyAllomancers(List<BlockPos> nearbyAllomancers) {
    }
}

