/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils;

import java.util.ArrayList;
import net.rudahee.metallics_arts.data.enums.implementations.MetalEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.custom_items.MetalMindEnum;

public class GetItemsUtils {
    public static ArrayList<String> getRingList() {
        ArrayList<String> ringList = new ArrayList<String>();
        for (MetalMindEnum metalMindEnum : MetalMindEnum.values()) {
            ringList.add("metallics_arts_ring_" + metalMindEnum.getFirstMetal() + "_" + metalMindEnum.getSecondMetal());
            ringList.add("metallics_arts_ring_" + metalMindEnum.getFirstMetal() + "_" + metalMindEnum.getSecondMetal() + "_2");
        }
        return ringList;
    }

    public static ArrayList<String> getBandList() {
        ArrayList<String> bandList = new ArrayList<String>();
        for (MetalMindEnum metalMindEnum : MetalMindEnum.values()) {
            bandList.add("metallics_arts_band_" + metalMindEnum.getFirstMetal() + "_" + metalMindEnum.getSecondMetal());
            bandList.add("metallics_arts_band_" + metalMindEnum.getFirstMetal() + "_" + metalMindEnum.getSecondMetal() + "_2");
        }
        return bandList;
    }

    public static ArrayList<String> getSpikesList() {
        ArrayList<String> spikeList = new ArrayList<String>();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            spikeList.add("metallics_arts_spike_" + metal.getNameLower());
        }
        return spikeList;
    }

    public static ArrayList<String> getVialsList() {
        ArrayList<String> vialsList = new ArrayList<String>();
        vialsList.add("allomantic_small_vial");
        vialsList.add("allomantic_large_vial");
        return vialsList;
    }

    public static ArrayList<String> getIconsList() {
        ArrayList<String> iconsList = new ArrayList<String>();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            if (metal.isDivine()) continue;
            iconsList.add(metal.getNameLower() + "_allomantic_icon");
            iconsList.add(metal.getNameLower() + "_feruchemic_icon");
        }
        return iconsList;
    }

    public static ArrayList<String> getAlloysList() {
        ArrayList<String> alloyList = new ArrayList<String>();
        for (MetalEnum metal : MetalEnum.values()) {
            if (!metal.isAlloy().booleanValue()) continue;
            alloyList.add("metallics_arts_" + metal.getMetalNameLower() + "_alloy_craft");
        }
        return alloyList;
    }

    public static ArrayList<String> getPatterns() {
        ArrayList<String> patternsList = new ArrayList<String>();
        for (MetalTagEnum metal : MetalTagEnum.values()) {
            patternsList.add("metallics_arts_a_" + metal.getNameLower() + "_pattern");
            patternsList.add("metallics_arts_f_" + metal.getNameLower() + "_pattern");
        }
        return patternsList;
    }

    public static ArrayList<String> getCores() {
        ArrayList<String> coreList = new ArrayList<String>();
        coreList.add("metallics_arts_core_steel");
        coreList.add("metallics_arts_core_aluminum");
        coreList.add("metallics_arts_core_obsidian");
        return coreList;
    }

    public static ArrayList<String> getSteelArmor() {
        ArrayList<String> armorList = new ArrayList<String>();
        armorList.add("metallics_arts_armor_steel_helmet");
        armorList.add("metallics_arts_armor_steel_chestplate");
        armorList.add("metallics_arts_armor_steel_leggings");
        armorList.add("metallics_arts_armor_steel_boots");
        return armorList;
    }

    public static ArrayList<String> getAluminumArmor() {
        ArrayList<String> armorList = new ArrayList<String>();
        armorList.add("metallics_arts_armor_aluminum_helmet");
        armorList.add("metallics_arts_armor_aluminum_chestplate");
        armorList.add("metallics_arts_armor_aluminum_leggings");
        armorList.add("metallics_arts_armor_aluminum_boots");
        return armorList;
    }
}

