/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.utils.powers_utils;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.player.data.IInvestedPlayerData;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.setup.network.packets.UpdateBurnPacket;
import net.rudahee.metallics_arts.setup.network.packets.UpdateStoragePacket;
import net.rudahee.metallics_arts.setup.network.packets.UpdateTapPacket;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtils {
    private static int actualFeruchemicReserve = -1;
    private static boolean isBand = false;

    @Nullable
    public static HitResult getMouseOverExtended(float dist) {
        Minecraft mc = Minecraft.m_91087_();
        float partialTicks = mc.m_91296_();
        HitResult objectMouseOver = null;
        Entity entity = mc.m_91288_();
        if (entity != null && mc.f_91073_ != null) {
            objectMouseOver = entity.m_19907_((double)dist, partialTicks, false);
            Vec3 vec3d = entity.m_20299_(partialTicks);
            boolean flag = false;
            int i = 3;
            double d1 = objectMouseOver.m_82450_().m_82557_(vec3d);
            Vec3 vec3d1 = entity.m_20252_(1.0f);
            Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * (double)dist, vec3d1.f_82480_ * (double)dist, vec3d1.f_82481_ * (double)dist);
            float f = 1.0f;
            AABB axisalignedbb = entity.m_20191_().m_82369_(vec3d1.m_82490_((double)dist)).m_82377_(1.0, 1.0, 1.0);
            EntityHitResult entityraytraceresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3d, (Vec3)vec3d2, (AABB)axisalignedbb, e -> true, (double)d1);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.m_82443_();
                Vec3 vec3d3 = entityraytraceresult.m_82450_();
                double d2 = vec3d.m_82557_(vec3d3);
                if (d2 < d1) {
                    objectMouseOver = entityraytraceresult;
                }
            }
        }
        return objectMouseOver;
    }

    public static void toggleBurn(MetalTagEnum metal, IInvestedPlayerData capability) {
        if (!capability.hasAllomanticPower(metal) || capability.getAllomanticAmount(metal) == 0) {
            return;
        }
        ModNetwork.sendToServer(new UpdateBurnPacket(metal, !capability.isBurning(metal)));
        if (capability.getAllomanticAmount(metal) > 0) {
            capability.setBurning(metal, !capability.isBurning(metal));
        }
    }

    public static void toggleTap(MetalTagEnum metal, IInvestedPlayerData capability, Player player) {
        if (!capability.hasFeruchemicPower(metal) || !capability.hasMetalMindEquiped(metal.getGroup())) {
            return;
        }
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(curioData -> {
            for (int i = 0; i < curioData.getSlots(); ++i) {
                if (!curioData.getStackInSlot(i).m_41720_().m_5524_().toLowerCase().contains(metal.getNameLower())) continue;
                if (curioData.getStackInSlot(i).m_41782_()) {
                    actualFeruchemicReserve = curioData.getStackInSlot(i).m_41783_().m_128451_(metal.getNameLower() + "_feruchemic_reserve");
                }
                isBand = curioData.getStackInSlot(i).m_41720_().toString().toLowerCase().contains("band");
            }
        });
        if (actualFeruchemicReserve <= 0) {
            ModNetwork.sendToServer(new UpdateTapPacket(metal, false));
        } else {
            if (capability.isStoring(metal)) {
                ModNetwork.sendToServer(new UpdateStoragePacket(metal, false));
            }
            ModNetwork.sendToServer(new UpdateTapPacket(metal, !capability.isTapping(metal)));
        }
    }

    public static void toggleStorage(MetalTagEnum metal, IInvestedPlayerData capability, Player player) {
        if (!capability.hasFeruchemicPower(metal) || !capability.hasMetalMindEquiped(metal.getGroup())) {
            return;
        }
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(curioData -> {
            for (int i = 0; i < curioData.getSlots(); ++i) {
                if (!curioData.getStackInSlot(i).m_41720_().m_5524_().toLowerCase().contains(metal.getNameLower())) continue;
                if (curioData.getStackInSlot(i).m_41782_()) {
                    actualFeruchemicReserve = curioData.getStackInSlot(i).m_41783_().m_128451_(metal.getNameLower() + "_feruchemic_reserve");
                }
                isBand = curioData.getStackInSlot(i).m_41720_().toString().toLowerCase().contains("band");
            }
        });
        if (isBand) {
            if (actualFeruchemicReserve >= metal.getMaxReserveBand()) {
                ModNetwork.sendToServer(new UpdateStoragePacket(metal, false));
            } else {
                if (capability.isTapping(metal)) {
                    ModNetwork.sendToServer(new UpdateTapPacket(metal, false));
                }
                ModNetwork.sendToServer(new UpdateStoragePacket(metal, !capability.isStoring(metal)));
            }
        } else if (actualFeruchemicReserve >= metal.getMaxReserveRing()) {
            ModNetwork.sendToServer(new UpdateStoragePacket(metal, false));
        } else {
            if (capability.isTapping(metal)) {
                ModNetwork.sendToServer(new UpdateTapPacket(metal, false));
            }
            ModNetwork.sendToServer(new UpdateStoragePacket(metal, !capability.isStoring(metal)));
        }
    }

    public static void toggleCompounding(MetalTagEnum metal, IInvestedPlayerData capability, Player player) {
        if (!(capability.hasFeruchemicPower(metal) && capability.hasMetalMindEquiped(metal.getGroup()) && capability.hasAllomanticPower(metal) && capability.getAllomanticAmount(metal) != 0)) {
            return;
        }
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(curioData -> {
            for (int i = 0; i < curioData.getSlots(); ++i) {
                if (!curioData.getStackInSlot(i).m_41720_().m_5524_().toLowerCase().contains(metal.getNameLower()) || !curioData.getStackInSlot(i).m_41782_()) continue;
                actualFeruchemicReserve = curioData.getStackInSlot(i).m_41783_().m_128451_(metal.getNameLower() + "_feruchemic_reserve");
            }
        });
        if (actualFeruchemicReserve <= 0) {
            return;
        }
        if (capability.isTapping(metal) && capability.isBurning(metal)) {
            ModNetwork.sendToServer(new UpdateTapPacket(metal, false));
            ModNetwork.sendToServer(new UpdateBurnPacket(metal, false));
        } else {
            ModNetwork.sendToServer(new UpdateStoragePacket(metal, false));
            ModNetwork.sendToServer(new UpdateTapPacket(metal, true));
            ModNetwork.sendToServer(new UpdateBurnPacket(metal, true));
        }
    }
}

