/*
 * Decompiled with CFR 0.152.
 */
package niv.flowstone;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import niv.flowstone.api.Replacer;
import niv.flowstone.config.Configuration;
import niv.flowstone.impl.CustomGenerator;
import niv.flowstone.impl.DeepslateGenerator;
import niv.flowstone.impl.EndReplacer;
import niv.flowstone.impl.WorldlyGenerator;

public class Replacers {
    private static final Replacer NO_OP = (level, pos, state) -> state;
    private static final AtomicReference<Replacer> CONFIGURED_REPLACER = new AtomicReference();

    private Replacers() {
    }

    public static final Replacer allowedBlocksNullableReplacer(Collection<class_2248> blocks) {
        return new AllowedBlocksNullableReplacer((ImmutableList<class_2248>)ImmutableList.copyOf(blocks));
    }

    public static final Replacer allowedBlocksNullableReplacer(class_2248 ... blocks) {
        return new AllowedBlocksNullableReplacer((ImmutableList<class_2248>)ImmutableList.copyOf((Object[])blocks));
    }

    public static final Replacer defaultedMultiReplacer(List<Replacer> replacers) {
        return new DefaultedMultiReplacer((ImmutableList<Replacer>)ImmutableList.copyOf(replacers));
    }

    public static final Replacer defaultedMultiReplacer(Replacer ... replacers) {
        return new DefaultedMultiReplacer((ImmutableList<Replacer>)ImmutableList.copyOf((Object[])replacers));
    }

    public static final Runnable getInvalidator() {
        return () -> CONFIGURED_REPLACER.lazySet(null);
    }

    public static final Replacer configuredReplacer() {
        return CONFIGURED_REPLACER.updateAndGet(Replacers::update);
    }

    private static final Replacer update(Replacer value) {
        if (value == null) {
            ArrayList<Replacer> replacers = new ArrayList<Replacer>(3);
            if (Configuration.allowDeepslateGenerators()) {
                replacers.add(DeepslateGenerator.getReplacer());
            }
            if (Configuration.allowWorldlyGenerators()) {
                replacers.add(WorldlyGenerator.getReplacer());
            }
            if (Configuration.allowCustomGenerators()) {
                replacers.add(CustomGenerator.getReplacer());
            }
            if (Configuration.enableEndStoneGeneration()) {
                replacers.add(EndReplacer.getReplacer());
            }
            if (replacers.isEmpty()) {
                return NO_OP;
            }
            if (replacers.size() == 1) {
                return replacers.get(0);
            }
            return Replacers.defaultedMultiReplacer(replacers);
        }
        return value;
    }

    private record AllowedBlocksNullableReplacer(ImmutableList<class_2248> allowed) implements Replacer
    {
        public class_2680 apply(class_1936 level, class_2338 pos, class_2680 state) {
            return this.allowed().stream().anyMatch(arg_0 -> ((class_2680)state).method_27852(arg_0)) ? state : null;
        }
    }

    private record DefaultedMultiReplacer(ImmutableList<Replacer> replacers) implements Replacer
    {
        public class_2680 apply(class_1936 level, class_2338 pos, class_2680 state) {
            Optional<class_2680> result = Optional.of(state);
            for (Replacer replacer : this.replacers) {
                result = result.map(value -> (class_2680)replacer.apply(level, pos, value));
            }
            return result.orElse(state);
        }
    }
}

